/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.ECDefaults;
import ec.EvolutionState;
import ec.Group;
import ec.Individual;
import ec.Species;
import ec.util.Code;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashMap;

public class Subpopulation
implements Group {
    private static final long serialVersionUID = 1L;
    public boolean loadInds;
    public Parameter file;
    public Species species;
    public Individual[] individuals;
    public int numDuplicateRetries;
    public int extraBehavior;
    public static final String P_SUBPOPULATION = "subpop";
    public static final String P_FILE = "file";
    public static final String P_SUBPOPSIZE = "size";
    public static final String P_SPECIES = "species";
    public static final String P_RETRIES = "duplicate-retries";
    public static final String P_EXTRA_BEHAVIOR = "extra-behavior";
    public static final String V_TRUNCATE = "truncate";
    public static final String V_WRAP = "wrap";
    public static final String V_FILL = "fill";
    public static final String NUM_INDIVIDUALS_PREAMBLE = "Number of Individuals: ";
    public static final String INDIVIDUAL_INDEX_PREAMBLE = "Individual Number: ";
    public static final int TRUNCATE = 0;
    public static final int WRAP = 1;
    public static final int FILL = 2;
    boolean warned = false;

    public Parameter defaultBase() {
        return ECDefaults.base().push(P_SUBPOPULATION);
    }

    public Group emptyClone() {
        try {
            Subpopulation p = (Subpopulation)this.clone();
            p.species = this.species;
            p.individuals = new Individual[this.individuals.length];
            return p;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void resize(int toThis) {
        Individual[] temp = new Individual[toThis];
        System.arraycopy(this.individuals, 0, temp, 0, toThis);
        this.individuals = temp;
    }

    public void clear() {
        for (int i = 0; i < this.individuals.length; ++i) {
            this.individuals[i] = null;
        }
    }

    public void setup(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        this.file = base.push(P_FILE);
        this.loadInds = state.parameters.exists(this.file, null);
        this.species = (Species)state.parameters.getInstanceForParameter(base.push(P_SPECIES), def.push(P_SPECIES), Species.class);
        this.species.setup(state, base.push(P_SPECIES));
        int size = state.parameters.getInt(base.push(P_SUBPOPSIZE), def.push(P_SUBPOPSIZE), 1);
        if (size <= 0) {
            state.output.fatal("Subpopulation size must be an integer >= 1.\n", base.push(P_SUBPOPSIZE), def.push(P_SUBPOPSIZE));
        }
        this.numDuplicateRetries = state.parameters.getInt(base.push(P_RETRIES), def.push(P_RETRIES), 0);
        if (this.numDuplicateRetries < 0) {
            state.output.fatal("The number of retries for duplicates must be an integer >= 0.\n", base.push(P_RETRIES), def.push(P_RETRIES));
        }
        this.individuals = new Individual[size];
        this.extraBehavior = 0;
        if (this.loadInds) {
            String extra = state.parameters.getStringWithDefault(base.push(P_EXTRA_BEHAVIOR), def.push(P_EXTRA_BEHAVIOR), null);
            if (extra == null) {
                state.output.warning("Subpopulation is reading from a file, but no extra-behavior provided.  By default, subpopulation will be truncated to fit the file size.");
            } else if (extra.equalsIgnoreCase(V_TRUNCATE)) {
                this.extraBehavior = 0;
            } else if (extra.equalsIgnoreCase(V_FILL)) {
                this.extraBehavior = 2;
            } else if (extra.equalsIgnoreCase(V_WRAP)) {
                this.extraBehavior = 1;
            } else {
                state.output.fatal("Subpopulation given a bad extra-behavior: " + extra, base.push(P_EXTRA_BEHAVIOR), def.push(P_EXTRA_BEHAVIOR));
            }
        }
    }

    public void populate(EvolutionState state, int thread) {
        int len = this.individuals.length;
        int start = 0;
        if (this.loadInds) {
            InputStream stream = state.parameters.getResource(this.file, null);
            if (stream == null) {
                state.output.fatal("Could not load subpopulation from file", this.file);
            }
            try {
                this.readSubpopulation(state, new LineNumberReader(new InputStreamReader(stream)));
            }
            catch (IOException e) {
                state.output.fatal("An IOException occurred when trying to read from the file " + state.parameters.getString(this.file, null) + ".  The IOException was: \n" + e, this.file, null);
            }
            if (len < this.individuals.length) {
                state.output.message("Old subpopulation was of size " + len + ", expanding to size " + this.individuals.length);
                return;
            }
            if (len > this.individuals.length) {
                if (this.extraBehavior == 0) {
                    state.output.message("Old subpopulation was of size " + len + ", truncating to size " + this.individuals.length);
                    return;
                }
                if (this.extraBehavior == 1) {
                    state.output.message("Only " + this.individuals.length + " individuals were read in.  Subpopulation will stay size " + len + ", and the rest will be filled with copies of the read-in individuals.");
                    Individual[] oldInds = this.individuals;
                    this.individuals = new Individual[len];
                    System.arraycopy(oldInds, 0, this.individuals, 0, oldInds.length);
                    start = oldInds.length;
                    int count = 0;
                    for (int i = start; i < this.individuals.length; ++i) {
                        this.individuals[i] = (Individual)this.individuals[count].clone();
                        if (++count < start) continue;
                        count = 0;
                    }
                    return;
                }
                state.output.message("Only " + this.individuals.length + " individuals were read in.  Subpopulation will stay size " + len + ", and the rest will be filled using randomly generated individuals.");
                Individual[] oldInds = this.individuals;
                this.individuals = new Individual[len];
                System.arraycopy(oldInds, 0, this.individuals, 0, oldInds.length);
                start = oldInds.length;
            } else {
                return;
            }
        }
        HashMap<Individual, Individual> h = null;
        if (this.numDuplicateRetries >= 1) {
            h = new HashMap<Individual, Individual>((this.individuals.length - start) / 2);
        }
        block3: for (int x = start; x < this.individuals.length; ++x) {
            for (int tries = 0; tries <= this.numDuplicateRetries; ++tries) {
                Object o;
                this.individuals[x] = this.species.newIndividual(state, thread);
                if (this.numDuplicateRetries < 1 || (o = h.get(this.individuals[x])) != null) continue;
                h.put(this.individuals[x], this.individuals[x]);
                continue block3;
            }
        }
    }

    public final void printSubpopulationForHumans(EvolutionState state, int log, int verbosity) {
        this.printSubpopulationForHumans(state, log);
    }

    public final void printSubpopulation(EvolutionState state, int log, int verbosity) {
        this.printSubpopulation(state, log);
    }

    public void printSubpopulationForHumans(EvolutionState state, int log) {
        state.output.println(NUM_INDIVIDUALS_PREAMBLE + this.individuals.length, log);
        for (int i = 0; i < this.individuals.length; ++i) {
            state.output.println(INDIVIDUAL_INDEX_PREAMBLE + Code.encode(i), log);
            if (this.individuals[i] != null) {
                this.individuals[i].printIndividualForHumans(state, log);
                continue;
            }
            if (this.warned) continue;
            state.output.warnOnce("Null individuals found in subpopulation");
            this.warned = true;
        }
    }

    public void printSubpopulation(EvolutionState state, int log) {
        state.output.println(NUM_INDIVIDUALS_PREAMBLE + Code.encode(this.individuals.length), log);
        for (int i = 0; i < this.individuals.length; ++i) {
            state.output.println(INDIVIDUAL_INDEX_PREAMBLE + Code.encode(i), log);
            this.individuals[i].printIndividual(state, log);
        }
    }

    public void printSubpopulation(EvolutionState state, PrintWriter writer) {
        writer.println(NUM_INDIVIDUALS_PREAMBLE + Code.encode(this.individuals.length));
        for (int i = 0; i < this.individuals.length; ++i) {
            writer.println(INDIVIDUAL_INDEX_PREAMBLE + Code.encode(i));
            this.individuals[i].printIndividual(state, writer);
        }
    }

    public void readSubpopulation(EvolutionState state, LineNumberReader reader) throws IOException {
        int numIndividuals = Code.readIntegerWithPreamble(NUM_INDIVIDUALS_PREAMBLE, state, reader);
        if (numIndividuals < 1) {
            state.output.fatal("On reading subpopulation from text stream, the subpopulation size must be >= 1.  The provided value was: " + numIndividuals + ".");
        }
        if (numIndividuals != this.individuals.length) {
            state.output.warnOnce("On reading subpopulation from text stream, the current subpopulation size didn't match the number of individuals in the file.  The size of the subpopulation will be revised accordingly.  There were " + numIndividuals + " individuals in the file and " + this.individuals.length + " individuals expected for the subopulation.");
            this.individuals = new Individual[numIndividuals];
            for (int i = 0; i < this.individuals.length; ++i) {
                int j = Code.readIntegerWithPreamble(INDIVIDUAL_INDEX_PREAMBLE, state, reader);
                if (j != i) {
                    state.output.warnOnce("On reading subpopulation from text stream, some individual indexes in the subpopulation did not match.  The first was individual " + i + ", which is listed in the file as " + j);
                }
                this.individuals[i] = this.species.newIndividual(state, reader);
            }
        } else {
            for (int i = 0; i < this.individuals.length; ++i) {
                int j = Code.readIntegerWithPreamble(INDIVIDUAL_INDEX_PREAMBLE, state, reader);
                if (j != i) {
                    state.output.warnOnce("On reading subpopulation from text stream, some individual indexes in the subpopulation did not match.  The first was individual " + i + ", which is listed in the file as " + j);
                }
                if (this.individuals[i] != null) {
                    this.individuals[i].readIndividual(state, reader);
                    continue;
                }
                state.output.warnOnce("On reading subpopulation from text stream, some of the preexisting subpopulation's slots were null.  If you're starting an evolutionary run by reading an existing population from a file, this is expected -- ignore this message.");
                this.individuals[i] = this.species.newIndividual(state, reader);
            }
        }
    }

    public void writeSubpopulation(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.individuals.length);
        for (int i = 0; i < this.individuals.length; ++i) {
            this.individuals[i].writeIndividual(state, dataOutput);
        }
    }

    public void readSubpopulation(EvolutionState state, DataInput dataInput) throws IOException {
        int numIndividuals = dataInput.readInt();
        if (numIndividuals != this.individuals.length) {
            state.output.warnOnce("On reading subpopulation from binary stream, the subpopulation size was incorrect.\nHad to resize and use newIndividual() instead of readIndividual().");
            this.individuals = new Individual[numIndividuals];
            for (int i = 0; i < this.individuals.length; ++i) {
                this.individuals[i] = this.species.newIndividual(state, dataInput);
            }
        } else {
            for (int i = 0; i < this.individuals.length; ++i) {
                this.individuals[i].readIndividual(state, dataInput);
            }
        }
    }
}

