/*
 * Decompiled with CFR 0.152.
 */
package ec.app.ecsuite;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.vector.DoubleVectorIndividual;
import ec.vector.FloatVectorSpecies;

public class ECSuite
extends Problem
implements SimpleProblemForm {
    public static final String P_SEED = "seed";
    public static final String P_WHICH_PROBLEM = "type";
    public static final String V_ROSENBROCK = "rosenbrock";
    public static final String V_RASTRIGIN = "rastrigin";
    public static final String V_SPHERE = "sphere";
    public static final String V_STEP = "step";
    public static final String V_NOISY_QUARTIC = "noisy-quartic";
    public static final String V_F1 = "kdj-f1";
    public static final String V_F2 = "kdj-f2";
    public static final String V_F3 = "kdj-f3";
    public static final String V_F4 = "kdj-f4";
    public static final String V_BOOTH = "booth";
    public static final String V_GRIEWANGK = "griewangk";
    public static final String V_GRIEWANK = "griewank";
    public static final String V_MEDIAN = "median";
    public static final String V_SUM = "sum";
    public static final String V_PRODUCT = "product";
    public static final String V_SCHWEFEL = "schwefel";
    public static final String V_MIN = "min";
    public static final String V_ROTATED_RASTRIGIN = "rotated-rastrigin";
    public static final String V_ROTATED_SCHWEFEL = "rotated-schwefel";
    public static final String V_ROTATED_GRIEWANK = "rotated-griewank";
    public static final String V_LANGERMAN = "langerman";
    public static final String V_LENNARDJONES = "lennard-jones";
    public static final String V_LUNACEK = "lunacek";
    public static final int PROB_ROSENBROCK = 0;
    public static final int PROB_RASTRIGIN = 1;
    public static final int PROB_SPHERE = 2;
    public static final int PROB_STEP = 3;
    public static final int PROB_NOISY_QUARTIC = 4;
    public static final int PROB_BOOTH = 5;
    public static final int PROB_GRIEWANK = 6;
    public static final int PROB_MEDIAN = 7;
    public static final int PROB_SUM = 8;
    public static final int PROB_PRODUCT = 9;
    public static final int PROB_SCHWEFEL = 10;
    public static final int PROB_MIN = 11;
    public static final int PROB_ROTATED_RASTRIGIN = 12;
    public static final int PROB_ROTATED_SCHWEFEL = 13;
    public static final int PROB_ROTATED_GRIEWANK = 14;
    public static final int PROB_LANGERMAN = 15;
    public static final int PROB_LENNARDJONES = 16;
    public static final int PROB_LUNACEK = 17;
    public int problemType = 0;
    public static final String[] problemName = new String[]{"rosenbrock", "rastrigin", "sphere", "step", "noisy-quartic", "booth", "griewank", "median", "sum", "product", "schwefel", "min", "rotated-rastrigin", "rotated-schwefel", "rotated-griewank", "langerman", "lennard-jones", "lunacek"};
    public static final double[] minRange = new double[]{-2.048, -5.12, -5.12, -5.12, -1.28, -5.12, -600.0, 0.0, 0.0, 0.0, -512.03, 0.0, -5.12, -512.03, -600.0, 0.0, -3.0, -5.0};
    public static final double[] maxRange = new double[]{2.048, 5.12, 5.12, 5.12, 1.28, 5.12, 600.0, 1.0, 1.0, 2.0, 511.97, 1.0, 5.12, 511.97, 600.0, 10.0, 3.0, 5.0};
    public long seed;
    boolean alreadyChecked = false;
    private double[][] afox10 = new double[][]{{9.681, 0.667, 4.783, 9.095, 3.517, 9.325, 6.544, 0.211, 5.122, 2.02}, {9.4, 2.041, 3.788, 7.931, 2.882, 2.672, 3.568, 1.284, 7.033, 7.374}, {8.025, 9.152, 5.114, 7.621, 4.564, 4.711, 2.996, 6.126, 0.734, 4.982}, {2.196, 0.415, 5.649, 6.979, 9.51, 9.166, 6.304, 6.054, 9.377, 1.426}, {8.074, 8.777, 3.467, 1.863, 6.708, 6.349, 4.534, 0.276, 7.633, 1.567}, {7.65, 5.658, 0.72, 2.764, 3.278, 5.283, 7.474, 6.274, 1.409, 8.208}, {1.256, 3.605, 8.623, 6.905, 0.584, 8.133, 6.071, 6.888, 4.187, 5.448}, {8.314, 2.261, 4.224, 1.781, 4.124, 0.932, 8.129, 8.658, 1.208, 5.762}, {0.226, 8.858, 1.42, 0.945, 1.622, 4.698, 6.228, 9.096, 0.972, 7.637}, {7.305, 2.228, 1.242, 5.928, 9.133, 1.826, 4.06, 5.204, 8.713, 8.247}, {0.652, 7.027, 0.508, 4.876, 8.807, 4.632, 5.808, 6.937, 3.291, 7.016}, {2.699, 3.516, 5.874, 4.119, 4.461, 7.496, 8.817, 0.69, 6.593, 9.789}, {8.327, 3.897, 2.017, 9.57, 9.825, 1.15, 1.395, 3.885, 6.354, 0.109}, {2.132, 7.006, 7.136, 2.641, 1.882, 5.943, 7.273, 7.691, 2.88, 0.564}, {4.707, 5.579, 4.08, 0.581, 9.698, 8.542, 8.077, 8.515, 9.231, 4.67}, {8.304, 7.559, 8.567, 0.322, 7.128, 8.392, 1.472, 8.524, 2.277, 7.826}, {8.632, 4.409, 4.832, 5.768, 7.05, 6.715, 1.711, 4.323, 4.405, 4.591}, {4.887, 9.112, 0.17, 8.967, 9.693, 9.867, 7.508, 7.77, 8.382, 6.74}, {2.44, 6.686, 4.299, 1.007, 7.008, 1.427, 9.398, 8.48, 9.95, 1.675}, {6.306, 8.583, 6.084, 1.138, 4.35, 3.134, 7.853, 6.061, 7.457, 2.258}, {0.652, 0.343, 1.37, 0.821, 1.31, 1.063, 0.689, 8.819, 8.833, 9.07}, {5.558, 1.272, 5.756, 9.857, 2.279, 2.764, 1.284, 1.677, 1.244, 1.234}, {3.352, 7.549, 9.817, 9.437, 8.687, 4.167, 2.57, 6.54, 0.228, 0.027}, {8.798, 0.88, 2.37, 0.168, 1.701, 3.68, 1.231, 2.39, 2.499, 0.064}, {1.46, 8.057, 1.336, 7.217, 7.914, 3.615, 9.981, 9.198, 5.292, 1.224}, {0.432, 8.645, 8.774, 0.249, 8.081, 7.461, 4.416, 0.652, 4.002, 4.644}, {0.679, 2.8, 5.523, 3.049, 2.968, 7.225, 6.73, 4.199, 9.614, 9.229}, {4.263, 1.074, 7.286, 5.599, 8.291, 5.2, 9.214, 8.272, 4.398, 4.506}, {9.496, 4.83, 3.15, 8.27, 5.079, 1.231, 5.731, 9.494, 1.883, 9.732}, {4.138, 2.562, 2.532, 9.661, 5.611, 5.5, 6.886, 2.341, 9.699, 6.5}};
    private double[] cfox10 = new double[]{0.806, 0.517, 1.5, 0.908, 0.965, 0.669, 0.524, 0.902, 0.531, 0.876, 0.462, 0.491, 0.463, 0.714, 0.352, 0.869, 0.813, 0.811, 0.828, 0.964, 0.789, 0.36, 0.369, 0.992, 0.332, 0.817, 0.632, 0.883, 0.608, 0.326};
    public static double[][][] rotationMatrix = new double[1][][];
    public static final long ROTATION_SEED = 9731297L;

    public void checkRange(EvolutionState state, int problem, double[] genome) {
        if (this.alreadyChecked || state.generation > 0) {
            return;
        }
        this.alreadyChecked = true;
        for (int i = 0; i < state.population.subpops.length; ++i) {
            if (!(state.population.subpops[i].species instanceof FloatVectorSpecies)) {
                state.output.fatal("ECSuite requires species " + i + " to be a FloatVectorSpecies, but it is a: " + state.population.subpops[i].species);
            }
            FloatVectorSpecies species = (FloatVectorSpecies)state.population.subpops[i].species;
            for (int k = 0; k < genome.length; ++k) {
                if (species.minGene(k) == minRange[problem] && species.maxGene(k) == maxRange[problem]) continue;
                state.output.warning("Gene range is nonstandard for problem " + problemName[problem] + ".\nFirst occurrence: Subpopulation " + i + " Gene " + k + " range was [" + species.minGene(k) + ", " + species.maxGene(k) + "], expected [" + minRange[problem] + ", " + maxRange[problem] + "]");
                return;
            }
        }
        if (this.problemType == 15) {
            if (genome.length > 10) {
                state.output.fatal("The Langerman function requires that the genome size be a value from 1 to 10 inclusive.  It is presently " + genome.length);
            }
        } else if (this.problemType == 16 && genome.length % 3 != 0) {
            state.output.fatal("The Lennard-Jones function requires that the genome size be a multiple of 3.  It is presently " + genome.length);
        }
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        String wp = state.parameters.getStringWithDefault(base.push(P_WHICH_PROBLEM), null, "");
        if (wp.compareTo(V_ROSENBROCK) == 0 || wp.compareTo(V_F2) == 0) {
            this.problemType = 0;
        } else if (wp.compareTo(V_RASTRIGIN) == 0) {
            this.problemType = 1;
        } else if (wp.compareTo(V_SPHERE) == 0 || wp.compareTo(V_F1) == 0) {
            this.problemType = 2;
        } else if (wp.compareTo(V_STEP) == 0 || wp.compareTo(V_F3) == 0) {
            this.problemType = 3;
        } else if (wp.compareTo(V_NOISY_QUARTIC) == 0 || wp.compareTo(V_F4) == 0) {
            this.problemType = 4;
        } else if (wp.compareTo(V_BOOTH) == 0) {
            this.problemType = 5;
        } else if (wp.compareTo(V_GRIEWANK) == 0) {
            this.problemType = 6;
        } else if (wp.compareTo(V_GRIEWANGK) == 0) {
            state.output.warning("Incorrect parameter name (\"griewangk\") used, should be \"griewank\"", base.push(P_WHICH_PROBLEM), null);
            this.problemType = 6;
        } else if (wp.compareTo(V_MEDIAN) == 0) {
            this.problemType = 7;
        } else if (wp.compareTo(V_SUM) == 0) {
            this.problemType = 8;
        } else if (wp.compareTo(V_PRODUCT) == 0) {
            this.problemType = 9;
        } else if (wp.compareTo(V_SCHWEFEL) == 0) {
            this.problemType = 10;
        } else if (wp.compareTo(V_MIN) == 0) {
            this.problemType = 11;
        } else if (wp.compareTo(V_ROTATED_RASTRIGIN) == 0) {
            this.problemType = 12;
        } else if (wp.compareTo(V_ROTATED_SCHWEFEL) == 0) {
            this.problemType = 13;
        } else if (wp.compareTo(V_ROTATED_GRIEWANK) == 0) {
            this.problemType = 14;
        } else if (wp.compareTo(V_LANGERMAN) == 0) {
            this.problemType = 15;
        } else if (wp.compareTo(V_LENNARDJONES) == 0) {
            this.problemType = 16;
        } else if (wp.compareTo(V_LUNACEK) == 0) {
            this.problemType = 17;
        } else {
            state.output.fatal("Invalid value for parameter, or parameter not found.\nAcceptable values are:\n  rosenbrock (or kdj-f2)\n  rastrigin\n  sphere (or kdj-f1)\n  step (or kdj-f3)\n  noisy-quartic (or kdj-f4)\n  booth\n  griewank\n  median\n  sum\n  product\n  schwefel\n  min\n  rotated-rastrigin\n  rotated-schwefel\n  rotated-griewank\n  langerman\n  lennard-jones\n  lunacek\n", base.push(P_WHICH_PROBLEM));
        }
        this.seed = state.parameters.getLongWithDefault(base.push(P_SEED), null, 9731297L);
        if (this.seed <= 0L) {
            state.output.fatal("If a rotation seed is provided, it must be > 0", base.push(P_SEED), null);
        }
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (ind.evaluated) {
            return;
        }
        if (!(ind instanceof DoubleVectorIndividual)) {
            state.output.fatal("The individuals for this problem should be DoubleVectorIndividuals.");
        }
        DoubleVectorIndividual temp = (DoubleVectorIndividual)ind;
        double[] genome = temp.genome;
        double fit = this.function(state, this.problemType, temp.genome, threadnum);
        boolean isOptimal = this.isOptimal(this.problemType, fit);
        if (fit < -1.7976931348623157E308) {
            ((SimpleFitness)ind.fitness).setFitness(state, -1.7976931348623157E308, isOptimal);
            state.output.warnOnce("'Product' type used: some fitnesses are negative infinity, setting to lowest legal negative number.");
        } else if (fit > Double.MAX_VALUE) {
            ((SimpleFitness)ind.fitness).setFitness(state, Double.MAX_VALUE, isOptimal);
            state.output.warnOnce("'Product' type used: some fitnesses are negative infinity, setting to lowest legal negative number.");
        } else {
            ((SimpleFitness)ind.fitness).setFitness(state, fit, isOptimal);
        }
        ind.evaluated = true;
    }

    public boolean isOptimal(int function, double fitness) {
        switch (this.problemType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return fitness == 0.0;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double function(EvolutionState state, int function, double[] genome, int threadnum) {
        this.checkRange(state, function, genome);
        double value = 0.0;
        double len = genome.length;
        switch (function) {
            case 0: {
                int i = 1;
                while ((double)i < len) {
                    double gj = genome[i - 1];
                    double gi = genome[i];
                    value += 100.0 * (gj * gj - gj) * (gj * gj - gj) + (1.0 - gj) * (1.0 - gj);
                    ++i;
                }
                return -value;
            }
            case 1: {
                double A = 10.0;
                value = len * 10.0;
                int i = 0;
                while ((double)i < len) {
                    double gi = genome[i];
                    value += gi * gi - 10.0 * Math.cos(Math.PI * 2 * gi);
                    ++i;
                }
                return -value;
            }
            case 2: {
                int i = 0;
                while ((double)i < len) {
                    double gi = genome[i];
                    value += gi * gi;
                    ++i;
                }
                return -value;
            }
            case 3: {
                int i = 0;
                while ((double)i < len) {
                    double gi = genome[i];
                    value += 6.0 + Math.floor(gi);
                    ++i;
                }
                return -value;
            }
            case 4: {
                int i = 0;
                while ((double)i < len) {
                    double gi = genome[i];
                    value += (double)(i + 1) * (gi * gi * gi * gi) + state.random[threadnum].nextDouble();
                    ++i;
                }
                return -value;
            }
            case 5: {
                if (len != 2.0) {
                    state.output.fatal("The Booth problem is defined for only two terms, and as a consequence the genome of the DoubleVectorIndividual should have size 2.");
                }
                double g0 = genome[0];
                double g1 = genome[1];
                value = (g0 + 2.0 * g1 - 7.0) * (g0 + 2.0 * g1 - 7.0) + (2.0 * g0 + g1 - 5.0) * (2.0 * g0 + g1 - 5.0);
                return -value;
            }
            case 6: {
                value = 1.0;
                double prod = 1.0;
                int i = 0;
                while ((double)i < len) {
                    double gi = genome[i];
                    value += gi * gi / 4000.0;
                    prod *= Math.cos(gi / Math.sqrt(i + 1));
                    ++i;
                }
                return -(value -= prod);
            }
            case 10: {
                int i = 0;
                while ((double)i < len) {
                    double gi = genome[i];
                    value += -gi * Math.sin(Math.sqrt(Math.abs(gi)));
                    ++i;
                }
                return -value;
            }
            case 7: {
                double[] sorted = new double[(int)len];
                System.arraycopy(genome, 0, sorted, 0, sorted.length);
                QuickSort.qsort(sorted);
                return sorted[sorted.length / 2];
            }
            case 8: {
                value = 0.0;
                int i = 0;
                while ((double)i < len) {
                    double gi = genome[i];
                    value += gi;
                    ++i;
                }
                return value;
            }
            case 11: {
                value = genome[0];
                int i = 1;
                while ((double)i < len) {
                    double gi = genome[i];
                    if (value > gi) {
                        value = gi;
                    }
                    ++i;
                }
                return value;
            }
            case 9: {
                value = 1.0;
                int i = 0;
                while ((double)i < len) {
                    double gi = genome[i];
                    value *= gi;
                    ++i;
                }
                return value;
            }
            case 12: {
                double[][][] i = rotationMatrix;
                synchronized (rotationMatrix) {
                    if (rotationMatrix[0] == null) {
                        ECSuite.rotationMatrix[0] = ECSuite.buildRotationMatrix(state, this.seed, (int)len);
                    }
                    // ** MonitorExit[i] (shouldn't be in output)
                    double[] val = ECSuite.mul(rotationMatrix[0], genome);
                    return this.function(state, 1, val, threadnum);
                }
            }
            case 13: {
                Object val = rotationMatrix;
                synchronized (rotationMatrix) {
                    if (rotationMatrix[0] == null) {
                        ECSuite.rotationMatrix[0] = ECSuite.buildRotationMatrix(state, this.seed, (int)len);
                    }
                    // ** MonitorExit[val /* !! */ ] (shouldn't be in output)
                    val = ECSuite.mul(rotationMatrix[0], genome);
                    return this.function(state, 10, (double[])val, threadnum);
                }
            }
            case 14: {
                Object val = rotationMatrix;
                synchronized (rotationMatrix) {
                    if (rotationMatrix[0] == null) {
                        ECSuite.rotationMatrix[0] = ECSuite.buildRotationMatrix(state, this.seed, (int)len);
                    }
                    // ** MonitorExit[val /* !! */ ] (shouldn't be in output)
                    val = ECSuite.mul(rotationMatrix[0], genome);
                    return this.function(state, 6, (double[])val, threadnum);
                }
            }
            case 15: {
                return 0.0 - this.langerman(genome);
            }
            case 16: {
                int numAtoms = genome.length / 3;
                double v = 0.0;
                for (int i = 0; i < numAtoms - 1; ++i) {
                    for (int j = i + 1; j < numAtoms; ++j) {
                        double a = genome[i * 3] - genome[j * 3];
                        double b = genome[i * 3 + 1] - genome[j * 3 + 1];
                        double c = genome[i * 3 + 2] - genome[j * 3 + 2];
                        double d = Math.sqrt(a * a + b * b + c * c);
                        double r12 = Math.pow(d, -12.0);
                        double r6 = Math.pow(d, -6.0);
                        double e = r12 - r6;
                        v += e;
                    }
                }
                return v *= -4.0;
            }
            case 17: {
                double s = 0.7;
                double d = 1.0;
                double mu1 = 0.0;
                for (int i = 0; i < genome.length; ++i) {
                    mu1 = genome[i];
                }
                double mu2 = -1.0 * Math.sqrt((mu1 * mu1 - d) / s);
                double sigma1 = 0.0;
                double sigma2 = 0.0;
                for (int i = 0; i < genome.length; ++i) {
                    sigma1 = (genome[i] - mu1) * (genome[i] - mu1);
                    sigma2 = (genome[i] - mu2) * (genome[i] - mu2);
                }
                sigma2 = d * (double)genome.length + s * sigma1;
                double sphere = Math.min(sigma1, sigma2);
                double rastrigin = this.function(state, 1, genome, threadnum);
                return -1.0 * (sphere + rastrigin);
            }
        }
        state.output.fatal("ec.app.ecsuite.ECSuite has an invalid problem -- how on earth did that happen?");
        return 0.0;
    }

    private double langerman(double[] genome) {
        double sum = 0.0;
        for (int i = 0; i < 30; ++i) {
            double distsq = 0.0;
            double[] afox10i = this.afox10[i];
            for (int j = 0; j < genome.length; ++j) {
                double t = genome[j] - afox10i[j];
                distsq += t * t;
            }
            sum += this.cfox10[i] * Math.exp(-distsq / Math.PI) * Math.cos(distsq * Math.PI);
        }
        return 0.0 - sum;
    }

    public static double dot(double[] x, double[] y) {
        double val = 0.0;
        for (int i = 0; i < x.length; ++i) {
            val += x[i] * y[i];
        }
        return val;
    }

    public static double[] mul(double[][] matrix, double[] x) {
        double[] val = new double[matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            double sum = 0.0;
            double[] m = matrix[i];
            for (int j = 0; j < m.length; ++j) {
                sum += m[j] * x[j];
            }
            val[i] = sum;
        }
        return val;
    }

    public static double[] scalarMul(double scalar, double[] x) {
        double[] val = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            val[i] = x[i] * scalar;
        }
        return val;
    }

    public static double[] sub(double[] x, double[] y) {
        double[] val = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            val[i] = x[i] - y[i];
        }
        return val;
    }

    public static double[] normalize(double[] x) {
        int i;
        double[] val = new double[x.length];
        double sumsq = 0.0;
        for (i = 0; i < x.length; ++i) {
            sumsq += x[i] * x[i];
        }
        sumsq = Math.sqrt(sumsq);
        for (i = 0; i < x.length; ++i) {
            val[i] = x[i] / sumsq;
        }
        return val;
    }

    public static double[][] buildRotationMatrix(EvolutionState state, long rotationSeed, int N) {
        int i;
        if (rotationSeed == 9731297L) {
            state.output.warnOnce("Default rotation seed being used (" + rotationSeed + ")");
        }
        MersenneTwisterFast rand = new MersenneTwisterFast(rotationSeed);
        for (int i2 = 0; i2 < 2496; ++i2) {
            rand.nextInt();
        }
        double[][] o = new double[N][N];
        for (i = 0; i < N; ++i) {
            for (int k = 0; k < N; ++k) {
                o[i][k] = rand.nextGaussian();
            }
        }
        for (i = 0; i < N; ++i) {
            double[] no = new double[N];
            for (int k = 0; k < N; ++k) {
                no[k] = o[i][k];
            }
            for (int j = 0; j < i; ++j) {
                double d = ECSuite.dot(o[i], o[j]);
                double[] val = ECSuite.scalarMul(d, o[j]);
                no = ECSuite.sub(no, val);
            }
            o[i] = ECSuite.normalize(no);
        }
        return o;
    }
}

