/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.breed.BreedDefaults;
import ec.util.Parameter;
import java.util.HashSet;

public class UniquePipeline
extends BreedingPipeline {
    public static final String P_UNIQUE = "unique";
    public static final String P_GEN_MAX = "generate-max";
    public static final String P_RETRIES = "duplicate-retries";
    public static final int NUM_SOURCES = 1;
    public HashSet set = new HashSet();
    public boolean resetEachGeneration;
    public int numDuplicateRetries;
    boolean generateMax;

    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_UNIQUE);
    }

    public int numSources() {
        return 1;
    }

    public Object clone() {
        UniquePipeline c = (UniquePipeline)super.clone();
        c.set = (HashSet)this.set.clone();
        return c;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.generateMax = state.parameters.getBoolean(base.push(P_GEN_MAX), def.push(P_GEN_MAX), false);
        if (this.likelihood != 1.0) {
            state.output.warning("UniquePipeline given a likelihood other than 1.0.  This is nonsensical and will be ignored.", base.push("likelihood"), def.push("likelihood"));
        }
        this.numDuplicateRetries = state.parameters.getInt(base.push(P_RETRIES), def.push(P_RETRIES), 0);
        if (this.numDuplicateRetries < 0) {
            state.output.fatal("The number of retries for duplicates must be an integer >= 0.\n", base.push(P_RETRIES), def.push(P_RETRIES));
        }
    }

    public void prepareToProduce(EvolutionState state, int subpopulation, int thread) {
        this.set.clear();
        Individual[] inds = state.population.subpops[subpopulation].individuals;
        for (int i = 0; i < inds.length; ++i) {
            this.set.add(inds[i]);
        }
    }

    int removeDuplicates(Individual[] inds, int start, int num) {
        for (int i = start; i < start + num; ++i) {
            if (!this.set.contains(inds[i])) continue;
            inds[i] = inds[start + num - 1];
            inds[start + num - 1] = null;
            --num;
            --i;
        }
        return num;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n = 0;
        int remainder = this.generateMax ? max : min;
        for (int retry = 0; retry < this.numDuplicateRetries + 1; ++retry) {
            int newmin = Math.min(Math.max(min - n, 1), max - n);
            int num = this.sources[0].produce(newmin, max - n, start + n, subpopulation, inds, state, thread);
            int total = this.removeDuplicates(inds, start + n, num);
            n += total;
        }
        if (n < remainder) {
            n += this.sources[0].produce(remainder - n, max - n, start + n, subpopulation, inds, state, thread);
        }
        return n;
    }
}

