/*
 * Decompiled with CFR 0.152.
 */
package ec.gp;

import ec.EvolutionState;
import ec.Individual;
import ec.gp.GPDefaults;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPTree;
import ec.util.Code;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class GPIndividual
extends Individual {
    private static final long serialVersionUID = 1L;
    public static final String P_NUMTREES = "numtrees";
    public static final String P_TREE = "tree";
    public GPTree[] trees;

    public Parameter defaultBase() {
        return GPDefaults.base().push("individual");
    }

    public boolean equals(Object ind) {
        if (ind == null) {
            return false;
        }
        if (!this.getClass().equals(ind.getClass())) {
            return false;
        }
        GPIndividual i = (GPIndividual)ind;
        if (this.trees.length != i.trees.length) {
            return false;
        }
        for (int x = 0; x < this.trees.length; ++x) {
            if (this.trees[x].treeEquals(i.trees[x])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        for (int x = 0; x < this.trees.length; ++x) {
            hash = (hash << 1 | hash >>> 31) ^ this.trees[x].treeHashCode();
        }
        return hash;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.evaluated = false;
        int t = state.parameters.getInt(base.push(P_NUMTREES), def.push(P_NUMTREES), 1);
        if (t <= 0) {
            state.output.fatal("A GPIndividual must have at least one tree.", base.push(P_NUMTREES), def.push(P_NUMTREES));
        }
        this.trees = new GPTree[t];
        for (int x = 0; x < t; ++x) {
            Parameter p = base.push(P_TREE).push("" + x);
            this.trees[x] = (GPTree)state.parameters.getInstanceForParameterEq(p, def.push(P_TREE).push("" + x), GPTree.class);
            this.trees[x].owner = this;
            this.trees[x].setup(state, p);
        }
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (int x = 0; x < t; ++x) {
            for (int w = 0; w < this.trees[x].constraints((GPInitializer)initializer).functionset.nodes.length; ++w) {
                GPNode[] gpfi = this.trees[x].constraints((GPInitializer)initializer).functionset.nodes[w];
                for (int y = 0; y < gpfi.length; ++y) {
                    gpfi[y].checkConstraints(state, x, this, base);
                }
            }
        }
        state.output.exitIfErrors();
    }

    public void verify(EvolutionState state) {
        int x;
        if (!(state.initializer instanceof GPInitializer)) {
            state.output.error("Initializer is not a GPInitializer");
            return;
        }
        if (this.trees == null) {
            state.output.error("Null trees in GPIndividual.");
            return;
        }
        for (x = 0; x < this.trees.length; ++x) {
            if (this.trees[x] != null) continue;
            state.output.error("Null tree (#" + x + ") in GPIndividual.");
            return;
        }
        for (x = 0; x < this.trees.length; ++x) {
            this.trees[x].verify(state);
        }
        state.output.exitIfErrors();
    }

    public void printTrees(EvolutionState state, int log) {
        for (int x = 0; x < this.trees.length; ++x) {
            state.output.println("Tree " + x + ":", log);
            this.trees[x].printTreeForHumans(state, log);
        }
    }

    public void printIndividualForHumans(EvolutionState state, int log) {
        state.output.println("Evaluated: " + (this.evaluated ? "true" : "false"), log);
        this.fitness.printFitnessForHumans(state, log);
        this.printTrees(state, log);
    }

    public void printIndividual(EvolutionState state, int log) {
        state.output.println("Evaluated: " + Code.encode(this.evaluated), log);
        this.fitness.printFitness(state, log);
        for (int x = 0; x < this.trees.length; ++x) {
            state.output.println("Tree " + x + ":", log);
            this.trees[x].printTree(state, log);
        }
    }

    public void printIndividual(EvolutionState state, PrintWriter writer) {
        writer.println("Evaluated: " + Code.encode(this.evaluated));
        this.fitness.printFitness(state, writer);
        for (int x = 0; x < this.trees.length; ++x) {
            writer.println("Tree " + x + ":");
            this.trees[x].printTree(state, writer);
        }
    }

    public void writeGenotype(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.trees.length);
        for (int x = 0; x < this.trees.length; ++x) {
            this.trees[x].writeTree(state, dataOutput);
        }
    }

    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        int treelength = dataInput.readInt();
        if (this.trees == null || treelength != this.trees.length) {
            state.output.fatal("Number of trees differ in GPIndividual when reading from readGenotype(EvolutionState, DataInput).");
        }
        for (int x = 0; x < this.trees.length; ++x) {
            this.trees[x].readTree(state, dataInput);
        }
    }

    public void parseGenotype(EvolutionState state, LineNumberReader reader) throws IOException {
        for (int x = 0; x < this.trees.length; ++x) {
            reader.readLine();
            this.trees[x].readTree(state, reader);
        }
    }

    public Object clone() {
        GPIndividual myobj = (GPIndividual)super.clone();
        myobj.trees = new GPTree[this.trees.length];
        for (int x = 0; x < this.trees.length; ++x) {
            myobj.trees[x] = (GPTree)this.trees[x].clone();
            myobj.trees[x].owner = myobj;
        }
        return myobj;
    }

    public GPIndividual lightClone() {
        GPIndividual myobj = (GPIndividual)super.clone();
        myobj.trees = new GPTree[this.trees.length];
        for (int x = 0; x < this.trees.length; ++x) {
            myobj.trees[x] = this.trees[x].lightClone();
            myobj.trees[x].owner = myobj;
        }
        return myobj;
    }

    public long size() {
        long size = 0L;
        for (int x = 0; x < this.trees.length; ++x) {
            size += (long)this.trees[x].child.numNodes(0);
        }
        return size;
    }
}

