/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective;

import ec.EvolutionState;
import ec.Individual;
import ec.multiobjective.MultiObjectiveFitness;
import ec.simple.SimpleStatistics;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.SortComparator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class MultiObjectiveStatistics
extends SimpleStatistics {
    public static final String P_PARETO_FRONT_FILE = "front";
    public static final String P_SILENT_FRONT_FILE = "silent.front";
    public boolean silentFront;
    public int frontLog = 0;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.silentFront = state.parameters.getBoolean(base.push("silent"), null, false);
        this.silentFront = state.parameters.getBoolean(base.push(P_SILENT_FRONT_FILE), null, this.silentFront);
        File frontFile = state.parameters.getFile(base.push(P_PARETO_FRONT_FILE), null);
        if (this.silentFront) {
            this.frontLog = -2;
        } else if (frontFile != null) {
            try {
                this.frontLog = state.output.addLog(frontFile, !this.compress, this.compress);
            }
            catch (IOException i) {
                state.output.fatal("An IOException occurred while trying to create the log " + frontFile + ":\n" + i);
            }
        } else {
            state.output.warning("No Pareto Front statistics file specified, printing to stdout at end.", base.push(P_PARETO_FRONT_FILE));
        }
    }

    public void finalStatistics(EvolutionState state, int result) {
        this.bypassFinalStatistics(state, result);
        if (this.doFinal) {
            state.output.println("\n\n\n PARETO FRONTS", this.statisticslog);
        }
        for (int s = 0; s < state.population.subpops.length; ++s) {
            int i;
            MultiObjectiveFitness typicalFitness = (MultiObjectiveFitness)state.population.subpops[s].individuals[0].fitness;
            if (this.doFinal) {
                state.output.println("\n\nPareto Front of Subpopulation " + s, this.statisticslog);
            }
            ArrayList front = MultiObjectiveFitness.partitionIntoParetoFront(state.population.subpops[s].individuals, null, null);
            Object[] sortedFront = front.toArray();
            QuickSort.qsort(sortedFront, new SortComparator(){

                public boolean lt(Object a, Object b) {
                    return ((MultiObjectiveFitness)((Individual)a).fitness).getObjective(0) < ((MultiObjectiveFitness)((Individual)b).fitness).getObjective(0);
                }

                public boolean gt(Object a, Object b) {
                    return ((MultiObjectiveFitness)((Individual)a).fitness).getObjective(0) > ((MultiObjectiveFitness)((Individual)b).fitness).getObjective(0);
                }
            });
            if (this.doFinal) {
                for (i = 0; i < sortedFront.length; ++i) {
                    ((Individual)sortedFront[i]).printIndividualForHumans(state, this.statisticslog);
                }
            }
            if (this.silentFront) continue;
            if (state.population.subpops.length > 1) {
                state.output.println("Subpopulation " + s, this.frontLog);
            }
            for (i = 0; i < sortedFront.length; ++i) {
                Individual ind = (Individual)sortedFront[i];
                MultiObjectiveFitness mof = (MultiObjectiveFitness)ind.fitness;
                double[] objectives = mof.getObjectives();
                String line = "";
                for (int f = 0; f < objectives.length; ++f) {
                    line = line + objectives[f] + " ";
                }
                state.output.println(line, this.frontLog);
            }
        }
    }
}

