/*
 * Decompiled with CFR 0.152.
 */
package ec.parsimony;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.steadystate.SteadyStateBSourceForm;
import ec.steadystate.SteadyStateEvolutionState;
import ec.util.Parameter;

public class DoubleTournamentSelection
extends SelectionMethod
implements SteadyStateBSourceForm {
    public static final String P_TOURNAMENT = "double-tournament";
    public static final String P_PICKWORST = "pick-worst";
    public static final String P_PICKWORST2 = "pick-worst2";
    public static final String P_DOLENGTHFIRST = "do-length-first";
    public static final String P_SIZE = "size";
    public static final String P_SIZE2 = "size2";
    public int size;
    public int size2;
    public double probabilityOfSelection;
    public double probabilityOfSelection2;
    public boolean pickWorst;
    public boolean pickWorst2;
    public boolean doLengthFirst;

    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_TOURNAMENT);
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        double val = state.parameters.getDouble(base.push(P_SIZE), def.push(P_SIZE), 1.0);
        if (val < 1.0) {
            state.output.fatal("Tournament size must be >= 1.", base.push(P_SIZE), def.push(P_SIZE));
        } else if (val > 1.0 && val < 2.0) {
            this.size = 2;
            this.probabilityOfSelection = val / 2.0;
        } else if (val != (double)((int)val)) {
            state.output.fatal("If >= 2, Tournament size must be an integer.", base.push(P_SIZE), def.push(P_SIZE));
        } else {
            this.size = (int)val;
            this.probabilityOfSelection = 1.0;
        }
        val = state.parameters.getDouble(base.push(P_SIZE2), def.push(P_SIZE2), 1.0);
        if (val < 1.0) {
            state.output.fatal("Tournament size2 must be >= 1.", base.push(P_SIZE2), def.push(P_SIZE2));
        } else if (val > 1.0 && val < 2.0) {
            this.size2 = 2;
            this.probabilityOfSelection2 = val / 2.0;
        } else if (val != (double)((int)val)) {
            state.output.fatal("If >= 2, Tournament size2 must be an integer.", base.push(P_SIZE2), def.push(P_SIZE2));
        } else {
            this.size2 = (int)val;
            this.probabilityOfSelection2 = 1.0;
        }
        this.doLengthFirst = state.parameters.getBoolean(base.push(P_DOLENGTHFIRST), def.push(P_DOLENGTHFIRST), true);
        this.pickWorst = state.parameters.getBoolean(base.push(P_PICKWORST), def.push(P_PICKWORST), false);
        this.pickWorst2 = state.parameters.getBoolean(base.push(P_PICKWORST2), def.push(P_PICKWORST2), false);
    }

    public int produce(int subpopulation, EvolutionState state, int thread) {
        int i;
        int[] inds = new int[this.size2];
        for (int x = 0; x < this.size2; ++x) {
            inds[x] = this.make(subpopulation, state, thread);
        }
        if (!this.doLengthFirst) {
            int i2;
            Individual[] oldinds = state.population.subpops[subpopulation].individuals;
            int bad = i2 = inds[0];
            for (int x = 1; x < this.size2; ++x) {
                int j = inds[x];
                if (this.pickWorst2) {
                    if (oldinds[j].size() > oldinds[i2].size()) {
                        bad = i2;
                        i2 = j;
                        continue;
                    }
                    bad = j;
                    continue;
                }
                if (oldinds[j].size() < oldinds[i2].size()) {
                    bad = i2;
                    i2 = j;
                    continue;
                }
                bad = j;
            }
            if (this.probabilityOfSelection2 != 1.0 && !state.random[thread].nextBoolean(this.probabilityOfSelection2)) {
                i2 = bad;
            }
            return i2;
        }
        Individual[] oldinds = state.population.subpops[subpopulation].individuals;
        int bad = i = inds[0];
        for (int x = 1; x < this.size2; ++x) {
            int j = inds[x];
            if (this.pickWorst2) {
                if (!oldinds[j].fitness.betterThan(oldinds[i].fitness)) {
                    bad = i;
                    i = j;
                    continue;
                }
                bad = j;
                continue;
            }
            if (oldinds[j].fitness.betterThan(oldinds[i].fitness)) {
                bad = i;
                i = j;
                continue;
            }
            bad = j;
        }
        if (this.probabilityOfSelection2 != 1.0 && !state.random[thread].nextBoolean(this.probabilityOfSelection2)) {
            i = bad;
        }
        return i;
    }

    public int make(int subpopulation, EvolutionState state, int thread) {
        int i;
        if (this.doLengthFirst) {
            int i2;
            Individual[] oldinds = state.population.subpops[subpopulation].individuals;
            int bad = i2 = state.random[thread].nextInt(oldinds.length);
            for (int x = 1; x < this.size; ++x) {
                int j = state.random[thread].nextInt(oldinds.length);
                if (this.pickWorst) {
                    if (oldinds[j].size() > oldinds[i2].size()) {
                        bad = i2;
                        i2 = j;
                        continue;
                    }
                    bad = j;
                    continue;
                }
                if (oldinds[j].size() < oldinds[i2].size()) {
                    bad = i2;
                    i2 = j;
                    continue;
                }
                bad = j;
            }
            if (this.probabilityOfSelection != 1.0 && !state.random[thread].nextBoolean(this.probabilityOfSelection)) {
                i2 = bad;
            }
            return i2;
        }
        Individual[] oldinds = state.population.subpops[subpopulation].individuals;
        int bad = i = state.random[thread].nextInt(oldinds.length);
        for (int x = 1; x < this.size; ++x) {
            int j = state.random[thread].nextInt(oldinds.length);
            if (this.pickWorst) {
                if (!oldinds[j].fitness.betterThan(oldinds[i].fitness)) {
                    bad = i;
                    i = j;
                    continue;
                }
                bad = j;
                continue;
            }
            if (oldinds[j].fitness.betterThan(oldinds[i].fitness)) {
                bad = i;
                i = j;
                continue;
            }
            bad = j;
        }
        if (this.probabilityOfSelection != 1.0 && !state.random[thread].nextBoolean(this.probabilityOfSelection)) {
            i = bad;
        }
        return i;
    }

    public void individualReplaced(SteadyStateEvolutionState state, int subpopulation, int thread, int individual) {
    }

    public void sourcesAreProperForm(SteadyStateEvolutionState state) {
    }
}

