/*
 * Decompiled with CFR 0.152.
 */
package ec.steadystate;

import ec.EvolutionState;
import ec.Individual;
import ec.eval.MasterProblem;
import ec.simple.SimpleEvaluator;
import ec.simple.SimpleProblemForm;
import ec.steadystate.QueueIndividual;
import ec.util.Parameter;
import java.util.LinkedList;

public class SteadyStateEvaluator
extends SimpleEvaluator {
    LinkedList queue = new LinkedList();
    int subpopulationBeingEvaluated = -1;
    SimpleProblemForm problem;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (!this.cloneProblem) {
            state.output.fatal("cloneProblem must be true for SteadyStateEvaluator -- we'll use only one Problem anyway.");
        }
    }

    public void prepareToEvaluate(EvolutionState state, int thread) {
        this.problem = (SimpleProblemForm)this.p_problem.clone();
        if (this.problem instanceof MasterProblem) {
            ((MasterProblem)this.problem).prepareToEvaluate(state, thread);
        }
    }

    public void evaluateIndividual(EvolutionState state, Individual ind, int subpop) {
        this.problem.evaluate(state, ind, subpop, 0);
        this.queue.addLast(new QueueIndividual(ind, subpop));
    }

    public boolean canEvaluate() {
        if (this.problem instanceof MasterProblem) {
            return ((MasterProblem)this.problem).canEvaluate();
        }
        return true;
    }

    public Individual getNextEvaluatedIndividual() {
        QueueIndividual qind = null;
        if (this.problem instanceof MasterProblem) {
            if (((MasterProblem)this.problem).evaluatedIndividualAvailable()) {
                qind = ((MasterProblem)this.problem).getNextEvaluatedIndividual();
            }
        } else {
            qind = (QueueIndividual)this.queue.removeFirst();
        }
        if (qind == null) {
            return null;
        }
        this.subpopulationBeingEvaluated = qind.subpop;
        return qind.ind;
    }

    public int getSubpopulationOfEvaluatedIndividual() {
        return this.subpopulationBeingEvaluated;
    }

    public boolean runComplete(EvolutionState state, Individual ind) {
        return ind.fitness.isIdealFitness();
    }
}

