/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.breed.BreedDefaults;
import ec.util.Parameter;

public class ForceBreedingPipeline
extends BreedingPipeline {
    public static final String P_NUMINDS = "num-inds";
    public static final String P_FORCE = "force";
    public int numInds;

    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_FORCE);
    }

    public int numSources() {
        return 1;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.numInds = state.parameters.getInt(base.push(P_NUMINDS), def.push(P_NUMINDS), 1);
        if (this.numInds == 0) {
            state.output.fatal("ForceBreedingPipeline must produce at least 1 child at a time", base.push(P_NUMINDS), def.push(P_NUMINDS));
        }
        if (this.likelihood < 1.0) {
            state.output.warning("ForceBreedingPipeline does not respond to the 'likelihood' parameter.", base.push("likelihood"), def.push("likelihood"));
        }
    }

    public int typicalIndsProduced() {
        return this.numInds;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int total;
        int numToProduce;
        int n = this.numInds;
        if (n < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        for (total = 0; total < n; total += this.sources[0].produce(numToProduce, numToProduce, start + total, subpopulation, inds, state, thread)) {
            numToProduce = n - total;
            if (numToProduce <= this.numInds) continue;
            numToProduce = this.numInds;
        }
        if (this.sources[0] instanceof SelectionMethod) {
            for (int q = start; q < total + start; ++q) {
                inds[q] = (Individual)inds[q].clone();
            }
        }
        return total;
    }
}

