/*
 * Decompiled with CFR 0.152.
 */
package ec.display;

import ec.EvolutionState;
import ec.Setup;
import ec.display.Console;
import ec.display.EvolutionStateEvent;
import ec.display.EvolutionStateListener;
import ec.display.portrayal.IndividualPortrayal;
import ec.display.portrayal.SimpleIndividualPortrayal;
import ec.util.ParamClassLoadException;
import ec.util.Parameter;
import ec.util.ReflectedObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SubpopulationPanel
extends JPanel
implements EvolutionStateListener,
Setup {
    private final Console console;
    private final int subPopNum;
    private JList individualsList = null;
    private JScrollPane individualListPane = null;
    private JSplitPane subpopPane = null;
    private JSplitPane individualDisplayPane = null;
    private IndividualPortrayal portrayal = null;
    private JScrollPane inspectionPane = null;
    private JTree inspectionTree = null;

    public SubpopulationPanel(Console console, int subPopNum) {
        this.console = console;
        this.subPopNum = subPopNum;
        this.initialize();
    }

    public SubpopulationPanel(Console console, int subPopNum, boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.console = console;
        this.subPopNum = subPopNum;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(300, 200);
        this.add((Component)this.getSubpopPane(), "Center");
    }

    private JList getIndividualsList() {
        if (this.individualsList == null) {
            int defaultsub;
            this.individualsList = new JList();
            this.individualsList.setSelectionMode(0);
            int size = -1;
            if (this.console.parameters.exists(new Parameter("pop.subpop." + this.subPopNum + ".size"), null)) {
                size = this.console.parameters.getInt(new Parameter("pop.subpop." + this.subPopNum + ".size"), null);
            } else if (this.console.parameters.exists(new Parameter("pop.default-subpop"), null) && (defaultsub = this.console.parameters.getInt(new Parameter("pop.default-subpop"), null)) >= 0) {
                size = this.console.parameters.getInt(new Parameter("pop.subpop." + defaultsub + ".size"), null);
            }
            DefaultListModel<Integer> model = new DefaultListModel<Integer>();
            for (int i = 0; i < size; ++i) {
                model.add(i, i);
            }
            this.individualsList.setModel(model);
            this.individualsList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent evt) {
                    if (!evt.getValueIsAdjusting()) {
                        JList source = (JList)evt.getSource();
                        int idx = source.getSelectedIndex();
                        SubpopulationPanel.this.inspectionTree.setModel(new ReflectedObject(((SubpopulationPanel)SubpopulationPanel.this).console.state.population.subpops[((SubpopulationPanel)SubpopulationPanel.this).subPopNum].individuals[idx]));
                        SubpopulationPanel.this.portrayal.portrayIndividual(((SubpopulationPanel)SubpopulationPanel.this).console.state, ((SubpopulationPanel)SubpopulationPanel.this).console.state.population.subpops[((SubpopulationPanel)SubpopulationPanel.this).subPopNum].individuals[idx]);
                    }
                }
            });
        }
        return this.individualsList;
    }

    public void postEvolution(EvolutionStateEvent evt) {
        int idx = this.individualsList.getSelectedIndex();
        if (idx >= 0) {
            this.inspectionTree.setModel(new ReflectedObject(this.console.state.population.subpops[this.subPopNum].individuals[idx]));
            this.portrayal.portrayIndividual(this.console.state, this.console.state.population.subpops[this.subPopNum].individuals[idx]);
        }
    }

    private JScrollPane getIndividualListPane() {
        if (this.individualListPane == null) {
            this.individualListPane = new JScrollPane();
            this.individualListPane.setViewportView(this.getIndividualsList());
            this.individualListPane.setPreferredSize(new Dimension(75, 131));
        }
        return this.individualListPane;
    }

    private JSplitPane getSubpopPane() {
        if (this.subpopPane == null) {
            this.subpopPane = new JSplitPane();
            this.subpopPane.setLeftComponent(this.getIndividualListPane());
            this.subpopPane.setRightComponent(this.getIndividualDisplayPane());
            this.subpopPane.setResizeWeight(0.0);
            this.subpopPane.setDividerLocation(100);
        }
        return this.subpopPane;
    }

    private JSplitPane getIndividualDisplayPane() {
        if (this.individualDisplayPane == null) {
            this.individualDisplayPane = new JSplitPane();
            this.individualDisplayPane.setOrientation(0);
            this.individualDisplayPane.setTopComponent(this.getInspectionPane());
            this.individualDisplayPane.setResizeWeight(0.5);
        }
        return this.individualDisplayPane;
    }

    public void setup(EvolutionState state, Parameter base) {
        try {
            this.portrayal = (IndividualPortrayal)state.parameters.getInstanceForParameter(base.push("portrayal"), null, IndividualPortrayal.class);
        }
        catch (ParamClassLoadException ex) {
            this.portrayal = new SimpleIndividualPortrayal();
        }
        this.portrayal.setup(state, base);
        this.individualDisplayPane.setBottomComponent(new JScrollPane(this.portrayal));
    }

    private JScrollPane getInspectionPane() {
        if (this.inspectionPane == null) {
            this.inspectionPane = new JScrollPane();
            this.inspectionPane.setViewportView(this.getInspectionTree());
        }
        return this.inspectionPane;
    }

    private JTree getInspectionTree() {
        if (this.inspectionTree == null) {
            Object[] emptyTreeModel = new Object[]{};
            this.inspectionTree = new JTree(emptyTreeModel);
        }
        return this.inspectionTree;
    }
}

