/*
 * Decompiled with CFR 0.152.
 */
package ec.eda;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.eda.CMAESSpecies;
import ec.simple.SimpleInitializer;

public class CMAESInitializer
extends SimpleInitializer {
    private static final long serialVersionUID = 1L;

    public Population setupPopulation(EvolutionState state, int thread) {
        Population p = super.setupPopulation(state, thread);
        for (int i = 0; i < p.subpops.length; ++i) {
            if (p.subpops[i].species instanceof CMAESSpecies) {
                Individual[] newInds;
                int lambda = ((CMAESSpecies)p.subpops[i].species).lambda;
                if (lambda < p.subpops[i].individuals.length) {
                    newInds = new Individual[((CMAESSpecies)p.subpops[i].species).lambda];
                    System.arraycopy(p.subpops[i].individuals, 0, newInds, 0, lambda);
                    p.subpops[i].individuals = newInds;
                } else if (lambda > p.subpops[i].individuals.length) {
                    newInds = new Individual[((CMAESSpecies)p.subpops[i].species).lambda];
                    System.arraycopy(p.subpops[i].individuals, 0, newInds, 0, p.subpops[i].individuals.length);
                    for (int j = p.subpops[i].individuals.length; j < lambda; ++j) {
                        newInds[j] = p.subpops[i].species.newIndividual(state, thread);
                    }
                    p.subpops[i].individuals = newInds;
                }
            } else {
                state.output.fatal("Species of subpopulation " + i + " is not a CMAESSpecies.  It's a " + p.subpops[i].species);
            }
            state.output.message("Size of Subpopulation " + i + " changed to " + p.subpops[i].individuals.length);
        }
        return p;
    }
}

