/*
 * Decompiled with CFR 0.152.
 */
package ec.eval;

import ec.EvolutionState;
import ec.Evolve;
import ec.Individual;
import ec.coevolve.GroupedProblemForm;
import ec.eval.MasterProblem;
import ec.simple.SimpleProblemForm;
import ec.util.MersenneTwisterFast;
import ec.util.Output;
import ec.util.Parameter;
import ec.util.ParameterDatabase;
import ec.util.ThreadPool;
import ec.util.Version;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;

public class Slave {
    public static final String P_EVALSLAVENAME = "eval.slave.name";
    public static final String P_EVALMASTERHOST = "eval.master.host";
    public static final String P_EVALMASTERPORT = "eval.master.port";
    public static final String P_EVALCOMPRESSION = "eval.compression";
    public static final String P_RETURNINDIVIDUALS = "eval.return-inds";
    public static final String P_SILENT = "eval.slave.silent";
    public static final String P_MUZZLE = "eval.slave.muzzle";
    public static final byte V_NOTHING = 0;
    public static final byte V_INDIVIDUAL = 1;
    public static final byte V_FITNESS = 2;
    public static final byte V_SHUTDOWN = 0;
    public static final byte V_EVALUATESIMPLE = 1;
    public static final byte V_EVALUATEGROUPED = 2;
    public static final String A_FILE = "-file";
    public static final String P_RUNTIME = "eval.slave.runtime";
    public static int runTime = 0;
    public static final String P_RUNEVOLVE = "eval.slave.run-evolve";
    public static boolean runEvolve = false;
    public static final String P_ONESHOT = "eval.slave.one-shot";
    public static boolean oneShot = false;
    public static final int SLEEP_TIME = 100;
    public static final ThreadPool pool = new ThreadPool();
    public static int slaveNum = -1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int masterPort;
        EvolutionState state = null;
        ParameterDatabase parameters = null;
        Output output = null;
        for (int x = 0; x < args.length - 1; ++x) {
            if (!args[x].equals(A_FILE)) continue;
            try {
                parameters = new ParameterDatabase(new File(new File(args[x + 1]).getAbsolutePath()), args);
                parameters.set(new Parameter("eval").push("i-am-slave"), "true");
                break;
            }
            catch (FileNotFoundException e) {
                Output.initialError("A File Not Found Exception was generated uponreading the parameter file \"" + args[x + 1] + "\".\nHere it is:\n" + e);
                continue;
            }
            catch (IOException e) {
                Output.initialError("An IO Exception was generated upon reading theparameter file \"" + args[x + 1] + "\".\nHere it is:\n" + e);
            }
        }
        if (parameters == null) {
            Output.initialError("No parameter file was specified.");
        }
        boolean returnIndividuals = parameters.getBoolean(new Parameter(P_RETURNINDIVIDUALS), null, false);
        boolean silent = parameters.getBoolean(new Parameter(P_SILENT), null, false);
        if (parameters.exists(new Parameter(P_MUZZLE), null)) {
            Output.initialWarning("" + new Parameter(P_MUZZLE) + " has been deprecated.  We suggest you use " + new Parameter(P_SILENT) + " or similar newer options.");
        }
        silent = silent || parameters.getBoolean(new Parameter(P_MUZZLE), null, false);
        String slaveName = parameters.getString(new Parameter(P_EVALSLAVENAME), null);
        String masterHost = parameters.getString(new Parameter(P_EVALMASTERHOST), null);
        if (masterHost == null) {
            Output.initialError("Master Host missing", new Parameter(P_EVALMASTERHOST));
        }
        if ((masterPort = parameters.getInt(new Parameter(P_EVALMASTERPORT), null, 0)) == -1) {
            Output.initialError("Master Port missing", new Parameter(P_EVALMASTERPORT));
        }
        boolean useCompression = parameters.getBoolean(new Parameter(P_EVALCOMPRESSION), null, false);
        runTime = parameters.getInt(new Parameter(P_RUNTIME), null, 0);
        runEvolve = parameters.getBoolean(new Parameter(P_RUNEVOLVE), null, false);
        oneShot = parameters.getBoolean(new Parameter(P_ONESHOT), null, true);
        if (runEvolve && !returnIndividuals) {
            Output.initialError("You have the slave running in 'evolve' mode, but it's only returning fitnesses to the master, not whole individuals.  This is almost certainly wrong.", new Parameter(P_RUNEVOLVE), new Parameter(P_RETURNINDIVIDUALS));
        }
        if (!silent) {
            Output.initialMessage("ECJ Slave");
            if (runEvolve) {
                Output.initialMessage("Running in Evolve mode, evolve time is " + runTime + " milliseconds");
            }
            if (returnIndividuals) {
                Output.initialMessage("Whole individuals will be returned");
            } else {
                Output.initialMessage("Only fitnesses will be returned");
            }
        }
        Socket socket = null;
        while (true) {
            block59: {
                try {
                    try {
                        int evalthreads;
                        int breedthreads;
                        long connectAttemptCount = 0L;
                        if (!silent) {
                            Output.initialMessage("Connecting to master at " + masterHost + ":" + masterPort);
                        }
                        while (true) {
                            try {
                                socket = new Socket(masterHost, masterPort);
                            }
                            catch (ConnectException e) {
                                ++connectAttemptCount;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {}
                                continue;
                            }
                            break;
                        }
                        if (!silent) {
                            Output.initialMessage("Connected to master after " + connectAttemptCount * 100L + " ms");
                        }
                        DataInputStream dataIn = null;
                        DataOutputStream dataOut = null;
                        try {
                            InputStream tmpIn = socket.getInputStream();
                            OutputStream tmpOut = socket.getOutputStream();
                            if (useCompression) {
                                tmpIn = Output.makeCompressingInputStream(tmpIn);
                                tmpOut = Output.makeCompressingOutputStream(tmpOut);
                                if (tmpIn == null || tmpOut == null) {
                                    String err = "You do not appear to have JZLib installed on your system, and so must set eval.compression=false.  To get JZLib, download from the ECJ website or from http://www.jcraft.com/jzlib/";
                                    if (!silent) {
                                        Output.initialMessage(err);
                                    }
                                    throw new Output.OutputExitException(err);
                                }
                            }
                            dataIn = new DataInputStream(tmpIn);
                            dataOut = new DataOutputStream(tmpOut);
                        }
                        catch (IOException e) {
                            String err = "Unable to open input stream from socket:\n" + e;
                            if (!silent) {
                                Output.initialMessage(err);
                            }
                            throw new Output.OutputExitException(err);
                        }
                        slaveNum = dataIn.readInt();
                        if (slaveName == null) {
                            slaveName = socket.getLocalAddress().toString() + "/" + slaveNum;
                            if (!silent) {
                                Output.initialMessage("No slave name specified.  Using: " + slaveName);
                            }
                        }
                        dataOut.writeUTF(slaveName);
                        dataOut.flush();
                        if (output != null) {
                            output.close();
                        }
                        output = new Output(false);
                        output.setThrowsErrors(true);
                        output.addLog(0, false);
                        output.addLog(1, true);
                        if (silent) {
                            output.getLog((int)0).silent = true;
                            output.getLog((int)1).silent = true;
                        }
                        if (!silent) {
                            output.systemMessage(Version.message());
                        }
                        MersenneTwisterFast[] random = new MersenneTwisterFast[(breedthreads = Evolve.determineThreads(output, parameters, new Parameter("breedthreads"))) > (evalthreads = Evolve.determineThreads(output, parameters, new Parameter("evalthreads"))) ? breedthreads : evalthreads];
                        int seed = dataIn.readInt();
                        for (int i = 0; i < random.length; ++i) {
                            random[i] = Evolve.primeGenerator(new MersenneTwisterFast(seed++));
                        }
                        state = (EvolutionState)parameters.getInstanceForParameter(new Parameter("state"), null, EvolutionState.class);
                        state.parameters = new ParameterDatabase();
                        state.parameters.addParent(parameters);
                        state.random = random;
                        state.output = output;
                        state.evalthreads = evalthreads;
                        state.breedthreads = breedthreads;
                        state.setup(state, null);
                        state.population = state.initializer.setupPopulation(state, 0);
                        MasterProblem storage = state.evaluator.masterproblem;
                        storage.receiveAdditionalData(state, dataIn);
                        storage.transferAdditionalData(state);
                        try {
                            block30: while (true) {
                                EvolutionState newState = state;
                                if (runEvolve) {
                                    ParameterDatabase coverDatabase = new ParameterDatabase();
                                    coverDatabase.addParent(state.parameters);
                                    newState = Evolve.initialize(coverDatabase, 0);
                                    newState.startFresh();
                                    newState.output.message("Replacing random number generators, ignore above seed message");
                                    newState.random = state.random;
                                    storage.transferAdditionalData(newState);
                                }
                                byte problemType = dataIn.readByte();
                                switch (problemType) {
                                    case 0: {
                                        socket.close();
                                        if (oneShot) {
                                            return;
                                        }
                                        throw new Output.OutputExitException("SHUTDOWN");
                                    }
                                    case 1: {
                                        Slave.evaluateSimpleProblemForm(newState, returnIndividuals, dataIn, dataOut, args);
                                        continue block30;
                                    }
                                    case 2: {
                                        Slave.evaluateGroupedProblemForm(newState, returnIndividuals, dataIn, dataOut);
                                        continue block30;
                                    }
                                }
                                state.output.fatal("Unknown problem form specified: " + problemType);
                            }
                        }
                        catch (Exception e) {
                            state.output.fatal("Unable to read type of evaluation from master.  Maybe the master closed its socket and exited?:\n" + e);
                        }
                    }
                    catch (UnknownHostException e) {
                        if (state != null) {
                            state.output.fatal(e.getMessage());
                        } else if (!silent) {
                            System.err.println("FATAL ERROR (EvolutionState not created yet): " + e.getMessage());
                        }
                    }
                    catch (IOException e) {
                        if (state != null) {
                            state.output.fatal("Unable to connect to master:\n" + e);
                            break block59;
                        }
                        if (!silent) {
                            System.err.println("FATAL ERROR (EvolutionState not created yet): " + e);
                        }
                    }
                }
                catch (Output.OutputExitException e) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (oneShot) {
                        System.exit(0);
                    }
                }
                catch (OutOfMemoryError e) {
                    state = null;
                    System.gc();
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    socket = null;
                    System.gc();
                    System.err.println(e);
                    if (!oneShot) break block59;
                    System.exit(0);
                }
            }
            if (silent) continue;
            Output.initialMessage("\n\nResetting Slave");
        }
    }

    public static void evaluateSimpleProblemForm(final EvolutionState state, boolean returnIndividuals, DataInputStream dataIn, DataOutputStream dataOut, String[] args) {
        Object params = null;
        int numInds = 1;
        try {
            numInds = dataIn.readInt();
        }
        catch (Exception e) {
            state.output.fatal("Unable to read the number of individuals from the master:\n" + e);
        }
        final int[] subpops = new int[numInds];
        int[] indsPerSubpop = new int[state.population.subpops.length];
        for (int i = 0; i < numInds; ++i) {
            try {
                subpops[i] = dataIn.readInt();
                if (subpops[i] < 0 || subpops[i] >= state.population.subpops.length) {
                    state.output.fatal("Bad subpop number for individual #" + i + ": " + subpops[i]);
                }
                int n = subpops[i];
                indsPerSubpop[n] = indsPerSubpop[n] + 1;
                continue;
            }
            catch (Exception e) {
                state.output.fatal("Unable to read the subpop number from the master:\n" + e);
            }
        }
        boolean[] updateFitness = new boolean[numInds];
        final Individual[] inds = new Individual[numInds];
        if (!runEvolve) {
            ThreadPool.Worker[] threads = new ThreadPool.Worker[state.evalthreads];
            final SimpleProblemForm[] problems = new SimpleProblemForm[state.evalthreads];
            int[] indForThread = new int[state.evalthreads];
            try {
                int t = 0;
                for (int i = 0; i < numInds; ++i) {
                    inds[i] = state.population.subpops[subpops[i]].species.newIndividual(state, dataIn);
                    updateFitness[i] = dataIn.readBoolean();
                    if (t >= state.evalthreads) {
                        t = 0;
                    }
                    if (threads[t] != null) {
                        pool.join(threads[t]);
                        Slave.returnIndividualsToMaster(state, inds, updateFitness, dataOut, returnIndividuals, indForThread[t]);
                    }
                    if (problems[t] == null) {
                        problems[t] = (SimpleProblemForm)state.evaluator.p_problem.clone();
                    }
                    final int j = i;
                    final int s = t;
                    indForThread[t] = i;
                    threads[t] = pool.start(new Runnable(){

                        public void run() {
                            problems[s].evaluate(state, inds[j], subpops[j], 0);
                        }
                    }, "Evaluation of individual " + i);
                    ++t;
                }
                for (t = 0; t < state.evalthreads; ++t) {
                    if (threads[t] == null) continue;
                    pool.join(threads[t]);
                    Slave.returnIndividualsToMaster(state, inds, updateFitness, dataOut, returnIndividuals, indForThread[t]);
                }
            }
            catch (Exception e) {
                state.output.fatal("Unable to read individual from master:\n" + e);
            }
            try {
                dataOut.flush();
            }
            catch (IOException e) {
                state.output.fatal("Caught fatal IOException\n" + e);
            }
        } else {
            try {
                for (int i = 0; i < numInds; ++i) {
                    inds[i] = state.population.subpops[subpops[i]].species.newIndividual(state, dataIn);
                    updateFitness[i] = dataIn.readBoolean();
                }
            }
            catch (Exception e) {
                state.output.fatal("Unable to read individual from master:\n" + e);
            }
            long startTime = System.currentTimeMillis();
            long endTime = 0L;
            for (int subpop = 0; subpop < state.population.subpops.length; ++subpop) {
                if (state.population.subpops[subpop].individuals.length == indsPerSubpop[subpop]) continue;
                state.population.subpops[subpop].individuals = new Individual[indsPerSubpop[subpop]];
            }
            int[] counts = new int[state.population.subpops.length];
            for (int i = 0; i < numInds; ++i) {
                int n = subpops[i];
                int n2 = counts[n];
                counts[n] = n2 + 1;
                state.population.subpops[subpops[i]].individuals[n2] = inds[i];
            }
            int result = 2;
            do {
                if (result != 2) break;
                result = state.evolve();
            } while ((endTime = System.currentTimeMillis()) - startTime <= (long)runTime);
            counts = new int[state.population.subpops.length];
            for (int i = 0; i < numInds; ++i) {
                int n = subpops[i];
                int n3 = counts[n];
                counts[n] = n3 + 1;
                inds[i] = state.population.subpops[subpops[i]].individuals[n3];
            }
            state.finish(result);
            Evolve.cleanup(state);
            try {
                Slave.returnIndividualsToMaster(state, inds, updateFitness, dataOut, returnIndividuals, -1);
                dataOut.flush();
            }
            catch (IOException e) {
                state.output.fatal("Caught fatal IOException\n" + e);
            }
        }
    }

    public static void evaluateGroupedProblemForm(EvolutionState state, boolean returnIndividuals, DataInputStream dataIn, DataOutputStream dataOut) {
        boolean countVictoriesOnly = false;
        int numInds = 1;
        try {
            countVictoriesOnly = dataIn.readBoolean();
            numInds = dataIn.readInt();
        }
        catch (IOException e) {
            state.output.fatal("Unable to read the number of individuals from the master:\n" + e);
        }
        int[] subpops = new int[numInds];
        int[] indsPerSubpop = new int[state.population.subpops.length];
        for (int i = 0; i < numInds; ++i) {
            try {
                subpops[i] = dataIn.readInt();
                if (subpops[i] < 0 || subpops[i] >= state.population.subpops.length) {
                    state.output.fatal("Bad subpop number for individual #" + i + ": " + subpops[i]);
                }
                int n = subpops[i];
                indsPerSubpop[n] = indsPerSubpop[n] + 1;
                continue;
            }
            catch (Exception e) {
                state.output.fatal("Unable to read the subpop number from the master:\n" + e);
            }
        }
        Individual[] inds = new Individual[numInds];
        boolean[] updateFitness = new boolean[numInds];
        try {
            for (int i = 0; i < inds.length; ++i) {
                inds[i] = state.population.subpops[subpops[i]].species.newIndividual(state, dataIn);
                updateFitness[i] = dataIn.readBoolean();
            }
        }
        catch (Exception e) {
            state.output.fatal("Unable to read individual from master:\n" + e);
        }
        ((GroupedProblemForm)((Object)state.evaluator.p_problem)).evaluate(state, inds, updateFitness, countVictoriesOnly, subpops, 0);
        try {
            Slave.returnIndividualsToMaster(state, inds, updateFitness, dataOut, returnIndividuals, -1);
            dataOut.flush();
        }
        catch (IOException e) {
            state.output.fatal("Caught fatal IOException\n" + e);
        }
    }

    static void returnIndividualsToMaster(EvolutionState state, Individual[] inds, boolean[] updateFitness, DataOutputStream dataOut, boolean returnIndividuals, int individualInQuestion) throws IOException {
        int startInd = individualInQuestion == -1 ? 0 : individualInQuestion;
        int endInd = individualInQuestion == -1 ? inds.length : individualInQuestion + 1;
        for (int i = startInd; i < endInd; ++i) {
            dataOut.writeByte(returnIndividuals ? 1 : (updateFitness[i] ? 2 : 0));
            if (returnIndividuals) {
                inds[i].writeIndividual(state, dataOut);
                continue;
            }
            if (!updateFitness[i]) continue;
            dataOut.writeBoolean(inds[i].evaluated);
            inds[i].fitness.writeFitness(state, dataOut);
        }
    }
}

