/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.nsga2;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Subpopulation;
import ec.simple.SimpleBreeder;
import ec.util.Parameter;

public class NSGA2Breeder
extends SimpleBreeder {
    public void setup(EvolutionState state, Parameter base) {
        int i;
        super.setup(state, base);
        for (i = 0; i < this.elite.length; ++i) {
            if (!this.usingElitism(i)) continue;
            state.output.warning("You're using elitism with NSGA2Breeder, which is not permitted and will be ignored.  However the reevaluate-elites parameter *will* bre recognized by NSGAEvaluator.", base.push("elite").push("" + i));
        }
        for (i = 0; i < this.reduceBy.length; ++i) {
            if (this.reduceBy[i] == 0) continue;
            state.output.fatal("NSGA2Breeder does not support population reduction.", base.push("reduce-by").push("" + i), null);
        }
        if (this.sequentialBreeding) {
            state.output.fatal("NSGA2Breeder does not support sequential evaluation.", base.push("sequential"));
        }
        if (!this.clonePipelineAndPopulation) {
            state.output.fatal("clonePipelineAndPopulation must be true for NSGA2Breeder.");
        }
    }

    public Population breedPopulation(EvolutionState state) {
        Population oldPop = state.population;
        Population newPop = super.breedPopulation(state);
        Subpopulation[] subpops = oldPop.subpops;
        int subpopsLength = subpops.length;
        for (int i = 0; i < subpopsLength; ++i) {
            Subpopulation oldSubpop = oldPop.subpops[i];
            Subpopulation newSubpop = newPop.subpops[i];
            Individual[] combinedInds = new Individual[oldSubpop.individuals.length + newSubpop.individuals.length];
            System.arraycopy(newSubpop.individuals, 0, combinedInds, 0, newSubpop.individuals.length);
            System.arraycopy(oldSubpop.individuals, 0, combinedInds, newSubpop.individuals.length, oldSubpop.individuals.length);
            newSubpop.individuals = combinedInds;
        }
        return newPop;
    }
}

