/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.spea2;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.multiobjective.MultiObjectiveFitness;
import ec.multiobjective.spea2.SPEA2MultiObjectiveFitness;
import ec.simple.SimpleBreeder;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class SPEA2Breeder
extends SimpleBreeder {
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        for (int i = 0; i < state.population.subpops.length; ++i) {
            if (this.reduceBy[i] == 0) continue;
            state.output.fatal("SPEA2Breeder does not support population reduction.", base.push("reduce-by").push("" + i), null);
        }
        if (this.sequentialBreeding) {
            state.output.fatal("SPEA2Breeder does not support sequential evaluation.", base.push("sequential"));
        }
        if (!this.clonePipelineAndPopulation) {
            state.output.fatal("clonePipelineAndPopulation must be true for SPEA2Breeder.");
        }
    }

    protected void loadElites(EvolutionState state, Population newpop) {
        for (int x = 0; x < state.population.subpops.length; ++x) {
            if (this.numElites(state, x) <= state.population.subpops[x].individuals.length) continue;
            state.output.error("The number of elites for subpopulation " + x + " exceeds the actual size of the subpopulation");
        }
        state.output.exitIfErrors();
        for (int sub = 0; sub < state.population.subpops.length; ++sub) {
            Individual[] newInds = newpop.subpops[sub].individuals;
            Individual[] oldInds = state.population.subpops[sub].individuals;
            this.buildArchive(state, oldInds, newInds, this.numElites(state, sub));
        }
        this.unmarkElitesEvaluated(state, newpop);
    }

    public double[] calculateDistancesFromIndividual(Individual ind, Individual[] inds) {
        double[] d = new double[inds.length];
        for (int i = 0; i < inds.length; ++i) {
            d[i] = ((SPEA2MultiObjectiveFitness)ind.fitness).sumSquaredObjectiveDistance((SPEA2MultiObjectiveFitness)inds[i].fitness);
        }
        Arrays.sort(d);
        return d;
    }

    public void buildArchive(EvolutionState state, Individual[] oldInds, Individual[] newInds, int archiveSize) {
        int i;
        ArrayList archive = new ArrayList();
        ArrayList nonFront = new ArrayList();
        MultiObjectiveFitness.partitionIntoParetoFront(oldInds, archive, nonFront);
        int currentArchiveSize = archive.size();
        if (currentArchiveSize < archiveSize) {
            Collections.sort(nonFront);
            int len = archiveSize - currentArchiveSize;
            for (i = 0; i < len; ++i) {
                archive.add(nonFront.get(i));
                ++currentArchiveSize;
            }
        }
        while (currentArchiveSize > archiveSize) {
            Individual closest = (Individual)archive.get(0);
            int closestIndex = 0;
            double[] closestD = this.calculateDistancesFromIndividual(closest, oldInds);
            block2: for (int i2 = 1; i2 < currentArchiveSize; ++i2) {
                Individual competitor = (Individual)archive.get(i2);
                double[] competitorD = this.calculateDistancesFromIndividual(competitor, oldInds);
                for (int k = 0; k < oldInds.length; ++k) {
                    if (closestD[i2] > competitorD[i2]) {
                        closest = competitor;
                        closestD = competitorD;
                        closestIndex = k;
                        continue block2;
                    }
                    if (closestD[i2] < competitorD[i2]) continue block2;
                }
            }
            archive.set(closestIndex, archive.get(archive.size() - 1));
            archive.remove(archive.size() - 1);
            --currentArchiveSize;
        }
        Object[] obj = archive.toArray();
        for (i = 0; i < archiveSize; ++i) {
            newInds[newInds.length - archiveSize + i] = (Individual)((Individual)obj[i]).clone();
        }
    }
}

