/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.RandomChoice;
import ec.util.SortComparatorL;

public class GreedyOverselection
extends SelectionMethod {
    public double[] sortedFitOver;
    public double[] sortedFitUnder;
    public int[] sortedPop;
    public static final String P_GREEDY = "greedy";
    public static final String P_TOP = "top";
    public static final String P_GETS = "gets";
    public double top_n_percent;
    public double gets_n_percent;

    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_GREEDY);
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.top_n_percent = state.parameters.getDoubleWithMax(base.push(P_TOP), def.push(P_TOP), 0.0, 1.0);
        if (this.top_n_percent < 0.0) {
            state.output.fatal("Top-n-percent must be between 0.0 and 1.0", base.push(P_TOP), def.push(P_TOP));
        }
        this.gets_n_percent = state.parameters.getDoubleWithMax(base.push(P_GETS), def.push(P_GETS), 0.0, 1.0);
        if (this.gets_n_percent < 0.0) {
            state.output.fatal("Gets-n-percent must be between 0.0 and 1.0", base.push(P_GETS), def.push(P_GETS));
        }
    }

    public void prepareToProduce(EvolutionState s, int subpopulation, int thread) {
        int x;
        final Individual[] i = s.population.subpops[subpopulation].individuals;
        this.sortedPop = new int[i.length];
        for (int x2 = 0; x2 < this.sortedPop.length; ++x2) {
            this.sortedPop[x2] = x2;
        }
        QuickSort.qsort(this.sortedPop, new SortComparatorL(){

            public boolean lt(long a, long b) {
                return i[(int)b].fitness.betterThan(i[(int)a].fitness);
            }

            public boolean gt(long a, long b) {
                return i[(int)a].fitness.betterThan(i[(int)b].fitness);
            }
        });
        int boundary = (int)((double)this.sortedPop.length * this.top_n_percent);
        if (boundary == 0) {
            boundary = 1;
        }
        if (boundary == this.sortedPop.length) {
            boundary = this.sortedPop.length - 1;
        }
        if (boundary == 0) {
            s.output.fatal("Greedy Overselection can only be done with a population of size 2 or more (offending subpopulation #" + subpopulation + ")");
        }
        this.sortedFitOver = new double[boundary];
        int y = 0;
        for (x = this.sortedPop.length - boundary; x < this.sortedPop.length; ++x) {
            this.sortedFitOver[y] = i[this.sortedPop[x]].fitness.fitness();
            if (this.sortedFitOver[y] < 0.0) {
                s.output.fatal("Discovered a negative fitness value.  Greedy Overselection requires that all fitness values be non-negative (offending subpopulation #" + subpopulation + ")");
            }
            ++y;
        }
        this.sortedFitUnder = new double[this.sortedPop.length - boundary];
        y = 0;
        for (x = 0; x < this.sortedPop.length - boundary; ++x) {
            this.sortedFitUnder[y] = i[this.sortedPop[x]].fitness.fitness();
            if (this.sortedFitUnder[y] < 0.0) {
                s.output.fatal("Discovered a negative fitness value.  Greedy Overselection requires that all fitness values be non-negative (offending subpopulation #" + subpopulation + ")");
            }
            ++y;
        }
        RandomChoice.organizeDistribution(this.sortedFitUnder, true);
        RandomChoice.organizeDistribution(this.sortedFitOver, true);
    }

    public int produce(int subpopulation, EvolutionState state, int thread) {
        if (state.random[thread].nextBoolean(this.gets_n_percent)) {
            return this.sortedPop[this.sortedFitUnder.length + RandomChoice.pickFromDistribution(this.sortedFitOver, state.random[thread].nextDouble())];
        }
        return this.sortedPop[RandomChoice.pickFromDistribution(this.sortedFitUnder, state.random[thread].nextDouble())];
    }

    public void finishProducing(EvolutionState s, int subpopulation, int thread) {
        this.sortedFitUnder = null;
        this.sortedFitOver = null;
        this.sortedPop = null;
    }
}

