/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.Breeder;
import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.simple.SimpleBreederThread;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.SortComparatorL;
import ec.util.ThreadPool;

public class SimpleBreeder
extends Breeder {
    public static final String P_ELITE = "elite";
    public static final String P_ELITE_FRAC = "elite-fraction";
    public static final String P_REEVALUATE_ELITES = "reevaluate-elites";
    public static final String P_SEQUENTIAL_BREEDING = "sequential";
    public static final String P_CLONE_PIPELINE_AND_POPULATION = "clone-pipeline-and-population";
    public static final String P_REDUCE_BY = "reduce-by";
    public static final String P_MINIMUM_SIZE = "minimum-size";
    public int[] elite;
    public int[] reduceBy;
    public int[] minimumSize;
    public double[] eliteFrac;
    public boolean[] reevaluateElites;
    public boolean sequentialBreeding;
    public boolean clonePipelineAndPopulation;
    public Population backupPopulation = null;
    public static final int NOT_SET = -1;
    public ThreadPool pool = new ThreadPool();

    public boolean usingElitism(int subpopulation) {
        return this.elite[subpopulation] > 0 || this.eliteFrac[subpopulation] > 0.0;
    }

    public int numElites(EvolutionState state, int subpopulation) {
        if (this.elite[subpopulation] != -1) {
            return this.elite[subpopulation];
        }
        if (this.eliteFrac[subpopulation] == 0.0) {
            return 0;
        }
        if (this.eliteFrac[subpopulation] != -1.0) {
            return (int)Math.max(Math.floor((double)state.population.subpops[subpopulation].individuals.length * this.eliteFrac[subpopulation]), 1.0);
        }
        state.output.warnOnce("Elitism error (SimpleBreeder).  This shouldn't be able to happen.  Please report.");
        return 0;
    }

    public void setup(EvolutionState state, Parameter base) {
        int i;
        Parameter p = new Parameter("pop").push("subpops");
        int size = state.parameters.getInt(p, null, 1);
        this.eliteFrac = new double[size];
        this.elite = new int[size];
        for (i = 0; i < size; ++i) {
            this.elite[i] = -1;
            this.eliteFrac[i] = -1;
        }
        this.reevaluateElites = new boolean[size];
        this.reduceBy = new int[size];
        this.minimumSize = new int[size];
        for (i = 0; i < size; ++i) {
            this.minimumSize[i] = 2;
        }
        this.sequentialBreeding = state.parameters.getBoolean(base.push(P_SEQUENTIAL_BREEDING), null, false);
        if (this.sequentialBreeding && size == 1) {
            state.output.fatal("The Breeder is breeding sequentially, but you have only one population.", base.push(P_SEQUENTIAL_BREEDING));
        }
        this.clonePipelineAndPopulation = state.parameters.getBoolean(base.push(P_CLONE_PIPELINE_AND_POPULATION), null, true);
        if (!this.clonePipelineAndPopulation && state.breedthreads > 1) {
            state.output.fatal("The Breeder is not cloning its pipeline and population, but you have more than one thread.", base.push(P_CLONE_PIPELINE_AND_POPULATION));
        }
        int defaultSubpop = state.parameters.getInt(new Parameter("pop").push("default-subpop"), null, 0);
        for (int x = 0; x < size; ++x) {
            this.reduceBy[x] = state.parameters.getIntWithDefault(base.push(P_REDUCE_BY).push("" + x), null, 0);
            if (this.reduceBy[x] < 0) {
                state.output.fatal("reduce-by must be set to an integer >= 0.", base.push(P_REDUCE_BY).push("" + x));
            }
            this.minimumSize[x] = state.parameters.getIntWithDefault(base.push(P_MINIMUM_SIZE).push("" + x), null, 2);
            if (this.minimumSize[x] < 2) {
                state.output.fatal("minimum-size must be set to an integer >= 2.", base.push(P_MINIMUM_SIZE).push("" + x));
            }
            if (state.parameters.exists(base.push(P_ELITE).push("" + x), null)) {
                if (state.parameters.exists(base.push(P_ELITE_FRAC).push("" + x), null)) {
                    state.output.error("Both elite and elite-frac specified for subpouplation " + x + ".", base.push(P_ELITE_FRAC).push("" + x), base.push(P_ELITE_FRAC).push("" + x));
                } else {
                    this.elite[x] = state.parameters.getIntWithDefault(base.push(P_ELITE).push("" + x), null, 0);
                    if (this.elite[x] < 0) {
                        state.output.error("Elites for subpopulation " + x + " must be an integer >= 0", base.push(P_ELITE).push("" + x));
                    }
                }
            } else if (state.parameters.exists(base.push(P_ELITE_FRAC).push("" + x), null)) {
                this.eliteFrac[x] = state.parameters.getDoubleWithMax(base.push(P_ELITE_FRAC).push("" + x), null, 0.0, 1.0);
                if (this.eliteFrac[x] < 0.0) {
                    state.output.error("Elite Fraction of subpopulation " + x + " must be a real value between 0.0 and 1.0 inclusive", base.push(P_ELITE_FRAC).push("" + x));
                }
            } else if (defaultSubpop >= 0) {
                if (state.parameters.exists(base.push(P_ELITE).push("" + defaultSubpop), null)) {
                    this.elite[x] = state.parameters.getIntWithDefault(base.push(P_ELITE).push("" + defaultSubpop), null, 0);
                    if (this.elite[x] < 0) {
                        state.output.warning("Invalid default subpopulation elite value.");
                    }
                } else if (state.parameters.exists(base.push(P_ELITE_FRAC).push("" + defaultSubpop), null)) {
                    this.eliteFrac[x] = state.parameters.getDoubleWithMax(base.push(P_ELITE_FRAC).push("" + defaultSubpop), null, 0.0, 1.0);
                    if (this.eliteFrac[x] < 0.0) {
                        state.output.warning("Invalid default subpopulation elite-frac value.");
                    }
                } else {
                    this.elite[x] = 0;
                }
            } else {
                this.elite[x] = 0;
            }
            if (defaultSubpop >= 0 && !state.parameters.exists(base.push(P_REEVALUATE_ELITES).push("" + x), null)) {
                this.reevaluateElites[x] = state.parameters.getBoolean(base.push(P_REEVALUATE_ELITES).push("" + defaultSubpop), null, false);
                if (!this.reevaluateElites[x]) continue;
                state.output.warning("Elite reevaluation not specified for subpopulation " + x + ".  Using values for default subpopulation " + defaultSubpop + ": " + this.reevaluateElites[x]);
                continue;
            }
            this.reevaluateElites[x] = state.parameters.getBoolean(base.push(P_REEVALUATE_ELITES).push("" + x), null, false);
        }
        state.output.exitIfErrors();
    }

    public int computeSubpopulationLength(EvolutionState state, Population newpop, int subpopulation, int threadnum) {
        if (!this.shouldBreedSubpop(state, subpopulation, threadnum)) {
            return newpop.subpops[subpopulation].individuals.length;
        }
        return newpop.subpops[subpopulation].individuals.length - this.numElites(state, subpopulation);
    }

    public Population breedPopulation(EvolutionState state) {
        Population newpop = null;
        if (this.clonePipelineAndPopulation) {
            newpop = (Population)state.population.emptyClone();
        } else {
            if (this.backupPopulation == null) {
                this.backupPopulation = (Population)state.population.emptyClone();
            }
            newpop = this.backupPopulation;
            newpop.clear();
            this.backupPopulation = state.population;
        }
        for (int i = 0; i < state.population.subpops.length; ++i) {
            int prospectiveSize;
            if (this.reduceBy[i] <= 0 || (prospectiveSize = Math.max(Math.max(state.population.subpops[i].individuals.length - this.reduceBy[i], this.minimumSize[i]), this.numElites(state, i))) >= state.population.subpops[i].individuals.length) continue;
            state.output.message("Subpop " + i + " reduced " + state.population.subpops[i].individuals.length + " -> " + prospectiveSize);
            newpop.subpops[i].resize(prospectiveSize);
        }
        this.loadElites(state, newpop);
        int numThreads = 0;
        for (int x = 0; x < state.population.subpops.length; ++x) {
            numThreads = Math.max(numThreads, state.population.subpops[x].individuals.length);
        }
        if ((numThreads = Math.min(numThreads, state.breedthreads)) < state.breedthreads) {
            state.output.warnOnce("Largest subpopulation size (" + numThreads + ") is smaller than number of breedthreads (" + state.breedthreads + "), so fewer breedthreads will be created.");
        }
        int[][] numinds = new int[numThreads][state.population.subpops.length];
        int[][] from = new int[numThreads][state.population.subpops.length];
        for (int x = 0; x < state.population.subpops.length; ++x) {
            int length = this.computeSubpopulationLength(state, newpop, x, 0);
            int individualsPerThread = length / numThreads;
            int slop = length - numThreads * individualsPerThread;
            int currentFrom = 0;
            for (int y = 0; y < numThreads; ++y) {
                if (slop > 0) {
                    numinds[y][x] = individualsPerThread + 1;
                    --slop;
                } else {
                    numinds[y][x] = individualsPerThread;
                }
                if (numinds[y][x] == 0) {
                    state.output.warnOnce("More threads exist than can be used to breed some subpopulations (first example: subpopulation " + x + ")");
                }
                from[y][x] = currentFrom;
                currentFrom += numinds[y][x];
            }
        }
        if (numThreads == 1) {
            this.breedPopChunk(newpop, state, numinds[0], from[0], 0);
        } else {
            for (int y = 0; y < numThreads; ++y) {
                SimpleBreederThread r = new SimpleBreederThread();
                r.threadnum = y;
                r.newpop = newpop;
                r.numinds = numinds[y];
                r.from = from[y];
                r.me = this;
                r.state = state;
                this.pool.start((Runnable)r, "ECJ Breeding Thread " + y);
            }
            this.pool.joinAll();
        }
        return newpop;
    }

    public boolean shouldBreedSubpop(EvolutionState state, int subpop, int threadnum) {
        return !this.sequentialBreeding || state.generation % state.population.subpops.length == subpop;
    }

    protected void breedPopChunk(Population newpop, EvolutionState state, int[] numinds, int[] from, int threadnum) {
        for (int subpop = 0; subpop < newpop.subpops.length; ++subpop) {
            int x;
            if (!this.shouldBreedSubpop(state, subpop, threadnum)) {
                for (int ind = from[subpop]; ind < numinds[subpop] - from[subpop]; ++ind) {
                    newpop.subpops[subpop].individuals[ind] = state.population.subpops[subpop].individuals[ind];
                }
                continue;
            }
            BreedingPipeline bp = null;
            bp = this.clonePipelineAndPopulation ? (BreedingPipeline)newpop.subpops[subpop].species.pipe_prototype.clone() : newpop.subpops[subpop].species.pipe_prototype;
            if (!bp.produces(state, newpop, subpop, threadnum)) {
                state.output.fatal("The Breeding Pipeline of subpopulation " + subpop + " does not produce individuals of the expected species " + newpop.subpops[subpop].species.getClass().getName() + " or fitness " + newpop.subpops[subpop].species.f_prototype);
            }
            bp.prepareToProduce(state, subpop, threadnum);
            int upperbound = from[subpop] + numinds[subpop];
            for (x = from[subpop]; x < upperbound; x += bp.produce(1, upperbound - x, x, subpop, newpop.subpops[subpop].individuals, state, threadnum)) {
            }
            if (x > upperbound) {
                state.output.fatal("Whoa!  A breeding pipeline overwrote the space of another pipeline in subpopulation " + subpop + ".  You need to check your breeding pipeline code (in produce() ).");
            }
            bp.finishProducing(state, subpop, threadnum);
        }
    }

    protected void unmarkElitesEvaluated(EvolutionState state, Population newpop) {
        for (int sub = 0; sub < newpop.subpops.length; ++sub) {
            if (!this.shouldBreedSubpop(state, sub, 0)) continue;
            for (int e = 0; e < this.numElites(state, sub); ++e) {
                int len = newpop.subpops[sub].individuals.length;
                if (!this.reevaluateElites[sub]) continue;
                newpop.subpops[sub].individuals[len - e - 1].evaluated = false;
            }
        }
    }

    protected void loadElites(EvolutionState state, Population newpop) {
        for (int x = 0; x < state.population.subpops.length; ++x) {
            if (this.numElites(state, x) > state.population.subpops[x].individuals.length) {
                state.output.error("The number of elites for subpopulation " + x + " exceeds the actual size of the subpopulation", new Parameter("breed").push(P_ELITE).push("" + x));
            }
            if (this.numElites(state, x) != state.population.subpops[x].individuals.length) continue;
            state.output.warning("The number of elites for subpopulation " + x + " is the actual size of the subpopulation", new Parameter("breed").push(P_ELITE).push("" + x));
        }
        state.output.exitIfErrors();
        for (int sub = 0; sub < state.population.subpops.length; ++sub) {
            if (!this.shouldBreedSubpop(state, sub, 0)) continue;
            if (this.numElites(state, sub) == 1) {
                int best = 0;
                Individual[] oldinds = state.population.subpops[sub].individuals;
                for (int x = 1; x < oldinds.length; ++x) {
                    if (!oldinds[x].fitness.betterThan(oldinds[best].fitness)) continue;
                    best = x;
                }
                Individual[] inds = newpop.subpops[sub].individuals;
                inds[inds.length - 1] = (Individual)oldinds[best].clone();
                continue;
            }
            if (this.numElites(state, sub) <= 0) continue;
            int[] orderedPop = new int[state.population.subpops[sub].individuals.length];
            for (int x = 0; x < state.population.subpops[sub].individuals.length; ++x) {
                orderedPop[x] = x;
            }
            QuickSort.qsort(orderedPop, (SortComparatorL)new EliteComparator(state.population.subpops[sub].individuals));
            Individual[] inds = newpop.subpops[sub].individuals;
            Individual[] oldinds = state.population.subpops[sub].individuals;
            for (int x = inds.length - this.numElites(state, sub); x < inds.length; ++x) {
                inds[x] = (Individual)oldinds[orderedPop[x]].clone();
            }
        }
        this.unmarkElitesEvaluated(state, newpop);
    }

    static class EliteComparator
    implements SortComparatorL {
        Individual[] inds;

        public EliteComparator(Individual[] inds) {
            this.inds = inds;
        }

        public boolean lt(long a, long b) {
            return this.inds[(int)b].fitness.betterThan(this.inds[(int)a].fitness);
        }

        public boolean gt(long a, long b) {
            return this.inds[(int)a].fitness.betterThan(this.inds[(int)b].fitness);
        }
    }
}

