/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.Individual;
import ec.Species;
import ec.util.Parameter;
import ec.vector.FloatVectorSpecies;
import ec.vector.IntegerVectorSpecies;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;

public class VectorSpecies
extends Species {
    public static final String P_VECTORSPECIES = "species";
    public static final String P_CROSSOVERTYPE = "crossover-type";
    public static final String P_CHUNKSIZE = "chunk-size";
    public static final String V_ONE_POINT = "one";
    public static final String V_ONE_POINT_NO_NOP = "one-nonempty";
    public static final String V_TWO_POINT = "two";
    public static final String V_TWO_POINT_NO_NOP = "two-nonempty";
    public static final String V_ANY_POINT = "any";
    public static final String V_LINE_RECOMB = "line";
    public static final String V_INTERMED_RECOMB = "intermediate";
    public static final String V_SIMULATED_BINARY = "sbx";
    public static final String P_CROSSOVER_DISTRIBUTION_INDEX = "crossover-distribution-index";
    public static final String P_MUTATIONPROB = "mutation-prob";
    public static final String P_CROSSOVERPROB = "crossover-prob";
    public static final String P_GENOMESIZE = "genome-size";
    public static final String P_LINEDISTANCE = "line-extension";
    public static final String V_GEOMETRIC = "geometric";
    public static final String P_GEOMETRIC_PROBABILITY = "geometric-prob";
    public static final String V_UNIFORM = "uniform";
    public static final String P_UNIFORM_MIN = "min-initial-size";
    public static final String P_UNIFORM_MAX = "max-initial-size";
    public static final String P_NUM_SEGMENTS = "num-segments";
    public static final String P_SEGMENT_TYPE = "segment-type";
    public static final String P_SEGMENT_START = "start";
    public static final String P_SEGMENT_END = "end";
    public static final String P_SEGMENT = "segment";
    public static final String P_DUPLICATE_RETRIES = "duplicate-retries";
    public static final int C_ONE_POINT = 0;
    public static final int C_ONE_POINT_NO_NOP = 2;
    public static final int C_TWO_POINT = 4;
    public static final int C_TWO_POINT_NO_NOP = 8;
    public static final int C_ANY_POINT = 128;
    public static final int C_LINE_RECOMB = 256;
    public static final int C_INTERMED_RECOMB = 512;
    public static final int C_SIMULATED_BINARY = 1024;
    public static final int C_NONE = 0;
    public static final int C_GEOMETRIC = 1;
    public static final int C_UNIFORM = 2;
    protected int[] duplicateRetries;
    protected double[] mutationProbability;
    public double crossoverProbability;
    public int crossoverType;
    public int genomeSize;
    public int crossoverDistributionIndex;
    public int genomeResizeAlgorithm;
    public int minInitialSize;
    public int maxInitialSize;
    public double genomeIncreaseProbability;
    public int chunksize;
    public double lineDistance;
    public boolean dynamicInitialSize = false;

    public double mutationProbability(int gene) {
        double[] m = this.mutationProbability;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public int duplicateRetries(int gene) {
        int[] m = this.duplicateRetries;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_VECTORSPECIES);
    }

    protected void setupGenome(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        String genomeSizeForm = state.parameters.getString(base.push(P_GENOMESIZE), def.push(P_GENOMESIZE));
        if (genomeSizeForm == null) {
            state.output.fatal("No genome size specified.", base.push(P_GENOMESIZE), def.push(P_GENOMESIZE));
        } else if (genomeSizeForm.equals(V_GEOMETRIC)) {
            this.dynamicInitialSize = true;
            this.genomeSize = 1;
            this.genomeResizeAlgorithm = 1;
            this.chunksize = state.parameters.getIntWithDefault(base.push(P_CHUNKSIZE), def.push(P_CHUNKSIZE), 1);
            if (this.chunksize != 1) {
                state.output.fatal("To use Geometric size initialization, VectorSpecies must have a chunksize of 1", base.push(P_CHUNKSIZE), def.push(P_CHUNKSIZE));
            }
            this.minInitialSize = state.parameters.getInt(base.push(P_UNIFORM_MIN), def.push(P_UNIFORM_MIN), 0);
            if (this.minInitialSize < 0) {
                state.output.warning("Gemoetric size initialization used, but no minimum initial size provided.  Assuming minimum is 0.");
                this.minInitialSize = 0;
            }
            this.genomeIncreaseProbability = state.parameters.getDoubleWithMax(base.push(P_GEOMETRIC_PROBABILITY), def.push(P_GEOMETRIC_PROBABILITY), 0.0, 1.0);
            if (this.genomeIncreaseProbability < 0.0 || this.genomeIncreaseProbability >= 1.0) {
                state.output.fatal("To use Gemoetric size initialization, the genome increase probability must be >= 0.0 and < 1.0", base.push(P_GEOMETRIC_PROBABILITY), def.push(P_GEOMETRIC_PROBABILITY));
            }
        } else if (genomeSizeForm.equals(V_UNIFORM)) {
            this.dynamicInitialSize = true;
            this.genomeSize = 1;
            this.genomeResizeAlgorithm = 2;
            this.chunksize = state.parameters.getIntWithDefault(base.push(P_CHUNKSIZE), def.push(P_CHUNKSIZE), 1);
            if (this.chunksize != 1) {
                state.output.fatal("To use Uniform size initialization, VectorSpecies must have a chunksize of 1", base.push(P_CHUNKSIZE), def.push(P_CHUNKSIZE));
            }
            this.minInitialSize = state.parameters.getInt(base.push(P_UNIFORM_MIN), def.push(P_UNIFORM_MIN), 0);
            if (this.minInitialSize < 0) {
                state.output.fatal("To use Uniform size initialization, you must set a minimum initial size >= 0", base.push(P_UNIFORM_MIN), def.push(P_UNIFORM_MIN));
            }
            this.maxInitialSize = state.parameters.getInt(base.push(P_UNIFORM_MAX), def.push(P_UNIFORM_MAX), 0);
            if (this.maxInitialSize < 0) {
                state.output.fatal("To use Uniform size initialization, you must set a maximum initial size >= 0", base.push(P_UNIFORM_MAX), def.push(P_UNIFORM_MAX));
            }
            if (this.maxInitialSize < this.minInitialSize) {
                state.output.fatal("To use Uniform size initialization, you must set a maximum initial size >= the minimum initial size", base.push(P_UNIFORM_MAX), def.push(P_UNIFORM_MAX));
            }
        } else {
            this.genomeSize = state.parameters.getInt(base.push(P_GENOMESIZE), def.push(P_GENOMESIZE), 1);
            if (this.genomeSize == 0) {
                state.output.fatal("VectorSpecies must have a genome size > 0", base.push(P_GENOMESIZE), def.push(P_GENOMESIZE));
            }
            this.genomeResizeAlgorithm = 0;
            this.chunksize = state.parameters.getIntWithDefault(base.push(P_CHUNKSIZE), def.push(P_CHUNKSIZE), 1);
            if (this.chunksize <= 0 || this.chunksize > this.genomeSize) {
                state.output.fatal("VectorSpecies must have a chunksize which is > 0 and < genomeSize", base.push(P_CHUNKSIZE), def.push(P_CHUNKSIZE));
            }
            if (this.genomeSize % this.chunksize != 0) {
                state.output.fatal("VectorSpecies must have a genomeSize which is a multiple of chunksize", base.push(P_CHUNKSIZE), def.push(P_CHUNKSIZE));
            }
        }
    }

    public void setup(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        this.i_prototype = (Individual)state.parameters.getInstanceForParameter(base.push("ind"), def.push("ind"), Individual.class);
        this.setupGenome(state, base);
        double _mutationProbability = state.parameters.getDoubleWithMax(base.push(P_MUTATIONPROB), def.push(P_MUTATIONPROB), 0.0, 1.0);
        if (_mutationProbability == -1.0) {
            state.output.fatal("Global mutation probability must be between 0.0 and 1.0 inclusive", base.push(P_MUTATIONPROB), def.push(P_MUTATIONPROB));
        }
        this.mutationProbability = this.fill(new double[this.genomeSize + 1], _mutationProbability);
        int _duplicateRetries = state.parameters.getIntWithDefault(base.push(P_DUPLICATE_RETRIES), def.push(P_DUPLICATE_RETRIES), 0);
        if (_duplicateRetries < 0) {
            state.output.fatal("Duplicate Retries, if defined, must be a value >= 0", base.push(P_DUPLICATE_RETRIES), def.push(P_DUPLICATE_RETRIES));
        }
        this.duplicateRetries = this.fill(new int[this.genomeSize + 1], _duplicateRetries);
        String ctype = state.parameters.getStringWithDefault(base.push(P_CROSSOVERTYPE), def.push(P_CROSSOVERTYPE), null);
        this.crossoverType = 0;
        if (ctype == null) {
            state.output.warning("No crossover type given for VectorSpecies, assuming one-point crossover", base.push(P_CROSSOVERTYPE), def.push(P_CROSSOVERTYPE));
        } else if (ctype.equalsIgnoreCase(V_ONE_POINT)) {
            this.crossoverType = 0;
        } else if (ctype.equalsIgnoreCase(V_ONE_POINT_NO_NOP)) {
            this.crossoverType = 2;
        } else if (ctype.equalsIgnoreCase(V_TWO_POINT)) {
            this.crossoverType = 4;
        } else if (ctype.equalsIgnoreCase(V_TWO_POINT_NO_NOP)) {
            this.crossoverType = 8;
        } else if (ctype.equalsIgnoreCase(V_ANY_POINT)) {
            this.crossoverType = 128;
        } else if (ctype.equalsIgnoreCase(V_LINE_RECOMB)) {
            this.crossoverType = 256;
        } else if (ctype.equalsIgnoreCase(V_INTERMED_RECOMB)) {
            this.crossoverType = 512;
        } else if (ctype.equalsIgnoreCase(V_SIMULATED_BINARY)) {
            this.crossoverType = 1024;
        } else {
            state.output.fatal("VectorSpecies given a bad crossover type: " + ctype, base.push(P_CROSSOVERTYPE), def.push(P_CROSSOVERTYPE));
        }
        if (this.crossoverType == 256 || this.crossoverType == 512) {
            if (!(this instanceof IntegerVectorSpecies) && !(this instanceof FloatVectorSpecies)) {
                state.output.fatal("Line and intermediate recombinations are only supported by IntegerVectorSpecies and FloatVectorSpecies", base.push(P_CROSSOVERTYPE), def.push(P_CROSSOVERTYPE));
            }
            this.lineDistance = state.parameters.getDouble(base.push(P_LINEDISTANCE), def.push(P_LINEDISTANCE), 0.0);
            if (this.lineDistance == -1.0) {
                state.output.fatal("If it's going to use line or intermediate recombination, VectorSpecies needs a line extension >= 0.0  (0.25 is common)", base.push(P_LINEDISTANCE), def.push(P_LINEDISTANCE));
            }
        } else {
            this.lineDistance = 0.0;
        }
        if (this.crossoverType == 128) {
            this.crossoverProbability = state.parameters.getDoubleWithMax(base.push(P_CROSSOVERPROB), def.push(P_CROSSOVERPROB), 0.0, 0.5);
            if (this.crossoverProbability == -1.0) {
                state.output.fatal("If it's going to use any-point crossover, VectorSpecies must have a crossover probability between 0.0 and 0.5 inclusive", base.push(P_CROSSOVERPROB), def.push(P_CROSSOVERPROB));
            }
        } else if (this.crossoverType == 1024) {
            if (!(this instanceof FloatVectorSpecies)) {
                state.output.fatal("Simulated binary crossover (SBX) is only supported by FloatVectorSpecies", base.push(P_CROSSOVERTYPE), def.push(P_CROSSOVERTYPE));
            }
            this.crossoverDistributionIndex = state.parameters.getInt(base.push(P_CROSSOVER_DISTRIBUTION_INDEX), def.push(P_CROSSOVER_DISTRIBUTION_INDEX), 0);
            if (this.crossoverDistributionIndex < 0) {
                state.output.fatal("If FloatVectorSpecies is going to use simulated binary crossover (SBX), the distribution index must be defined and >= 0.", base.push(P_CROSSOVER_DISTRIBUTION_INDEX), def.push(P_CROSSOVER_DISTRIBUTION_INDEX));
            }
        } else {
            this.crossoverProbability = 0.0;
        }
        state.output.exitIfErrors();
        if (this.crossoverType != 128 && state.parameters.exists(base.push(P_CROSSOVERPROB), def.push(P_CROSSOVERPROB))) {
            state.output.warning("The 'crossover-prob' parameter may only be used with any-point crossover.  It states the probability that a particular gene will be crossed over.  If you were looking for the probability of crossover happening at *all*, look at the 'likelihood' parameter.", base.push(P_CROSSOVERPROB), def.push(P_CROSSOVERPROB));
        }
        int numSegments = 0;
        if (state.parameters.exists(base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS))) {
            if (this.dynamicInitialSize) {
                state.output.warnOnce("Using dynamic initial sizing, but per-segment min/max gene declarations.  This is probably wrong.  You probably want to use global min/max declarations.", base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS));
            }
            if ((numSegments = state.parameters.getIntWithDefault(base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS), 0)) == 0) {
                state.output.warning("The number of genome segments has been defined to be equal to 0.\nHence, no genome segments will be defined.", base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS));
            } else if (numSegments < 0) {
                state.output.fatal("Invalid number of genome segments: " + numSegments + "\nIt must be a nonnegative value.", base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS));
            }
            String segmentType = state.parameters.getStringWithDefault(base.push(P_SEGMENT_TYPE), def.push(P_SEGMENT_TYPE), P_SEGMENT_START);
            if (segmentType.equalsIgnoreCase(P_SEGMENT_START)) {
                this.initializeGenomeSegmentsByStartIndices(state, base, def, numSegments);
            } else if (segmentType.equalsIgnoreCase(P_SEGMENT_END)) {
                this.initializeGenomeSegmentsByEndIndices(state, base, def, numSegments);
            } else {
                state.output.fatal("Invalid specification of genome segment type: " + segmentType + "\nThe " + P_SEGMENT_TYPE + " parameter must have the value of " + P_SEGMENT_START + " or " + P_SEGMENT_END, base.push(P_SEGMENT_TYPE), def.push(P_SEGMENT_TYPE));
            }
        }
        state.output.exitIfErrors();
        for (int x = 0; x < this.genomeSize; ++x) {
            this.loadParametersForGene(state, x, base, def, "" + x);
        }
        state.output.exitIfErrors();
        super.setup(state, base);
    }

    protected void loadParametersForGene(EvolutionState state, int index, Parameter base, Parameter def, String postfix) {
        if (state.parameters.exists(base.push(P_MUTATIONPROB).push(postfix), def.push(P_MUTATIONPROB).push(postfix))) {
            this.mutationProbability[index] = state.parameters.getDoubleWithMax(base.push(P_MUTATIONPROB).push(postfix), def.push(P_MUTATIONPROB).push(postfix), 0.0, 1.0);
            if (this.mutationProbability[index] == -1.0) {
                state.output.fatal("Per-gene or per-segment mutation probability must be between 0.0 and 1.0 inclusive", base.push(P_MUTATIONPROB).push(postfix), def.push(P_MUTATIONPROB).push(postfix));
            }
        }
        if (state.parameters.exists(base.push(P_DUPLICATE_RETRIES).push(postfix), def.push(P_DUPLICATE_RETRIES).push(postfix))) {
            this.duplicateRetries[index] = state.parameters.getInt(base.push(P_DUPLICATE_RETRIES).push(postfix), def.push(P_DUPLICATE_RETRIES).push(postfix));
            if (this.duplicateRetries[index] < 0) {
                state.output.fatal("Duplicate Retries for gene " + index + ", if defined must be a value >= 0", base.push(P_DUPLICATE_RETRIES).push(postfix), def.push(P_DUPLICATE_RETRIES).push(postfix));
            }
        }
    }

    protected void initializeGenomeSegmentsByStartIndices(EvolutionState state, Parameter base, Parameter def, int numSegments) {
        int previousSegmentEnd = this.genomeSize;
        int currentSegmentEnd = 0;
        for (int i = numSegments - 1; i >= 0; --i) {
            if (state.parameters.exists(base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START), def.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START))) {
                currentSegmentEnd = state.parameters.getInt(base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START), def.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START));
            } else {
                state.output.fatal("Genome segment " + i + " has not been defined!\nYou must specify start indices for " + numSegments + " segment(s)", base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START), base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START));
            }
            if (currentSegmentEnd >= previousSegmentEnd || currentSegmentEnd < 0) {
                state.output.fatal("Invalid start index value for segment " + i + ": " + currentSegmentEnd + "\nThe value must be smaller than " + previousSegmentEnd + " and greater than or equal to  " + 0);
            }
            if (i == 0 && currentSegmentEnd != 0) {
                state.output.fatal("Invalid start index value for the first segment " + i + ": " + currentSegmentEnd + "\nThe value must be equal to " + 0);
            }
            for (int j = previousSegmentEnd - 1; j >= currentSegmentEnd; --j) {
                this.loadParametersForGene(state, j, base.push(P_SEGMENT).push("" + i), def.push(P_SEGMENT).push("" + i), "");
            }
            previousSegmentEnd = currentSegmentEnd;
        }
    }

    protected void initializeGenomeSegmentsByEndIndices(EvolutionState state, Parameter base, Parameter def, int numSegments) {
        int previousSegmentEnd = -1;
        int currentSegmentEnd = 0;
        for (int i = 0; i < numSegments; ++i) {
            if (state.parameters.exists(base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END), def.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END))) {
                currentSegmentEnd = state.parameters.getInt(base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END), def.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END));
            } else {
                state.output.fatal("Genome segment " + i + " has not been defined!\nYou must specify end indices for " + numSegments + " segment(s)", base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END), base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END));
            }
            if (currentSegmentEnd <= previousSegmentEnd || currentSegmentEnd >= this.genomeSize) {
                state.output.fatal("Invalid end index value for segment " + i + ": " + currentSegmentEnd + "\nThe value must be greater than " + previousSegmentEnd + " and smaller than " + this.genomeSize);
            }
            if (i == numSegments - 1 && currentSegmentEnd != this.genomeSize - 1) {
                state.output.fatal("Invalid end index value for the last segment " + i + ": " + currentSegmentEnd + "\nThe value must be equal to the index of the last gene in the genome:  " + (this.genomeSize - 1));
            }
            for (int j = previousSegmentEnd + 1; j <= currentSegmentEnd; ++j) {
                this.loadParametersForGene(state, j, base.push(P_SEGMENT).push("" + i), def.push(P_SEGMENT).push("" + i), "");
            }
            previousSegmentEnd = currentSegmentEnd;
        }
    }

    public Individual newIndividual(EvolutionState state, int thread) {
        VectorIndividual newind = (VectorIndividual)super.newIndividual(state, thread);
        if (this.genomeResizeAlgorithm == 0) {
            newind.reset(state, thread);
        } else if (this.genomeResizeAlgorithm == 2) {
            int size = state.random[thread].nextInt(this.maxInitialSize - this.minInitialSize + 1) + this.minInitialSize;
            newind.reset(state, thread, size);
        } else if (this.genomeResizeAlgorithm == 1) {
            int size = this.minInitialSize;
            while (state.random[thread].nextBoolean(this.genomeIncreaseProbability)) {
                ++size;
            }
            newind.reset(state, thread, size);
        }
        return newind;
    }

    protected long[] fill(long[] array, long val) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = val;
        }
        return array;
    }

    protected int[] fill(int[] array, int val) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = val;
        }
        return array;
    }

    protected boolean[] fill(boolean[] array, boolean val) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = val;
        }
        return array;
    }

    protected double[] fill(double[] array, double val) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = val;
        }
        return array;
    }

    protected int contains(boolean[] array, boolean val) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != val) continue;
            return i;
        }
        return -1;
    }

    protected int contains(long[] array, long val) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != val) continue;
            return i;
        }
        return -1;
    }

    protected int contains(int[] array, int val) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != val) continue;
            return i;
        }
        return -1;
    }

    protected int contains(double[] array, double val) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != val) continue;
            return i;
        }
        return -1;
    }
}

