/*
 * Decompiled with CFR 0.152.
 */
package ec.vector.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.util.Parameter;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;
import ec.vector.VectorSpecies;

public class ListCrossoverPipeline
extends BreedingPipeline {
    public static final String P_TOSS = "toss";
    public static final String P_LIST_CROSSOVER = "list-xover";
    public static final String P_MIN_CHILD_SIZE = "min-child-size";
    public static final String P_NUM_TRIES = "tries";
    public static final String P_MIN_CROSSOVER_PERCENT = "min-crossover-percent";
    public static final String P_MAX_CROSSOVER_PERCENT = "max-crossover-percent";
    public static final int NUM_SOURCES = 2;
    public boolean tossSecondParent;
    public int crossoverType;
    public int minChildSize;
    public int numTries;
    public double minCrossoverPercentage;
    public double maxCrossoverPercentage;
    protected VectorIndividual[] parents = new VectorIndividual[2];

    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_LIST_CROSSOVER);
    }

    public int numSources() {
        return 2;
    }

    public Object clone() {
        ListCrossoverPipeline c = (ListCrossoverPipeline)super.clone();
        c.parents = (VectorIndividual[])this.parents.clone();
        return c;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.tossSecondParent = state.parameters.getBoolean(base.push(P_TOSS), def.push(P_TOSS), false);
        this.minChildSize = state.parameters.getIntWithDefault(base.push(P_MIN_CHILD_SIZE), def.push(P_MIN_CHILD_SIZE), 0);
        this.numTries = state.parameters.getIntWithDefault(base.push(P_NUM_TRIES), def.push(P_NUM_TRIES), 1);
        this.minCrossoverPercentage = state.parameters.getDoubleWithDefault(base.push(P_MIN_CROSSOVER_PERCENT), def.push(P_MIN_CROSSOVER_PERCENT), 0.0);
        this.maxCrossoverPercentage = state.parameters.getDoubleWithDefault(base.push(P_MAX_CROSSOVER_PERCENT), def.push(P_MAX_CROSSOVER_PERCENT), 1.0);
        String crossoverTypeString = state.parameters.getStringWithDefault(base.push("crossover-type"), def.push("crossover-type"), "two");
        if (crossoverTypeString.equalsIgnoreCase("one")) {
            this.crossoverType = 0;
        } else if (crossoverTypeString.equalsIgnoreCase("two")) {
            this.crossoverType = 4;
        } else {
            state.output.error("ListCrossoverPipeline:\n:   Parameter crossover-type is currently set to: " + crossoverTypeString + "\n   Currently supported crossover types are \"one\" and \"two\" point.\n");
        }
        if (this.minChildSize < 0) {
            state.output.error("ListCrossoverPipeline:\n   Parameter min-child-size is currently equal to: " + Integer.toString(this.minChildSize) + "\n   min-child-size must be a positive integer\n");
        }
        if (this.numTries < 1) {
            state.output.error("ListCrossoverPipeline:\n   Parameter tries is currently equal to: " + Integer.toString(this.numTries) + "\n   tries must be greater than or equal to 1\n");
        }
        if (this.minCrossoverPercentage < 0.0 || this.minCrossoverPercentage > 1.0) {
            state.output.error("ListCrossoverPipeline:\n   Parameter min-crossover-percent is currently equal to: " + Double.toString(this.minCrossoverPercentage) + "\n   min-crossover-percent must be either a real-value double float between [0.0, 1.0] or left unspecified\n");
        }
        if (this.maxCrossoverPercentage < 0.0 || this.maxCrossoverPercentage > 1.0) {
            state.output.error("ListCrossoverPipeline:\n   Parameter max-crossover-percent is currently equal to: " + Double.toString(this.maxCrossoverPercentage) + "\n   max-crossover-percent must be either a real-value double float between [0.0, 1.0] or left unspecified\n");
        }
        if (this.minCrossoverPercentage > this.maxCrossoverPercentage) {
            state.output.error("ListCrossoverPipeline:\n   Parameter min-crossover-percent must be less than max-crossover-percent\n");
        }
        if (this.minCrossoverPercentage == this.maxCrossoverPercentage) {
            state.output.warning("ListCrossoverPipeline:\n   Parameter min-crossover-percent and max-crossover-percent are currently equal to: " + Double.toString(this.minCrossoverPercentage) + "\n   This effectively prevents any crossover from occurring\n");
        }
    }

    public int typicalIndsProduced() {
        return this.tossSecondParent ? this.minChildProduction() : this.minChildProduction() * 2;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n = this.typicalIndsProduced();
        if (n < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, true);
        }
        int q = start;
        while (q < n + start) {
            if (this.sources[0] == this.sources[1]) {
                this.sources[0].produce(2, 2, 0, subpopulation, this.parents, state, thread);
                if (!(this.sources[0] instanceof BreedingPipeline)) {
                    this.parents[0] = (VectorIndividual)this.parents[0].clone();
                    this.parents[1] = (VectorIndividual)this.parents[1].clone();
                }
            } else {
                this.sources[0].produce(1, 1, 0, subpopulation, this.parents, state, thread);
                this.sources[1].produce(1, 1, 1, subpopulation, this.parents, state, thread);
                if (!(this.sources[0] instanceof BreedingPipeline)) {
                    this.parents[0] = (VectorIndividual)this.parents[0].clone();
                }
                if (!(this.sources[1] instanceof BreedingPipeline)) {
                    this.parents[1] = (VectorIndividual)this.parents[1].clone();
                }
            }
            int chunk_size = ((VectorSpecies)this.parents[0].species).chunksize;
            int[] size = new int[]{this.parents[0].genomeLength(), this.parents[1].genomeLength()};
            int[] size_in_chunks = new int[]{size[0] / chunk_size, size[1] / chunk_size};
            int[] min_chunks = new int[2];
            int[] max_chunks = new int[2];
            int[][] split = new int[2][2];
            Object[][] pieces = new Object[2][3];
            for (int i = 0; i < 2; ++i) {
                min_chunks[i] = (int)((double)size_in_chunks[i] * this.minCrossoverPercentage);
                if (size[i] % chunk_size != 0 && min_chunks[i] < size_in_chunks[i]) {
                    int n2 = i;
                    min_chunks[n2] = min_chunks[n2] + 1;
                }
                max_chunks[i] = (int)((double)size_in_chunks[i] * this.maxCrossoverPercentage);
            }
            Object validationData = this.computeValidationData(state, this.parents, thread);
            boolean valid_children = false;
            for (int attempts = 0; !valid_children && attempts < this.numTries; ++attempts) {
                if (this.crossoverType == 0) {
                    for (int i = 0; i < 2; ++i) {
                        split[i][0] = size_in_chunks[i] - max_chunks[i];
                        int[] nArray = split[i];
                        nArray[0] = nArray[0] + state.random[thread].nextInt(max_chunks[i] - min_chunks[i]);
                        int[] nArray2 = split[i];
                        nArray2[0] = nArray2[0] * chunk_size;
                        split[i][1] = size_in_chunks[i] * chunk_size;
                    }
                } else if (this.crossoverType == 4) {
                    block4: for (int i = 0; i < 2; ++i) {
                        do {
                            int len;
                            split[i][0] = state.random[thread].nextInt(size_in_chunks[i] + 1);
                            split[i][1] = state.random[thread].nextInt(size_in_chunks[i] + 1);
                            if (split[i][0] > split[i][1]) {
                                int temp = split[i][0];
                                split[i][0] = split[i][1];
                                split[i][1] = temp;
                            }
                            if ((len = split[i][0] - split[i][1]) < min_chunks[i] || len > max_chunks[i]) continue;
                            int[] nArray = split[i];
                            nArray[0] = nArray[0] * chunk_size;
                            int[] nArray3 = split[i];
                            nArray3[1] = nArray3[1] * chunk_size;
                            continue block4;
                        } while (++attempts <= this.numTries);
                    }
                } else {
                    state.output.fatal("Unknown crossover type specified: " + this.crossoverType);
                }
                if (attempts >= this.numTries) break;
                this.parents[0].split(split[0], pieces[0]);
                this.parents[1].split(split[1], pieces[1]);
                VectorIndividual[] children = new VectorIndividual[]{(VectorIndividual)this.parents[0].clone(), (VectorIndividual)this.parents[1].clone()};
                Object swap = pieces[0][1];
                pieces[0][1] = pieces[1][1];
                pieces[1][1] = swap;
                children[0].join(pieces[0]);
                children[1].join(pieces[1]);
                if (children[0].genomeLength() <= this.minChildSize || children[1].genomeLength() <= this.minChildSize || !this.isValidated(split, validationData)) continue;
                valid_children = true;
            }
            if (valid_children) {
                this.parents[0].join(pieces[0]);
                this.parents[1].join(pieces[1]);
                this.parents[0].evaluated = false;
                this.parents[1].evaluated = false;
            }
            inds[q] = this.parents[0];
            if (++q >= n + start || this.tossSecondParent) continue;
            inds[q] = this.parents[1];
            ++q;
        }
        return n;
    }

    public Object computeValidationData(EvolutionState state, VectorIndividual[] parents, int thread) {
        return null;
    }

    public boolean isValidated(int[][] split, Object validationData) {
        return true;
    }
}

