/*
 * Decompiled with CFR 0.152.
 */
package ec.vector.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.util.Parameter;
import ec.vector.BitVectorIndividual;
import ec.vector.ByteVectorIndividual;
import ec.vector.DoubleVectorIndividual;
import ec.vector.FloatVectorIndividual;
import ec.vector.Gene;
import ec.vector.GeneVectorIndividual;
import ec.vector.IntegerVectorIndividual;
import ec.vector.LongVectorIndividual;
import ec.vector.ShortVectorIndividual;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;
import ec.vector.VectorSpecies;

public class MultipleVectorCrossoverPipeline
extends BreedingPipeline {
    public static final String P_CROSSOVER = "multixover";
    VectorIndividual[] parents;

    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_CROSSOVER);
    }

    public int numSources() {
        return -1;
    }

    public Object clone() {
        MultipleVectorCrossoverPipeline c = (MultipleVectorCrossoverPipeline)super.clone();
        c.parents = (VectorIndividual[])this.parents.clone();
        return c;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (this.sources.length <= 2) {
            state.output.fatal("num-sources must be provided and > 2 for MultipleVectorCrossoverPipeline", base.push("num-sources"), def.push("num-sources"));
        }
        this.parents = new VectorIndividual[this.sources.length];
    }

    public int typicalIndsProduced() {
        return this.minChildProduction() * this.sources.length;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n = this.typicalIndsProduced();
        if (n < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, true);
        }
        if (inds[0] instanceof BitVectorIndividual) {
            n = this.multipleBitVectorCrossover(min, max, start, subpopulation, inds, state, thread);
        } else if (inds[0] instanceof ByteVectorIndividual) {
            n = this.multipleByteVectorCrossover(min, max, start, subpopulation, inds, state, thread);
        } else if (inds[0] instanceof DoubleVectorIndividual) {
            n = this.multipleDoubleVectorCrossover(min, max, start, subpopulation, inds, state, thread);
        } else if (inds[0] instanceof FloatVectorIndividual) {
            n = this.multipleFloatVectorCrossover(min, max, start, subpopulation, inds, state, thread);
        } else if (inds[0] instanceof IntegerVectorIndividual) {
            n = this.multipleIntegerVectorCrossover(min, max, start, subpopulation, inds, state, thread);
        } else if (inds[0] instanceof GeneVectorIndividual) {
            n = this.multipleGeneVectorCrossover(min, max, start, subpopulation, inds, state, thread);
        } else if (inds[0] instanceof LongVectorIndividual) {
            n = this.multipleLongVectorCrossover(min, max, start, subpopulation, inds, state, thread);
        } else if (inds[0] instanceof ShortVectorIndividual) {
            n = this.multipleShortVectorCrossover(min, max, start, subpopulation, inds, state, thread);
        } else {
            int i;
            for (int i2 = 0; i2 < this.parents.length; ++i2) {
                this.sources[i2].produce(1, 1, i2, subpopulation, this.parents, state, thread);
                if (this.sources[i2] instanceof BreedingPipeline) continue;
                this.parents[i2] = (VectorIndividual)this.parents[i2].clone();
            }
            VectorSpecies species = (VectorSpecies)this.parents[0].species;
            int[] points = new int[this.parents[0].genomeLength() - 1];
            for (int i3 = 0; i3 < points.length; ++i3) {
                points[i3] = i3 + 1;
            }
            Object[][] pieces = new Object[this.parents.length][this.parents[0].genomeLength()];
            for (i = 0; i < this.parents.length; ++i) {
                if (this.parents[i].genomeLength() != this.parents[0].genomeLength()) {
                    state.output.fatal("All vectors must be of the same length for crossover!");
                    continue;
                }
                this.parents[i].split(points, pieces[i]);
            }
            for (i = 0; i < pieces[0].length; ++i) {
                if (!state.random[thread].nextBoolean(species.crossoverProbability)) continue;
                for (int j = pieces.length - 1; j > 0; --j) {
                    int parent2 = state.random[thread].nextInt(j);
                    Object temp = pieces[j][i];
                    pieces[j][i] = pieces[parent2][i];
                    pieces[parent2][i] = temp;
                }
            }
            i = 0;
            int q = start;
            while (i < this.parents.length) {
                this.parents[i].join(pieces[i]);
                this.parents[i].evaluated = false;
                if (q < inds.length) {
                    inds[q] = this.parents[i];
                }
                ++i;
                ++q;
            }
        }
        return n;
    }

    public int multipleBitVectorCrossover(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int i;
        int n;
        if (!(inds[0] instanceof BitVectorIndividual)) {
            state.output.fatal("Trying to produce bit vector individuals when you can't!");
        }
        if (this.sources.length <= 2) {
            state.output.error("Only two parents specified!");
        }
        if ((n = this.typicalIndsProduced()) < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            this.sources[i2].produce(1, 1, i2, subpopulation, this.parents, state, thread);
            if (this.sources[i2] instanceof BreedingPipeline) continue;
            this.parents[i2] = (BitVectorIndividual)this.parents[i2].clone();
        }
        VectorSpecies species = (VectorSpecies)inds[0].species;
        for (i = 0; i < this.parents[0].genomeLength(); ++i) {
            if (!state.random[thread].nextBoolean(species.crossoverProbability)) continue;
            for (int j = this.parents.length - 1; j > 0; --j) {
                int swapIndex = state.random[thread].nextInt(j);
                boolean temp = ((BitVectorIndividual)this.parents[j]).genome[i];
                ((BitVectorIndividual)this.parents[j]).genome[i] = ((BitVectorIndividual)this.parents[swapIndex]).genome[i];
                ((BitVectorIndividual)this.parents[swapIndex]).genome[i] = temp;
            }
        }
        i = 0;
        int q = start;
        while (i < this.parents.length) {
            this.parents[i].evaluated = false;
            if (q < inds.length) {
                inds[q] = (BitVectorIndividual)this.parents[i];
            }
            ++i;
            ++q;
        }
        return n;
    }

    public int multipleByteVectorCrossover(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int i;
        int n;
        if (!(inds[0] instanceof ByteVectorIndividual)) {
            state.output.fatal("Trying to produce byte vector individuals when you can't!");
        }
        if (this.sources.length <= 2) {
            state.output.error("Only two parents specified!");
        }
        if ((n = this.typicalIndsProduced()) < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            this.sources[i2].produce(1, 1, i2, subpopulation, this.parents, state, thread);
            if (this.sources[i2] instanceof BreedingPipeline) continue;
            this.parents[i2] = (ByteVectorIndividual)this.parents[i2].clone();
        }
        VectorSpecies species = (VectorSpecies)inds[0].species;
        for (i = 0; i < this.parents[0].genomeLength(); ++i) {
            if (!state.random[thread].nextBoolean(species.crossoverProbability)) continue;
            for (int j = this.parents.length - 1; j > 0; --j) {
                int swapIndex = state.random[thread].nextInt(j);
                byte temp = ((ByteVectorIndividual)this.parents[j]).genome[i];
                ((ByteVectorIndividual)this.parents[j]).genome[i] = ((ByteVectorIndividual)this.parents[swapIndex]).genome[i];
                ((ByteVectorIndividual)this.parents[swapIndex]).genome[i] = temp;
            }
        }
        i = 0;
        int q = start;
        while (i < this.parents.length) {
            this.parents[i].evaluated = false;
            if (q < inds.length) {
                inds[q] = (ByteVectorIndividual)this.parents[i];
            }
            ++i;
            ++q;
        }
        return n;
    }

    public int multipleDoubleVectorCrossover(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int i;
        int n;
        if (!(inds[0] instanceof DoubleVectorIndividual)) {
            state.output.fatal("Trying to produce double vector individuals when you can't!");
        }
        if (this.sources.length <= 2) {
            state.output.error("Only two parents specified!");
        }
        if ((n = this.typicalIndsProduced()) < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            this.sources[i2].produce(1, 1, i2, subpopulation, this.parents, state, thread);
            if (this.sources[i2] instanceof BreedingPipeline) continue;
            this.parents[i2] = (DoubleVectorIndividual)this.parents[i2].clone();
        }
        VectorSpecies species = (VectorSpecies)inds[0].species;
        for (i = 0; i < this.parents[0].genomeLength(); ++i) {
            if (!state.random[thread].nextBoolean(species.crossoverProbability)) continue;
            for (int j = this.parents.length - 1; j > 0; --j) {
                int swapIndex = state.random[thread].nextInt(j);
                double temp = ((DoubleVectorIndividual)this.parents[j]).genome[i];
                ((DoubleVectorIndividual)this.parents[j]).genome[i] = ((DoubleVectorIndividual)this.parents[swapIndex]).genome[i];
                ((DoubleVectorIndividual)this.parents[swapIndex]).genome[i] = temp;
            }
        }
        i = 0;
        int q = start;
        while (i < this.parents.length) {
            this.parents[i].evaluated = false;
            if (q < inds.length) {
                inds[q] = (DoubleVectorIndividual)this.parents[i];
            }
            ++i;
            ++q;
        }
        return n;
    }

    public int multipleFloatVectorCrossover(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int i;
        int n;
        if (!(inds[0] instanceof FloatVectorIndividual)) {
            state.output.fatal("Trying to produce float vector individuals when you can't!");
        }
        if (this.sources.length <= 2) {
            state.output.error("Only two parents specified!");
        }
        if ((n = this.typicalIndsProduced()) < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            this.sources[i2].produce(1, 1, i2, subpopulation, this.parents, state, thread);
            if (this.sources[i2] instanceof BreedingPipeline) continue;
            this.parents[i2] = (FloatVectorIndividual)this.parents[i2].clone();
        }
        VectorSpecies species = (VectorSpecies)inds[0].species;
        for (i = 0; i < this.parents[0].genomeLength(); ++i) {
            if (!state.random[thread].nextBoolean(species.crossoverProbability)) continue;
            for (int j = this.parents.length - 1; j > 0; --j) {
                int swapIndex = state.random[thread].nextInt(j);
                float temp = ((FloatVectorIndividual)this.parents[j]).genome[i];
                ((FloatVectorIndividual)this.parents[j]).genome[i] = ((FloatVectorIndividual)this.parents[swapIndex]).genome[i];
                ((FloatVectorIndividual)this.parents[swapIndex]).genome[i] = temp;
            }
        }
        i = 0;
        int q = start;
        while (i < this.parents.length) {
            this.parents[i].evaluated = false;
            if (q < inds.length) {
                inds[q] = (FloatVectorIndividual)this.parents[i];
            }
            ++i;
            ++q;
        }
        return n;
    }

    public int multipleGeneVectorCrossover(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int i;
        int n;
        if (!(inds[0] instanceof GeneVectorIndividual)) {
            state.output.fatal("Trying to produce gene vector individuals when you can't!");
        }
        if (this.sources.length <= 2) {
            state.output.error("Only two parents specified!");
        }
        if ((n = this.typicalIndsProduced()) < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            this.sources[i2].produce(1, 1, i2, subpopulation, this.parents, state, thread);
            if (this.sources[i2] instanceof BreedingPipeline) continue;
            this.parents[i2] = (GeneVectorIndividual)this.parents[i2].clone();
        }
        VectorSpecies species = (VectorSpecies)inds[0].species;
        for (i = 0; i < this.parents[0].genomeLength(); ++i) {
            if (!state.random[thread].nextBoolean(species.crossoverProbability)) continue;
            for (int j = this.parents.length - 1; j > 0; --j) {
                int swapIndex = state.random[thread].nextInt(j);
                Gene temp = ((GeneVectorIndividual)this.parents[j]).genome[i];
                ((GeneVectorIndividual)this.parents[j]).genome[i] = ((GeneVectorIndividual)this.parents[swapIndex]).genome[i];
                ((GeneVectorIndividual)this.parents[swapIndex]).genome[i] = temp;
            }
        }
        i = 0;
        int q = start;
        while (i < this.parents.length) {
            this.parents[i].evaluated = false;
            if (q < inds.length) {
                inds[q] = (GeneVectorIndividual)this.parents[i];
            }
            ++i;
            ++q;
        }
        return n;
    }

    public int multipleIntegerVectorCrossover(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int i;
        int n;
        if (!(inds[0] instanceof IntegerVectorIndividual)) {
            state.output.fatal("Trying to produce integer vector individuals when you can't!");
        }
        if (this.sources.length <= 2) {
            state.output.error("Only two parents specified!");
        }
        if ((n = this.typicalIndsProduced()) < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            this.sources[i2].produce(1, 1, i2, subpopulation, this.parents, state, thread);
            if (this.sources[i2] instanceof BreedingPipeline) continue;
            this.parents[i2] = (IntegerVectorIndividual)this.parents[i2].clone();
        }
        VectorSpecies species = (VectorSpecies)inds[0].species;
        for (i = 0; i < this.parents[0].genomeLength(); ++i) {
            if (!state.random[thread].nextBoolean(species.crossoverProbability)) continue;
            for (int j = this.parents.length - 1; j > 0; --j) {
                int swapIndex = state.random[thread].nextInt(j);
                int temp = ((IntegerVectorIndividual)this.parents[j]).genome[i];
                ((IntegerVectorIndividual)this.parents[j]).genome[i] = ((IntegerVectorIndividual)this.parents[swapIndex]).genome[i];
                ((IntegerVectorIndividual)this.parents[swapIndex]).genome[i] = temp;
            }
        }
        i = 0;
        int q = start;
        while (i < this.parents.length) {
            this.parents[i].evaluated = false;
            if (q < inds.length) {
                inds[q] = (IntegerVectorIndividual)this.parents[i];
            }
            ++i;
            ++q;
        }
        return n;
    }

    public int multipleLongVectorCrossover(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int i;
        int n;
        if (!(inds[0] instanceof LongVectorIndividual)) {
            state.output.fatal("Trying to produce long vector individuals when you can't!");
        }
        if (this.sources.length <= 2) {
            state.output.error("Only two parents specified!");
        }
        if ((n = this.typicalIndsProduced()) < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            this.sources[i2].produce(1, 1, i2, subpopulation, this.parents, state, thread);
            if (this.sources[i2] instanceof BreedingPipeline) continue;
            this.parents[i2] = (LongVectorIndividual)this.parents[i2].clone();
        }
        VectorSpecies species = (VectorSpecies)inds[0].species;
        for (i = 0; i < this.parents[0].genomeLength(); ++i) {
            if (!state.random[thread].nextBoolean(species.crossoverProbability)) continue;
            for (int j = this.parents.length - 1; j > 0; --j) {
                int swapIndex = state.random[thread].nextInt(j);
                long temp = ((LongVectorIndividual)this.parents[j]).genome[i];
                ((LongVectorIndividual)this.parents[j]).genome[i] = ((LongVectorIndividual)this.parents[swapIndex]).genome[i];
                ((LongVectorIndividual)this.parents[swapIndex]).genome[i] = temp;
            }
        }
        i = 0;
        int q = start;
        while (i < this.parents.length) {
            this.parents[i].evaluated = false;
            if (q < inds.length) {
                inds[q] = (LongVectorIndividual)this.parents[i];
            }
            ++i;
            ++q;
        }
        return n;
    }

    public int multipleShortVectorCrossover(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int i;
        int n;
        if (!(inds[0] instanceof ShortVectorIndividual)) {
            state.output.fatal("Trying to produce short vector individuals when you can't!");
        }
        if (this.sources.length <= 2) {
            state.output.error("Only two parents specified!");
        }
        if ((n = this.typicalIndsProduced()) < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            this.sources[i2].produce(1, 1, i2, subpopulation, this.parents, state, thread);
            if (this.sources[i2] instanceof BreedingPipeline) continue;
            this.parents[i2] = (ShortVectorIndividual)this.parents[i2].clone();
        }
        VectorSpecies species = (VectorSpecies)inds[0].species;
        for (i = 0; i < this.parents[0].genomeLength(); ++i) {
            if (!state.random[thread].nextBoolean(species.crossoverProbability)) continue;
            for (int j = this.parents.length - 1; j > 0; --j) {
                int swapIndex = state.random[thread].nextInt(j);
                short temp = ((ShortVectorIndividual)this.parents[j]).genome[i];
                ((ShortVectorIndividual)this.parents[j]).genome[i] = ((ShortVectorIndividual)this.parents[swapIndex]).genome[i];
                ((ShortVectorIndividual)this.parents[swapIndex]).genome[i] = temp;
            }
        }
        i = 0;
        int q = start;
        while (i < this.parents.length) {
            this.parents[i].evaluated = false;
            if (q < inds.length) {
                inds[q] = (ShortVectorIndividual)this.parents[i];
            }
            ++i;
            ++q;
        }
        return n;
    }
}

