/*
 * Decompiled with CFR 0.152.
 */
package ec.app.coevolve1;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Problem;
import ec.coevolve.GroupedProblemForm;
import ec.simple.SimpleFitness;
import ec.vector.BitVectorIndividual;
import java.util.ArrayList;

public class CompetitiveMaxOnes
extends Problem
implements GroupedProblemForm {
    public void preprocessPopulation(EvolutionState state, Population pop, boolean[] updateFitness, boolean countVictoriesOnly) {
        for (int i = 0; i < pop.subpops.size(); ++i) {
            if (!updateFitness[i]) continue;
            for (int j = 0; j < pop.subpops.get((int)i).individuals.size(); ++j) {
                ((SimpleFitness)pop.subpops.get((int)i).individuals.get((int)j).fitness).trials = new ArrayList();
            }
        }
    }

    public int postprocessPopulation(EvolutionState state, Population pop, boolean[] updateFitness, boolean countVictoriesOnly) {
        int total = 0;
        for (int i = 0; i < pop.subpops.size(); ++i) {
            if (!updateFitness[i]) continue;
            for (int j = 0; j < pop.subpops.get((int)i).individuals.size(); ++j) {
                SimpleFitness fit = (SimpleFitness)pop.subpops.get((int)i).individuals.get((int)j).fitness;
                int len = fit.trials.size();
                double sum = 0.0;
                for (int l = 0; l < len; ++l) {
                    sum += ((Double)fit.trials.get(l)).doubleValue();
                }
                fit.setFitness(state, sum /= (double)len, false);
                pop.subpops.get((int)i).individuals.get((int)j).evaluated = true;
                ++total;
            }
        }
        return total;
    }

    public void evaluate(EvolutionState state, Individual[] ind, boolean[] updateFitness, boolean countVictoriesOnly, int[] subpops, int threadnum) {
        SimpleFitness fit;
        int i;
        if (ind.length != 2 || updateFitness.length != 2) {
            state.output.fatal("The InternalSumProblem evaluates only two individuals at a time.");
        }
        if (!(ind[0] instanceof BitVectorIndividual)) {
            state.output.fatal("The individuals in the InternalSumProblem should be FloatVectorIndividuals.");
        }
        if (!(ind[1] instanceof BitVectorIndividual)) {
            state.output.fatal("The individuals in the InternalSumProblem should be FloatVectorIndividuals.");
        }
        int value1 = 0;
        int value2 = 0;
        BitVectorIndividual temp = (BitVectorIndividual)ind[0];
        for (i = 0; i < temp.genome.length; ++i) {
            if (!temp.genome[i]) continue;
            ++value1;
        }
        temp = (BitVectorIndividual)ind[1];
        for (i = 0; i < temp.genome.length; ++i) {
            if (!temp.genome[i]) continue;
            ++value2;
        }
        double score = value1 - value2;
        if (updateFitness[0]) {
            fit = (SimpleFitness)ind[0].fitness;
            fit.trials.add(new Double(score));
            fit.setFitness(state, score, false);
        }
        if (updateFitness[1]) {
            fit = (SimpleFitness)ind[1].fitness;
            fit.trials.add(new Double(-score));
            fit.setFitness(state, -score, false);
        }
    }
}

