/*
 * Decompiled with CFR 0.152.
 */
package ec.app.lawnmower.func;

import ec.EvolutionState;
import ec.Problem;
import ec.app.lawnmower.LawnmowerData;
import ec.gp.ADFStack;
import ec.gp.ERC;
import ec.gp.GPData;
import ec.gp.GPIndividual;
import ec.gp.GPNode;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LawnERC
extends ERC {
    public int maxx;
    public int maxy;
    public int x;
    public int y;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter newbase = new Parameter("eval").push("problem");
        this.maxx = state.parameters.getInt(newbase.push("x"), null, 1);
        if (this.maxx == 0) {
            state.output.error("The width (x dimension) of the lawn must be >0", newbase.push("x"));
        }
        this.maxy = state.parameters.getInt(newbase.push("y"), null, 1);
        if (this.maxy == 0) {
            state.output.error("The length (y dimension) of the lawn must be >0", newbase.push("x"));
        }
        state.output.exitIfErrors();
    }

    public void resetNode(EvolutionState state, int thread) {
        this.x = state.random[thread].nextInt(this.maxx);
        this.y = state.random[thread].nextInt(this.maxy);
    }

    public int nodeHashCode() {
        return this.getClass().hashCode() + this.x * this.maxy + this.y;
    }

    public boolean nodeEquals(GPNode node) {
        if (this.getClass() != node.getClass()) {
            return false;
        }
        LawnERC n = (LawnERC)node;
        return n.x == this.x && n.y == this.y;
    }

    public void readNode(EvolutionState state, DataInput dataInput) throws IOException {
        this.x = dataInput.readInt();
        this.y = dataInput.readInt();
    }

    public void writeNode(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.x);
        dataOutput.writeInt(this.y);
    }

    public String encode() {
        return Code.encode(this.x) + Code.encode(this.y);
    }

    public boolean decode(DecodeReturn dret) {
        int pos = dret.pos;
        String data = dret.data;
        Code.decode(dret);
        if (dret.type != 4) {
            dret.data = data;
            dret.pos = pos;
            return false;
        }
        this.x = (int)dret.l;
        Code.decode(dret);
        if (dret.type != 4) {
            dret.data = data;
            dret.pos = pos;
            return false;
        }
        this.y = (int)dret.l;
        return true;
    }

    public String toStringForHumans() {
        return "[" + this.x + "," + this.y + "]";
    }

    public void eval(EvolutionState state, int thread, GPData input, ADFStack stack, GPIndividual individual, Problem problem) {
        LawnmowerData rd = (LawnmowerData)input;
        rd.x = this.x;
        rd.y = this.y;
    }
}

