/*
 * Decompiled with CFR 0.152.
 */
package ec.app.tutorial2;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.util.Parameter;
import ec.vector.IntegerVectorIndividual;
import ec.vector.IntegerVectorSpecies;
import ec.vector.VectorDefaults;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OurMutatorPipeline
extends BreedingPipeline {
    public static final String P_OURMUTATION = "our-mutation";
    public static final int NUM_SOURCES = 1;

    @Override
    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_OURMUTATION);
    }

    @Override
    public int numSources() {
        return 1;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int start = inds.size();
        int n = this.sources[0].produce(min, max, subpopulation, inds, state, thread, misc);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return n;
        }
        if (!(inds.get(start) instanceof IntegerVectorIndividual)) {
            state.output.fatal("OurMutatorPipeline didn't get an IntegerVectorIndividual.The offending individual is in subpopulation " + subpopulation + " and it's:" + inds.get(start));
        }
        IntegerVectorSpecies species = (IntegerVectorSpecies)inds.get((int)start).species;
        for (int q = start; q < n + start; ++q) {
            IntegerVectorIndividual i = (IntegerVectorIndividual)inds.get(q);
            for (int x = 0; x < i.genome.length; ++x) {
                if (!state.random[thread].nextBoolean(species.mutationProbability(x))) continue;
                i.genome[x] = -i.genome[x];
            }
            i.evaluated = false;
        }
        return n;
    }
}

