/*
 * Decompiled with CFR 0.152.
 */
package ec.app.tutorial3;

import ec.EvolutionState;
import ec.Statistics;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;
import java.io.File;
import java.io.IOException;

public class MyStatistics
extends Statistics {
    public static final String P_POPFILE = "pop-file";
    public int popLog;
    public static final String P_INFOFILE = "info-file";
    public int infoLog;

    public void setup(EvolutionState state, Parameter base) {
        File infoFile;
        super.setup(state, base);
        File popFile = state.parameters.getFile(base.push(P_POPFILE), null);
        if (popFile != null) {
            try {
                this.popLog = state.output.addLog(popFile, true);
            }
            catch (IOException i) {
                state.output.fatal("An IOException occurred while trying to create the log " + popFile + ":\n" + i);
            }
        }
        if ((infoFile = state.parameters.getFile(base.push(P_INFOFILE), null)) != null) {
            try {
                this.infoLog = state.output.addLog(infoFile, true);
            }
            catch (IOException i) {
                state.output.fatal("An IOException occurred while trying to create the log " + infoFile + ":\n" + i);
            }
        }
    }

    public void postEvaluationStatistics(EvolutionState state) {
        super.postEvaluationStatistics(state);
        state.output.println("-----------------------\nGENERATION " + state.generation + "\n-----------------------", this.popLog);
        state.population.printPopulation(state, this.popLog);
        int best = 0;
        double best_val = ((DoubleVectorIndividual)state.population.subpops.get((int)0).individuals.get((int)0)).genome[3];
        for (int y = 1; y < state.population.subpops.get((int)0).individuals.size(); ++y) {
            double val = ((DoubleVectorIndividual)state.population.subpops.get((int)0).individuals.get((int)y)).genome[3];
            if (!(val > best_val)) continue;
            best = y;
            best_val = val;
        }
        state.population.subpops.get((int)0).individuals.get(best).printIndividualForHumans(state, this.infoLog);
    }
}

