/*
 * Decompiled with CFR 0.152.
 */
package ec.app.tutorial3;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.util.Parameter;
import java.util.ArrayList;

public class OurSelection
extends SelectionMethod {
    public static final String P_OURSELECTION = "our-selection";
    public static final String P_MIDDLEPROBABILITY = "middle-probability";
    public double middleProbability;

    public Parameter defaultBase() {
        return new Parameter(P_OURSELECTION);
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.middleProbability = state.parameters.getDoubleWithMax(base.push(P_MIDDLEPROBABILITY), def.push(P_MIDDLEPROBABILITY), 0.0, 1.0);
        if (this.middleProbability < 0.0) {
            state.output.fatal("Middle-Probability must be between 0.0 and 1.0", base.push(P_MIDDLEPROBABILITY), def.push(P_MIDDLEPROBABILITY));
        }
    }

    public int produce(int subpopulation, EvolutionState state, int thread) {
        if (state.random[thread].nextBoolean(this.middleProbability)) {
            ArrayList<Individual> inds = state.population.subpops.get((int)subpopulation).individuals;
            int one = state.random[thread].nextInt(inds.size());
            int two = state.random[thread].nextInt(inds.size());
            int three = state.random[thread].nextInt(inds.size());
            if (inds.get((int)two).fitness.betterThan(inds.get((int)one).fitness)) {
                if (inds.get((int)three).fitness.betterThan(inds.get((int)two).fitness)) {
                    return two;
                }
                if (inds.get((int)three).fitness.betterThan(inds.get((int)one).fitness)) {
                    return three;
                }
                return one;
            }
            if (inds.get((int)three).fitness.betterThan(inds.get((int)one).fitness)) {
                return one;
            }
            if (inds.get((int)three).fitness.betterThan(inds.get((int)two).fitness)) {
                return three;
            }
            return two;
        }
        return state.random[thread].nextInt(state.population.subpops.get((int)subpopulation).individuals.size());
    }
}

