/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.breed.BreedDefaults;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForceBreedingPipeline
extends BreedingPipeline {
    public static final String P_NUMINDS = "num-inds";
    public static final String P_FORCE = "force";
    public int numInds;

    @Override
    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_FORCE);
    }

    @Override
    public int numSources() {
        return 1;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.numInds = state.parameters.getInt(base.push(P_NUMINDS), def.push(P_NUMINDS), 1);
        if (this.numInds == 0) {
            state.output.fatal("ForceBreedingPipeline must produce at least 1 child at a time", base.push(P_NUMINDS), def.push(P_NUMINDS));
        }
        if (this.likelihood < 1.0) {
            state.output.warning("ForceBreedingPipeline does not respond to the 'likelihood' parameter.", base.push("likelihood"), def.push("likelihood"));
        }
    }

    @Override
    public int typicalIndsProduced() {
        return this.numInds;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int total;
        int numToProduce;
        int start = inds.size();
        int n = this.numInds;
        if (n < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        for (total = 0; total < n; total += this.sources[0].produce(numToProduce, numToProduce, subpopulation, inds, state, thread, misc)) {
            numToProduce = n - total;
            if (numToProduce <= this.numInds) continue;
            numToProduce = this.numInds;
        }
        return total;
    }
}

