/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.BreedingSource;
import ec.EvolutionState;
import ec.Individual;
import ec.breed.BreedDefaults;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBreedingPipeline
extends BreedingPipeline {
    public static final String P_GEN_MAX = "generate-max";
    public static final String P_MULTIBREED = "multibreed";
    public int maxGeneratable;
    public boolean generateMax;

    @Override
    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_MULTIBREED);
    }

    @Override
    public int numSources() {
        return -1;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        double total = 0.0;
        if (this.sources.length == 0) {
            state.output.fatal("num-sources must be provided and > 0 for MultiBreedingPipeline", base.push("num-sources"), def.push("num-sources"));
        }
        for (int x = 0; x < this.sources.length; ++x) {
            if (this.sources[x].probability < 0.0) {
                state.output.error("Pipe #" + x + " must have a probability >= 0.0", base);
                continue;
            }
            total += this.sources[x].probability;
        }
        state.output.exitIfErrors();
        if (total == 0.0) {
            state.output.warning("MultiBreedingPipeline's children have all zero probabilities -- this will be treated as a uniform distribution.  This could be an error.", base);
        }
        BreedingSource.setupProbabilities(this.sources);
        this.generateMax = state.parameters.getBoolean(base.push(P_GEN_MAX), def.push(P_GEN_MAX), true);
        this.maxGeneratable = 0;
        if (this.likelihood < 1.0) {
            state.output.warning("MultiBreedingPipeline does not respond to the 'likelihood' parameter.", base.push("likelihood"), def.push("likelihood"));
        }
    }

    @Override
    public int typicalIndsProduced() {
        if (this.maxGeneratable == 0) {
            this.maxGeneratable = this.maxChildProduction();
        }
        return this.maxGeneratable;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int total;
        int start = inds.size();
        BreedingSource s = this.sources[BreedingSource.pickRandom(this.sources, state.random[thread].nextDouble())];
        if (this.generateMax) {
            int n;
            if (this.maxGeneratable == 0) {
                this.maxGeneratable = this.maxChildProduction();
            }
            if ((n = this.maxGeneratable) < min) {
                n = min;
            }
            if (n > max) {
                n = max;
            }
            total = s.produce(n, n, subpopulation, inds, state, thread, misc);
        } else {
            total = s.produce(min, max, subpopulation, inds, state, thread, misc);
        }
        return total;
    }
}

