/*
 * Decompiled with CFR 0.152.
 */
package ec.de;

import ec.EvolutionState;
import ec.Individual;
import ec.de.DEBreeder;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;

public class Best1BinDEBreeder
extends DEBreeder {
    public double F_NOISE = 0.0;
    public static final String P_FNOISE = "f-noise";

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.F_NOISE = state.parameters.getDouble(base.push(P_FNOISE), null, 0.0);
        if (this.F_NOISE < 0.0) {
            state.output.fatal("Parameter not found, or its value is below 0.0.", base.push(P_FNOISE), null);
        }
    }

    public DoubleVectorIndividual createIndividual(EvolutionState state, int subpop, int index, int thread) {
        Individual[] inds = new Individual[state.population.subpops.get((int)subpop).individuals.size()];
        state.population.subpops.get((int)subpop).individuals.toArray(inds);
        DoubleVectorIndividual v = (DoubleVectorIndividual)state.population.subpops.get((int)subpop).species.newIndividual(state, thread);
        int retry = -1;
        do {
            int r2;
            int r1;
            ++retry;
            int r0 = this.bestSoFarIndex[subpop];
            while ((r1 = state.random[thread].nextInt(inds.length)) == r0 || r1 == index) {
            }
            while ((r2 = state.random[thread].nextInt(inds.length)) == r1 || r2 == r0 || r2 == index) {
            }
            DoubleVectorIndividual g0 = (DoubleVectorIndividual)inds[r0];
            DoubleVectorIndividual g1 = (DoubleVectorIndividual)inds[r1];
            DoubleVectorIndividual g2 = (DoubleVectorIndividual)inds[r2];
            for (int i = 0; i < v.genome.length; ++i) {
                v.genome[i] = g0.genome[i] + (this.F + state.random[thread].nextDouble() * this.F_NOISE - this.F_NOISE / 2.0) * (g1.genome[i] - g2.genome[i]);
            }
        } while (!this.valid(v) && retry < this.retries);
        if (retry >= this.retries && !this.valid(v)) {
            v.reset(state, thread);
        }
        return this.crossover(state, (DoubleVectorIndividual)inds[index], v, thread);
    }
}

