/*
 * Decompiled with CFR 0.152.
 */
package ec.eda.cmaes;

import ec.Breeder;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Subpopulation;
import ec.eda.cmaes.CMAESSpecies;
import ec.util.Parameter;
import java.util.ArrayList;

public class CMAESBreeder
extends Breeder {
    public void setup(EvolutionState state, Parameter base) {
    }

    public Population breedPopulation(EvolutionState state) {
        Population pop = state.population;
        for (int i = 0; i < pop.subpops.size(); ++i) {
            Subpopulation subpop = pop.subpops.get(i);
            if (!(subpop.species instanceof CMAESSpecies)) {
                state.output.fatal("To use CMAESBreeder, subpopulation " + i + " must contain a CMAESSpecies.  But it contains a " + subpop.species);
            }
            CMAESSpecies species = (CMAESSpecies)subpop.species;
            species.updateDistribution(state, subpop);
            ArrayList<Individual> inds = subpop.individuals;
            for (int j = 0; j < inds.size(); ++j) {
                inds.set(j, species.newIndividual(state, 0));
            }
        }
        return pop;
    }
}

