/*
 * Decompiled with CFR 0.152.
 */
package ec.eda.cmaes;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.eda.cmaes.CMAESSpecies;
import ec.simple.SimpleInitializer;
import java.util.ArrayList;

public class CMAESInitializer
extends SimpleInitializer {
    private static final long serialVersionUID = 1L;

    public Population setupPopulation(EvolutionState state, int thread) {
        Population p = super.setupPopulation(state, thread);
        for (int i = 0; i < p.subpops.size(); ++i) {
            Individual[] oldInds = p.subpops.get((int)i).individuals.toArray(new Individual[0]);
            if (p.subpops.get((int)i).species instanceof CMAESSpecies) {
                Individual[] newInds;
                int lambda = ((CMAESSpecies)p.subpops.get((int)i).species).lambda;
                if (lambda < oldInds.length) {
                    newInds = new Individual[lambda];
                    System.arraycopy(oldInds, 0, newInds, 0, lambda);
                    oldInds = newInds;
                } else if (lambda > oldInds.length) {
                    newInds = new Individual[lambda];
                    System.arraycopy(oldInds, 0, newInds, 0, oldInds.length);
                    for (int j = oldInds.length; j < lambda; ++j) {
                        newInds[j] = p.subpops.get((int)i).species.newIndividual(state, thread);
                    }
                    oldInds = newInds;
                }
            } else {
                state.output.fatal("Species of subpopulation " + i + " is not a CMAESSpecies.  It's a " + p.subpops.get((int)i).species);
            }
            p.subpops.get((int)i).individuals = new ArrayList();
            for (int j = 0; j < oldInds.length; ++j) {
                p.subpops.get((int)i).individuals.add(oldInds[j]);
            }
        }
        return p;
    }
}

