/*
 * Decompiled with CFR 0.152.
 */
package ec.eda.dovs;

import ec.Breeder;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Subpopulation;
import ec.eda.dovs.DOVSSpecies;
import ec.util.Parameter;
import java.util.ArrayList;

public class DOVSBreeder
extends Breeder {
    public void setup(EvolutionState state, Parameter base) {
    }

    public Population breedPopulation(EvolutionState state) {
        Population pop = state.population;
        for (int i = 0; i < pop.subpops.size(); ++i) {
            Subpopulation subpop = pop.subpops.get(i);
            if (!(subpop.species instanceof DOVSSpecies)) {
                state.output.fatal("To use DOVSBreeder, subpopulation " + i + " must contain a DOVSSpecies.  But it contains a " + subpop.species);
            }
            DOVSSpecies species = (DOVSSpecies)subpop.species;
            species.findBestSample(state, subpop);
            for (int j = 0; j < subpop.individuals.size(); ++j) {
                species.activeSolutions.add(subpop.individuals.get(i));
            }
            species.updateMostPromisingArea(state);
            ArrayList<Individual> candidates = species.mostPromisingAreaSamples(state, subpop.initialSize);
            ArrayList<Individual> Sk = species.uniqueSamples(state, candidates);
            subpop.individuals = Sk;
        }
        return pop;
    }
}

