/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.breed;

import ec.EvolutionState;
import ec.Individual;
import ec.gp.GPBreedingPipeline;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.breed.GPBreedDefaults;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutateSwapPipeline
extends GPBreedingPipeline {
    public static final String P_MUTATESWAP = "mutate-swap";
    public static final String P_NUM_TRIES = "tries";
    public static final int NUM_SOURCES = 1;
    int numTries;
    int tree;
    private GPNode swappableNode;

    @Override
    public Parameter defaultBase() {
        return GPBreedDefaults.base().push(P_MUTATESWAP);
    }

    @Override
    public int numSources() {
        return 1;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.numTries = state.parameters.getInt(base.push(P_NUM_TRIES), def.push(P_NUM_TRIES), 1);
        if (this.numTries == 0) {
            state.output.fatal("MutateSwapPipeline has an invalid number of tries (it must be >= 1).", base.push(P_NUM_TRIES), def.push(P_NUM_TRIES));
        }
        this.tree = -1;
        if (state.parameters.exists(base.push("tree").push("0"), def.push("tree").push("0"))) {
            this.tree = state.parameters.getInt(base.push("tree").push("0"), def.push("tree").push("0"), 0);
            if (this.tree == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
    }

    private boolean swappable(GPInitializer initializer, GPNode node) {
        if (node.children.length < 2) {
            return false;
        }
        if (initializer.numAtomicTypes + initializer.numSetTypes == 1) {
            return true;
        }
        for (int x = 0; x < node.constraints((GPInitializer)initializer).childtypes.length - 1; ++x) {
            for (int y = x + 1; y < node.constraints((GPInitializer)initializer).childtypes.length; ++y) {
                if (!node.children[x].constraints((GPInitializer)initializer).returntype.compatibleWith(initializer, node.constraints((GPInitializer)initializer).childtypes[y]) || !node.children[y].constraints((GPInitializer)initializer).returntype.compatibleWith(initializer, node.constraints((GPInitializer)initializer).childtypes[x])) continue;
                return true;
            }
        }
        return false;
    }

    private void swapSomething(GPNode node, EvolutionState state, int thread) {
        if (((GPInitializer)state.initializer).numAtomicTypes + ((GPInitializer)state.initializer).numSetTypes == 1) {
            this._swapSomethingTypeless(node, state, thread);
        } else {
            this._swapSomething(node, state, thread);
        }
    }

    private void _swapSomethingTypeless(GPNode node, EvolutionState state, int thread) {
        int x = state.random[thread].nextInt(node.children.length);
        int y = state.random[thread].nextInt(node.children.length - 1);
        if (y >= x) {
            ++y;
        }
        GPNode tmp = node.children[x];
        node.children[x] = node.children[y];
        node.children[y] = tmp;
        node.children[x].argposition = (byte)x;
        node.children[y].argposition = (byte)y;
    }

    private void _swapSomething(GPNode node, EvolutionState state, int thread) {
        int numSwappable = 0;
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (int x = 0; x < node.constraints((GPInitializer)initializer).childtypes.length - 1; ++x) {
            for (int y = x + 1; y < node.constraints((GPInitializer)initializer).childtypes.length; ++y) {
                if (!node.children[x].constraints((GPInitializer)initializer).returntype.compatibleWith(initializer, node.constraints((GPInitializer)initializer).childtypes[y]) || !node.children[y].constraints((GPInitializer)initializer).returntype.compatibleWith(initializer, node.constraints((GPInitializer)initializer).childtypes[x])) continue;
                ++numSwappable;
            }
        }
        int swapItem = state.random[thread].nextInt(numSwappable);
        numSwappable = 0;
        for (int x = 0; x < node.constraints((GPInitializer)initializer).childtypes.length - 1; ++x) {
            for (int y = x + 1; y < node.constraints((GPInitializer)initializer).childtypes.length; ++y) {
                if (!node.children[x].constraints((GPInitializer)initializer).returntype.compatibleWith(initializer, node.constraints((GPInitializer)initializer).childtypes[y]) || !node.children[y].constraints((GPInitializer)initializer).returntype.compatibleWith(initializer, node.constraints((GPInitializer)initializer).childtypes[x])) continue;
                if (numSwappable == swapItem) {
                    GPNode tmp = node.children[x];
                    node.children[x] = node.children[y];
                    node.children[y] = tmp;
                    node.children[x].argposition = (byte)x;
                    node.children[y].argposition = (byte)y;
                    return;
                }
                ++numSwappable;
            }
        }
    }

    private int numSwappableNodes(GPInitializer initializer, GPNode root, int soFar) {
        if (this.swappable(initializer, root)) {
            ++soFar;
        }
        for (int x = 0; x < root.children.length; ++x) {
            soFar = this.numSwappableNodes(initializer, root.children[x], soFar);
        }
        return soFar;
    }

    private int pickSwappableNode(GPInitializer initializer, GPNode root, int num) {
        if (this.swappable(initializer, root) && --num == -1) {
            this.swappableNode = root;
            return num;
        }
        for (int x = 0; x < root.children.length && (num = this.pickSwappableNode(initializer, root.children[x], num)) != -1; ++x) {
        }
        return num;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int start = inds.size();
        int n = this.sources[0].produce(min, max, subpopulation, inds, state, thread, misc);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return n;
        }
        for (int q = start; q < n + start; ++q) {
            GPIndividual i = (GPIndividual)inds.get(q);
            if (this.tree != -1 && (this.tree < 0 || this.tree >= i.trees.length)) {
                state.output.fatal("MutateSwapPipeline attempted to fix tree.0 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            for (int x = 0; x < this.numTries; ++x) {
                int t = this.tree == -1 ? (i.trees.length > 1 ? state.random[thread].nextInt(i.trees.length) : 0) : this.tree;
                GPInitializer initializer = (GPInitializer)state.initializer;
                int numswap = this.numSwappableNodes(initializer, i.trees[t].child, 0);
                if (numswap == 0) continue;
                this.pickSwappableNode(initializer, i.trees[t].child, state.random[thread].nextInt(numswap));
                this.swapSomething(this.swappableNode, state, thread);
                i.evaluated = false;
                break;
            }
            inds.set(q, i);
        }
        return n;
    }
}

