/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.ge;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Problem;
import ec.coevolve.GroupedProblemForm;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.ge.GEIndividual;
import ec.gp.ge.GESpecies;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;

public class GEProblem
extends Problem
implements SimpleProblemForm,
GroupedProblemForm {
    private static final long serialVersionUID = 1L;
    public static final String P_PROBLEM = "problem";
    public GPProblem problem;

    public void setup(EvolutionState state, Parameter base) {
        this.problem = (GPProblem)state.parameters.getInstanceForParameter(base.push(P_PROBLEM), null, GPProblem.class);
        this.problem.setup(state, base.push(P_PROBLEM));
    }

    public Object clone() {
        GEProblem other = (GEProblem)super.clone();
        other.problem = (GPProblem)this.problem.clone();
        return other;
    }

    public void prepareToEvaluate(EvolutionState state, int threadnum) {
        this.problem.prepareToEvaluate(state, threadnum);
    }

    public void finishEvaluating(EvolutionState state, int threadnum) {
        this.problem.finishEvaluating(state, threadnum);
    }

    public void initializeContacts(EvolutionState state) {
        this.problem.initializeContacts(state);
    }

    public void reinitializeContacts(EvolutionState state) {
        this.problem.reinitializeContacts(state);
    }

    public void closeContacts(EvolutionState state, int result) {
        this.problem.closeContacts(state, result);
    }

    public boolean canEvaluate() {
        return this.problem.canEvaluate();
    }

    public void preprocessPopulation(EvolutionState state, Population pop, boolean[] prepareForFitnessAssessment, boolean countVictoriesOnly) {
        if (!(this.problem instanceof GroupedProblemForm)) {
            state.output.fatal("GEProblem's underlying Problem is not a GroupedProblemForm");
        }
        ((GroupedProblemForm)((Object)this.problem)).preprocessPopulation(state, pop, prepareForFitnessAssessment, countVictoriesOnly);
    }

    public int postprocessPopulation(EvolutionState state, Population pop, boolean[] assessFitness, boolean countVictoriesOnly) {
        return ((GroupedProblemForm)((Object)this.problem)).postprocessPopulation(state, pop, assessFitness, countVictoriesOnly);
    }

    public void evaluate(EvolutionState state, Individual[] ind, boolean[] updateFitness, boolean countVictoriesOnly, int[] subpops, int threadnum) {
        int i;
        Individual[] gpi = new Individual[ind.length];
        for (i = 0; i < gpi.length; ++i) {
            if (ind[i] instanceof GEIndividual) {
                GEIndividual indiv = (GEIndividual)ind[i];
                GESpecies species = (GESpecies)ind[i].species;
                gpi[i] = species.map(state, indiv, threadnum, null);
                continue;
            }
            if (ind[i] instanceof GPIndividual) {
                state.output.warnOnce("GPIndividual provided to GEProblem.  Hope that's correct.");
                gpi[i] = ind[i];
                continue;
            }
            state.output.fatal("Individual " + i + " passed to Grouped evaluate(...) was neither a GP nor GE Individual: " + ind[i]);
        }
        ((GroupedProblemForm)((Object)this.problem)).evaluate(state, gpi, updateFitness, countVictoriesOnly, subpops, threadnum);
        for (i = 0; i < gpi.length; ++i) {
            ind[i].fitness = gpi[i].fitness;
            ind[i].evaluated = gpi[i].evaluated;
        }
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!(this.problem instanceof SimpleProblemForm)) {
            state.output.fatal("GEProblem's underlying Problem is not a SimpleProblemForm");
        }
        if (ind instanceof GEIndividual) {
            GESpecies species = (GESpecies)ind.species;
            GEIndividual indiv = (GEIndividual)ind;
            GPIndividual gpi = species.map(state, indiv, threadnum, null);
            if (gpi == null) {
                KozaFitness fitness = (KozaFitness)ind.fitness;
                fitness.setStandardizedFitness(state, Double.MAX_VALUE);
                ind.fitness = fitness;
                ind.evaluated = true;
            } else {
                this.problem.evaluate(state, gpi, subpopulation, threadnum);
                ind.fitness = gpi.fitness;
                ind.evaluated = gpi.evaluated;
            }
        } else if (ind instanceof GPIndividual) {
            state.output.warnOnce("GPIndividual provided to GEProblem.  Hope that's correct.");
            this.problem.evaluate(state, ind, subpopulation, threadnum);
        } else {
            state.output.fatal("Individual passed to evaluate(...) was neither a GP nor GE Individual: " + ind);
        }
    }

    public void describe(EvolutionState state, Individual ind, int subpopulation, int threadnum, int log) {
        if (ind instanceof GEIndividual) {
            GESpecies species = (GESpecies)ind.species;
            GEIndividual indiv = (GEIndividual)ind;
            GPIndividual gpi = species.map(state, indiv, threadnum, null);
            if (gpi != null) {
                this.problem.describe(state, gpi, subpopulation, threadnum, log);
                ind.fitness = gpi.fitness;
                ind.evaluated = gpi.evaluated;
            }
        } else if (ind instanceof GPIndividual) {
            state.output.warnOnce("GPIndividual provided to GEProblem.  Hope that's correct.");
            this.problem.describe(state, ind, subpopulation, threadnum, log);
        } else {
            state.output.fatal("Individual passed to describe(...) was neither a GP nor GE Individual: " + ind);
        }
    }
}

