/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.koza;

import ec.EvolutionState;
import ec.gp.GPIndividual;
import ec.gp.GPSpecies;
import ec.simple.SimpleShortStatistics;
import ec.util.Parameter;

public class KozaShortStatistics
extends SimpleShortStatistics {
    public static final String P_DO_DEPTH = "do-depth";
    public boolean doDepth;
    long[][] totalDepthSoFarTree;
    long[][] totalSizeSoFarTree;
    long[][] totalSizeThisGenTree;
    long[][] totalDepthThisGenTree;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.doDepth = state.parameters.getBoolean(base.push(P_DO_DEPTH), null, false);
    }

    public void postInitializationStatistics(EvolutionState state) {
        super.postInitializationStatistics(state);
        this.totalDepthSoFarTree = new long[state.population.subpops.size()][];
        this.totalSizeSoFarTree = new long[state.population.subpops.size()][];
        for (int x = 0; x < state.population.subpops.size(); ++x) {
            if (!(state.population.subpops.get((int)x).species instanceof GPSpecies)) {
                state.output.fatal("Subpopulation " + x + " is not of the species form GPSpecies." + "  Cannot do timing statistics with KozaShortStatistics.");
            }
            GPIndividual i = (GPIndividual)state.population.subpops.get((int)x).individuals.get(0);
            this.totalDepthSoFarTree[x] = new long[i.trees.length];
            this.totalSizeSoFarTree[x] = new long[i.trees.length];
        }
    }

    protected void prepareStatistics(EvolutionState state) {
        this.totalDepthThisGenTree = new long[state.population.subpops.size()][];
        this.totalSizeThisGenTree = new long[state.population.subpops.size()][];
        for (int x = 0; x < state.population.subpops.size(); ++x) {
            GPIndividual i = (GPIndividual)state.population.subpops.get((int)x).individuals.get(0);
            this.totalDepthThisGenTree[x] = new long[i.trees.length];
            this.totalSizeThisGenTree[x] = new long[i.trees.length];
        }
    }

    protected void gatherExtraSubpopStatistics(EvolutionState state, int subpop, int individual) {
        GPIndividual i = (GPIndividual)state.population.subpops.get((int)subpop).individuals.get(individual);
        for (int z = 0; z < i.trees.length; ++z) {
            long[] lArray = this.totalDepthThisGenTree[subpop];
            int n = z;
            lArray[n] = lArray[n] + (long)i.trees[z].child.depth();
            long[] lArray2 = this.totalDepthSoFarTree[subpop];
            int n2 = z;
            lArray2[n2] = lArray2[n2] + this.totalDepthThisGenTree[subpop][z];
            long[] lArray3 = this.totalSizeThisGenTree[subpop];
            int n3 = z;
            lArray3[n3] = lArray3[n3] + (long)i.trees[z].child.numNodes(0);
            long[] lArray4 = this.totalSizeSoFarTree[subpop];
            int n4 = z;
            lArray4[n4] = lArray4[n4] + this.totalSizeThisGenTree[subpop][z];
        }
    }

    protected void printExtraSubpopStatisticsBefore(EvolutionState state, int subpop) {
        int z;
        if (this.doDepth) {
            state.output.print("[ ", this.statisticslog);
            for (z = 0; z < this.totalDepthThisGenTree[subpop].length; ++z) {
                state.output.print("" + (this.totalIndsThisGen[subpop] > 0L ? (double)this.totalDepthThisGenTree[subpop][z] / (double)this.totalIndsThisGen[subpop] : 0.0) + " ", this.statisticslog);
            }
            state.output.print("] ", this.statisticslog);
        }
        if (this.doSize) {
            state.output.print("[ ", this.statisticslog);
            for (z = 0; z < this.totalSizeThisGenTree[subpop].length; ++z) {
                state.output.print("" + (this.totalIndsThisGen[subpop] > 0L ? (double)this.totalSizeThisGenTree[subpop][z] / (double)this.totalIndsThisGen[subpop] : 0.0) + " ", this.statisticslog);
            }
            state.output.print("] ", this.statisticslog);
        }
    }

    protected void printExtraPopStatisticsBefore(EvolutionState state) {
        int z;
        long[] totalDepthThisGenTreePop = new long[this.totalDepthSoFarTree[0].length];
        long[] totalSizeThisGenTreePop = new long[this.totalSizeSoFarTree[0].length];
        long totalIndsThisGenPop = 0L;
        long totalDepthThisGenPop = 0L;
        long totalDepthSoFarPop = 0L;
        int subpops = state.population.subpops.size();
        for (int y = 0; y < subpops; ++y) {
            int z2;
            totalIndsThisGenPop += this.totalIndsThisGen[y];
            for (z2 = 0; z2 < totalSizeThisGenTreePop.length; ++z2) {
                int n = z2;
                totalSizeThisGenTreePop[n] = totalSizeThisGenTreePop[n] + this.totalSizeThisGenTree[y][z2];
            }
            for (z2 = 0; z2 < totalDepthThisGenTreePop.length; ++z2) {
                int n = z2;
                totalDepthThisGenTreePop[n] = totalDepthThisGenTreePop[n] + this.totalDepthThisGenTree[y][z2];
            }
        }
        if (this.doDepth) {
            state.output.print("[ ", this.statisticslog);
            for (z = 0; z < totalDepthThisGenTreePop.length; ++z) {
                state.output.print("" + (totalIndsThisGenPop > 0L ? (double)totalDepthThisGenTreePop[z] / (double)totalIndsThisGenPop : 0.0) + " ", this.statisticslog);
            }
            state.output.print("] ", this.statisticslog);
        }
        if (this.doSize) {
            state.output.print("[ ", this.statisticslog);
            for (z = 0; z < totalSizeThisGenTreePop.length; ++z) {
                state.output.print("" + (totalIndsThisGenPop > 0L ? (double)totalSizeThisGenTreePop[z] / (double)totalIndsThisGenPop : 0.0) + " ", this.statisticslog);
            }
            state.output.print("] ", this.statisticslog);
        }
    }
}

