/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.koza;

import ec.EvolutionState;
import ec.Individual;
import ec.gp.GPBreedingPipeline;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeBuilder;
import ec.gp.GPNodeSelector;
import ec.gp.GPTree;
import ec.gp.koza.GPKozaDefaults;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutationPipeline
extends GPBreedingPipeline {
    private static final long serialVersionUID = 1L;
    public static final String P_NUM_TRIES = "tries";
    public static final String P_MAXDEPTH = "maxdepth";
    public static final String P_MAXSIZE = "maxsize";
    public static final String P_MUTATION = "mutate";
    public static final String P_BUILDER = "build";
    public static final String P_EQUALSIZE = "equal";
    public static final int INDS_PRODUCED = 1;
    public static final int NUM_SOURCES = 1;
    public static final int NO_SIZE_LIMIT = -1;
    public GPNodeSelector nodeselect;
    public GPNodeBuilder builder;
    int numTries;
    int maxDepth;
    public int maxSize;
    boolean equalSize;
    int tree;

    @Override
    public Parameter defaultBase() {
        return GPKozaDefaults.base().push(P_MUTATION);
    }

    @Override
    public int numSources() {
        return 1;
    }

    @Override
    public Object clone() {
        MutationPipeline c = (MutationPipeline)super.clone();
        c.nodeselect = (GPNodeSelector)this.nodeselect.clone();
        return c;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        Parameter p = base.push("ns").push("0");
        Parameter d = def.push("ns").push("0");
        this.nodeselect = (GPNodeSelector)state.parameters.getInstanceForParameter(p, d, GPNodeSelector.class);
        this.nodeselect.setup(state, p);
        p = base.push(P_BUILDER).push("0");
        d = def.push(P_BUILDER).push("0");
        this.builder = (GPNodeBuilder)state.parameters.getInstanceForParameter(p, d, GPNodeBuilder.class);
        this.builder.setup(state, p);
        this.numTries = state.parameters.getInt(base.push(P_NUM_TRIES), def.push(P_NUM_TRIES), 1);
        if (this.numTries == 0) {
            state.output.fatal("Mutation Pipeline has an invalid number of tries (it must be >= 1).", base.push(P_NUM_TRIES), def.push(P_NUM_TRIES));
        }
        this.maxDepth = state.parameters.getInt(base.push(P_MAXDEPTH), def.push(P_MAXDEPTH), 1);
        if (this.maxDepth == 0) {
            state.output.fatal("The Mutation Pipeline " + base + "has an invalid maximum depth (it must be >= 1).", base.push(P_MAXDEPTH), def.push(P_MAXDEPTH));
        }
        this.maxSize = -1;
        if (state.parameters.exists(base.push(P_MAXSIZE), def.push(P_MAXSIZE))) {
            this.maxSize = state.parameters.getInt(base.push(P_MAXSIZE), def.push(P_MAXSIZE), 1);
            if (this.maxSize < 1) {
                state.output.fatal("Maximum tree size, if defined, must be >= 1");
            }
        }
        this.equalSize = state.parameters.getBoolean(base.push(P_EQUALSIZE), def.push(P_EQUALSIZE), false);
        this.tree = -1;
        if (state.parameters.exists(base.push("tree").push("0"), def.push("tree").push("0"))) {
            this.tree = state.parameters.getInt(base.push("tree").push("0"), def.push("tree").push("0"), 0);
            if (this.tree == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
    }

    public boolean verifyPoints(GPNode inner1, GPNode inner2) {
        GPNode root2;
        int root2size;
        int inner2size;
        int inner1size;
        if (inner1.depth() + inner2.atDepth() > this.maxDepth) {
            return false;
        }
        return this.maxSize == -1 || (inner1size = inner1.numNodes(0)) <= (inner2size = inner2.numNodes(0)) || (root2size = (root2 = ((GPTree)inner2.rootParent()).child).numNodes(0)) - inner2size + inner1size <= this.maxSize;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int start = inds.size();
        int n = this.sources[0].produce(min, max, subpopulation, inds, state, thread, misc);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return n;
        }
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (int q = start; q < n + start; ++q) {
            GPIndividual i = (GPIndividual)inds.get(q);
            if (this.tree != -1 && (this.tree < 0 || this.tree >= i.trees.length)) {
                state.output.fatal("GP Mutation Pipeline attempted to fix tree.0 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            int t = this.tree == -1 ? (i.trees.length > 1 ? state.random[thread].nextInt(i.trees.length) : 0) : this.tree;
            boolean res = false;
            this.nodeselect.reset();
            GPNode p1 = null;
            GPNode p2 = null;
            for (int x = 0; x < this.numTries; ++x) {
                p1 = this.nodeselect.pickNode(state, subpopulation, thread, i, i.trees[t]);
                int size = -1;
                if (this.equalSize) {
                    size = p1.numNodes(0);
                }
                if (res = this.verifyPoints(p2 = this.builder.newRootedTree(state, p1.parentType(initializer), thread, p1.parent, i.trees[t].constraints((GPInitializer)initializer).functionset, p1.argposition, size), p1)) break;
            }
            if (res) {
                p2.parent = p1.parent;
                p2.argposition = p1.argposition;
                if (p2.parent instanceof GPNode) {
                    ((GPNode)p2.parent).children[p2.argposition] = p2;
                } else {
                    ((GPTree)p2.parent).child = p2;
                }
                i.evaluated = false;
            }
            inds.set(q, i);
        }
        return n;
    }
}

