/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.nsga2;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Subpopulation;
import ec.simple.SimpleBreeder;
import ec.util.Parameter;
import java.util.ArrayList;

public class NSGA2Breeder
extends SimpleBreeder {
    public void setup(EvolutionState state, Parameter base) {
        int i;
        super.setup(state, base);
        for (i = 0; i < this.elite.length; ++i) {
            if (!this.usingElitism(i)) continue;
            state.output.warning("You're using elitism with NSGA2Breeder, which is not permitted and will be ignored.  However the reevaluate-elites parameter *will* bre recognized by NSGAEvaluator.", base.push("elite").push("" + i));
        }
        for (i = 0; i < this.reduceBy.length; ++i) {
            if (this.reduceBy[i] == 0) continue;
            state.output.fatal("NSGA2Breeder does not support population reduction.", base.push("reduce-by").push("" + i), null);
        }
        if (this.sequentialBreeding) {
            state.output.fatal("NSGA2Breeder does not support sequential evaluation.", base.push("sequential"));
        }
        if (!this.clonePipelineAndPopulation) {
            state.output.fatal("clonePipelineAndPopulation must be true for NSGA2Breeder.");
        }
    }

    public Population breedPopulation(EvolutionState state) {
        Population oldPop = state.population;
        Population newPop = super.breedPopulation(state);
        ArrayList<Subpopulation> subpops = oldPop.subpops;
        int subpopsLength = subpops.size();
        for (int i = 0; i < subpopsLength; ++i) {
            Subpopulation oldSubpop = oldPop.subpops.get(i);
            Subpopulation newSubpop = newPop.subpops.get(i);
            ArrayList<Individual> combinedInds = new ArrayList<Individual>(oldSubpop.individuals.size() + newSubpop.individuals.size());
            combinedInds.addAll(newSubpop.individuals);
            combinedInds.addAll(oldSubpop.individuals);
            newSubpop.individuals = combinedInds;
        }
        return newPop;
    }
}

