/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.nsga2;

import ec.EvolutionState;
import ec.Individual;
import ec.Subpopulation;
import ec.multiobjective.MultiObjectiveFitness;
import ec.multiobjective.nsga2.NSGA2Breeder;
import ec.multiobjective.nsga2.NSGA2MultiObjectiveFitness;
import ec.simple.SimpleEvaluator;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSGA2Evaluator
extends SimpleEvaluator {
    public int[] originalPopSize;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter p = new Parameter("pop");
        int subpopsLength = state.parameters.getInt(p.push("subpops"), null, 1);
        this.originalPopSize = new int[subpopsLength];
        for (int i = 0; i < subpopsLength; ++i) {
            Parameter p_subpop = p.push("subpop").push("" + i).push("size");
            this.originalPopSize[i] = state.parameters.getInt(p_subpop, null, 1);
        }
    }

    @Override
    public void evaluatePopulation(EvolutionState state) {
        super.evaluatePopulation(state);
        for (int x = 0; x < state.population.subpops.size(); ++x) {
            state.population.subpops.get((int)x).individuals = this.buildArchive(state, x);
        }
    }

    public ArrayList<Individual> buildArchive(EvolutionState state, int subpop) {
        ArrayList<ArrayList<Individual>> ranks = this.assignFrontRanks(state.population.subpops.get(subpop));
        ArrayList<Individual> newSubpopulation = new ArrayList<Individual>();
        int size = ranks.size();
        for (int i = 0; i < size; ++i) {
            ArrayList<Individual> rank = ranks.get(i);
            this.assignSparsity(rank);
            if (rank.size() + newSubpopulation.size() >= this.originalPopSize[subpop]) {
                Collections.sort(rank, new Comparator<Individual>(){

                    @Override
                    public int compare(Individual i1, Individual i2) {
                        return Double.compare(((NSGA2MultiObjectiveFitness)i2.fitness).sparsity, ((NSGA2MultiObjectiveFitness)i1.fitness).sparsity);
                    }
                });
                int m = this.originalPopSize[subpop] - newSubpopulation.size();
                for (int j = 0; j < m; ++j) {
                    newSubpopulation.add(rank.get(j));
                }
                break;
            }
            for (int j = 0; j < rank.size(); ++j) {
                newSubpopulation.add(rank.get(j));
            }
        }
        ArrayList<Individual> archive = new ArrayList<Individual>(newSubpopulation);
        NSGA2Breeder breeder = (NSGA2Breeder)state.breeder;
        if (breeder.reevaluateElites[subpop]) {
            for (int i = 0; i < archive.size(); ++i) {
                archive.get((int)i).evaluated = false;
            }
        }
        return archive;
    }

    public ArrayList<ArrayList<Individual>> assignFrontRanks(Subpopulation subpop) {
        ArrayList<Individual> inds = subpop.individuals;
        ArrayList<ArrayList<Individual>> frontsByRank = MultiObjectiveFitness.partitionIntoRanks(inds);
        int numRanks = frontsByRank.size();
        for (int rank = 0; rank < numRanks; ++rank) {
            ArrayList<Individual> front = frontsByRank.get(rank);
            int numInds = front.size();
            for (int ind = 0; ind < numInds; ++ind) {
                ((NSGA2MultiObjectiveFitness)front.get((int)ind).fitness).rank = rank;
            }
        }
        return frontsByRank;
    }

    public void assignSparsity(ArrayList<Individual> front) {
        int i;
        int numObjectives = ((NSGA2MultiObjectiveFitness)front.get((int)0).fitness).getObjectives().length;
        for (i = 0; i < front.size(); ++i) {
            ((NSGA2MultiObjectiveFitness)front.get((int)i).fitness).sparsity = 0.0;
        }
        for (i = 0; i < numObjectives; ++i) {
            final int o = i;
            Collections.sort(front, new Comparator<Individual>(){

                @Override
                public int compare(Individual i1, Individual i2) {
                    return Double.compare(((NSGA2MultiObjectiveFitness)i1.fitness).getObjective(o), ((NSGA2MultiObjectiveFitness)i2.fitness).getObjective(o));
                }
            });
            ((NSGA2MultiObjectiveFitness)front.get((int)0).fitness).sparsity = Double.POSITIVE_INFINITY;
            ((NSGA2MultiObjectiveFitness)front.get((int)(front.size() - 1)).fitness).sparsity = Double.POSITIVE_INFINITY;
            for (int j = 1; j < front.size() - 1; ++j) {
                NSGA2MultiObjectiveFitness f_j = (NSGA2MultiObjectiveFitness)front.get((int)j).fitness;
                NSGA2MultiObjectiveFitness f_jplus1 = (NSGA2MultiObjectiveFitness)front.get((int)(j + 1)).fitness;
                NSGA2MultiObjectiveFitness f_jminus1 = (NSGA2MultiObjectiveFitness)front.get((int)(j - 1)).fitness;
                f_j.sparsity += (f_jplus1.getObjective(o) - f_jminus1.getObjective(o)) / (f_j.maxObjective[o] - f_j.minObjective[o]);
            }
        }
    }
}

