/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.spea2;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.multiobjective.MultiObjectiveFitness;
import ec.multiobjective.spea2.SPEA2MultiObjectiveFitness;
import ec.simple.SimpleBreeder;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPEA2Breeder
extends SimpleBreeder {
    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        for (int i = 0; i < state.population.subpops.size(); ++i) {
            if (this.reduceBy[i] == 0) continue;
            state.output.fatal("SPEA2Breeder does not support population reduction.", base.push("reduce-by").push("" + i), null);
        }
        if (this.sequentialBreeding) {
            state.output.fatal("SPEA2Breeder does not support sequential evaluation.", base.push("sequential"));
        }
        if (!this.clonePipelineAndPopulation) {
            state.output.fatal("clonePipelineAndPopulation must be true for SPEA2Breeder.");
        }
    }

    @Override
    protected void loadElites(EvolutionState state, Population newpop) {
        for (int x = 0; x < state.population.subpops.size(); ++x) {
            if (this.numElites(state, x) <= state.population.subpops.get((int)x).individuals.size()) continue;
            state.output.error("The number of elites for subpopulation " + x + " exceeds the actual size of the subpopulation");
        }
        state.output.exitIfErrors();
        for (int sub = 0; sub < state.population.subpops.size(); ++sub) {
            ArrayList<Individual> newInds = newpop.subpops.get((int)sub).individuals;
            ArrayList<Individual> oldInds = state.population.subpops.get((int)sub).individuals;
            this.buildArchive(state, oldInds, newInds, this.numElites(state, sub));
        }
        this.unmarkElitesEvaluated(state, newpop);
    }

    public double[] calculateDistancesFromIndividual(Individual ind, ArrayList<Individual> inds) {
        double[] d = new double[inds.size()];
        for (int i = 0; i < inds.size(); ++i) {
            d[i] = ((SPEA2MultiObjectiveFitness)ind.fitness).sumSquaredObjectiveDistance((SPEA2MultiObjectiveFitness)inds.get((int)i).fitness);
        }
        Arrays.sort(d);
        return d;
    }

    public void buildArchive(EvolutionState state, ArrayList<Individual> oldInds, ArrayList<Individual> newInds, int archiveSize) {
        int i;
        ArrayList<Individual> archive = new ArrayList<Individual>();
        ArrayList<Individual> nonFront = new ArrayList<Individual>();
        MultiObjectiveFitness.partitionIntoParetoFront(oldInds, archive, nonFront);
        int currentArchiveSize = archive.size();
        if (currentArchiveSize < archiveSize) {
            Collections.sort(nonFront);
            int len = archiveSize - currentArchiveSize;
            for (i = 0; i < len; ++i) {
                archive.add(nonFront.get(i));
                ++currentArchiveSize;
            }
        }
        while (currentArchiveSize > archiveSize) {
            Individual closest = archive.get(0);
            int closestIndex = 0;
            double[] closestD = this.calculateDistancesFromIndividual(closest, oldInds);
            block2: for (int i2 = 1; i2 < currentArchiveSize; ++i2) {
                Individual competitor = archive.get(i2);
                double[] competitorD = this.calculateDistancesFromIndividual(competitor, oldInds);
                for (int k = 0; k < oldInds.size(); ++k) {
                    if (closestD[i2] > competitorD[i2]) {
                        closest = competitor;
                        closestD = competitorD;
                        closestIndex = k;
                        continue block2;
                    }
                    if (closestD[i2] < competitorD[i2]) continue block2;
                }
            }
            archive.set(closestIndex, archive.get(archive.size() - 1));
            archive.remove(archive.size() - 1);
            --currentArchiveSize;
        }
        Object[] obj = archive.toArray();
        for (i = 0; i < archiveSize; ++i) {
            newInds.set(newInds.size() - archiveSize + i, (Individual)((Individual)obj[i]).clone());
        }
    }
}

