/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.spea2;

import ec.EvolutionState;
import ec.Individual;
import ec.multiobjective.MultiObjectiveFitness;
import ec.multiobjective.spea2.SPEA2MultiObjectiveFitness;
import ec.simple.SimpleEvaluator;
import ec.util.MersenneTwisterFast;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPEA2Evaluator
extends SimpleEvaluator {
    @Override
    public void evaluatePopulation(EvolutionState state) {
        super.evaluatePopulation(state);
        for (int x = 0; x < state.population.subpops.size(); ++x) {
            ArrayList<Individual> inds = state.population.subpops.get((int)x).individuals;
            this.computeAuxiliaryData(state, inds);
        }
    }

    public void computeAuxiliaryData(EvolutionState state, ArrayList<Individual> inds) {
        double[][] distances = this.calculateDistances(state, inds);
        for (int y = 0; y < inds.size(); ++y) {
            int myStrength = 0;
            for (int z = 0; z < inds.size(); ++z) {
                if (!((SPEA2MultiObjectiveFitness)inds.get((int)y).fitness).paretoDominates((MultiObjectiveFitness)inds.get((int)z).fitness)) continue;
                ++myStrength;
            }
            ((SPEA2MultiObjectiveFitness)inds.get((int)y).fitness).strength = myStrength;
        }
        int kTH = (int)Math.sqrt(inds.size());
        for (int y = 0; y < inds.size(); ++y) {
            double fitness = 0.0;
            for (int z = 0; z < inds.size(); ++z) {
                if (!((SPEA2MultiObjectiveFitness)inds.get((int)z).fitness).paretoDominates((MultiObjectiveFitness)inds.get((int)y).fitness)) continue;
                fitness += ((SPEA2MultiObjectiveFitness)inds.get((int)z).fitness).strength;
            }
            SPEA2MultiObjectiveFitness indYFitness = (SPEA2MultiObjectiveFitness)inds.get((int)y).fitness;
            double kthDistance = Math.sqrt(this.orderStatistics(distances[y], kTH, state.random[0]));
            indYFitness.kthNNDistance = 1.0 / (2.0 + kthDistance);
            indYFitness.fitness = fitness + indYFitness.kthNNDistance;
        }
    }

    public double[][] calculateDistances(EvolutionState state, ArrayList<Individual> inds) {
        double[][] distances = new double[inds.size()][inds.size()];
        for (int y = 0; y < inds.size(); ++y) {
            distances[y][y] = 0.0;
            for (int z = y + 1; z < inds.size(); ++z) {
                double d = ((SPEA2MultiObjectiveFitness)inds.get((int)y).fitness).sumSquaredObjectiveDistance((SPEA2MultiObjectiveFitness)inds.get((int)z).fitness);
                distances[y][z] = d;
                distances[z][y] = d;
            }
        }
        return distances;
    }

    double orderStatistics(double[] array, int kth, MersenneTwisterFast rng) {
        return this.randomizedSelect(array, 0, array.length - 1, kth, rng);
    }

    double randomizedSelect(double[] array, int p, int r, int i, MersenneTwisterFast rng) {
        if (p == r) {
            return array[p];
        }
        int q = this.randomizedPartition(array, p, r, rng);
        int k = q - p + 1;
        if (i <= k) {
            return this.randomizedSelect(array, p, q, i, rng);
        }
        return this.randomizedSelect(array, q + 1, r, i - k, rng);
    }

    int randomizedPartition(double[] array, int p, int r, MersenneTwisterFast rng) {
        int i = rng.nextInt(r - p + 1) + p;
        double tmp = array[i];
        array[i] = array[p];
        array[p] = tmp;
        return this.partition(array, p, r);
    }

    int partition(double[] array, int p, int r) {
        double x = array[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (array[--j] > x) {
                continue;
            }
            while (array[++i] < x) {
            }
            if (i >= j) break;
            double tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
        return j;
    }
}

