/*
 * Decompiled with CFR 0.152.
 */
package ec.neat;

import ec.EvolutionState;
import ec.Prototype;
import ec.neat.NEATDefaults;
import ec.neat.NEATGene;
import ec.neat.NEATNetwork;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class NEATNode
implements Prototype {
    public static final String P_NODE = "node";
    public int activationCount;
    public double lastActivation;
    public double previousLastActivation;
    public boolean override;
    public double overrideValue;
    public boolean frozen;
    public FunctionType functionType;
    public NodeType type;
    public NodePlace geneticNodeLabel;
    public double activeSum;
    public double activation;
    public boolean activeFlag;
    public ArrayList<NEATGene> incomingGenes;
    public int nodeId;
    public int innerLevel;
    public boolean isTraversed;

    public void setup(EvolutionState state, Parameter base) {
        this.activationCount = 0;
        this.lastActivation = 0.0;
        this.previousLastActivation = 0.0;
        this.override = false;
        this.overrideValue = 0.0;
        this.frozen = false;
        this.functionType = FunctionType.SIGMOID;
        this.type = NodeType.NEURON;
        this.geneticNodeLabel = NodePlace.HIDDEN;
        this.activeSum = 0.0;
        this.activation = 0.0;
        this.activeFlag = false;
        this.incomingGenes = new ArrayList();
        this.nodeId = 0;
        this.innerLevel = 0;
        this.isTraversed = false;
    }

    public Parameter defaultBase() {
        return NEATDefaults.base().push(P_NODE);
    }

    public void reset(NodeType nodeType, int id, NodePlace placement) {
        this.nodeId = id;
        this.activeFlag = false;
        this.activeSum = 0.0;
        this.activation = 0.0;
        this.lastActivation = 0.0;
        this.previousLastActivation = 0.0;
        this.type = nodeType;
        this.activationCount = 0;
        this.functionType = FunctionType.SIGMOID;
        this.geneticNodeLabel = placement;
        this.frozen = false;
        this.override = false;
        this.overrideValue = 0.0;
        this.innerLevel = 0;
        this.isTraversed = false;
    }

    public Object emptyClone() {
        NEATNode myobj = (NEATNode)this.clone();
        myobj.incomingGenes = new ArrayList();
        return myobj;
    }

    public Object clone() {
        NEATNode myobj = null;
        try {
            myobj = (NEATNode)super.clone();
            myobj.nodeId = this.nodeId;
            myobj.type = this.type;
            myobj.geneticNodeLabel = this.geneticNodeLabel;
            myobj.activationCount = 0;
            myobj.lastActivation = 0.0;
            myobj.previousLastActivation = 0.0;
            myobj.override = false;
            myobj.overrideValue = 0.0;
            myobj.frozen = false;
            myobj.functionType = FunctionType.SIGMOID;
            myobj.activeSum = 0.0;
            myobj.activation = 0.0;
            myobj.activeFlag = false;
            myobj.isTraversed = false;
            myobj.innerLevel = 0;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return myobj;
    }

    public boolean equals(Object obj) {
        NEATNode n = (NEATNode)obj;
        if (this.nodeId != n.nodeId) {
            return false;
        }
        for (int i = 0; i < this.incomingGenes.size(); ++i) {
            if (n.incomingGenes.get(i).equals(this.incomingGenes.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.nodeId;
        for (int i = 0; i < this.incomingGenes.size(); ++i) {
            result = result * 31 + 17 + this.incomingGenes.get(i).hashCode();
        }
        return result;
    }

    public void flushBack() {
        if (this.type != NodeType.SENSOR) {
            if (this.activationCount > 0) {
                this.activationCount = 0;
                this.activation = 0.0;
                this.lastActivation = 0.0;
                this.previousLastActivation = 0.0;
            }
            for (int i = 0; i < this.incomingGenes.size(); ++i) {
                NEATGene link = this.incomingGenes.get(i);
                if (link.inNode.activationCount <= 0) continue;
                link.inNode.flushBack();
            }
        } else {
            this.activationCount = 0;
            this.activation = 0.0;
            this.lastActivation = 0.0;
            this.previousLastActivation = 0.0;
        }
    }

    public void flush() {
        this.activationCount = 0;
        this.activation = 0.0;
        this.lastActivation = 0.0;
        this.previousLastActivation = 0.0;
    }

    public double getActivation() {
        if (this.activationCount > 0) {
            return this.activation;
        }
        return 0.0;
    }

    public double getTimeDelayActivation() {
        if (this.activationCount > 1) {
            return this.lastActivation;
        }
        return 0.0;
    }

    public void activateWithOverride() {
        this.activation = this.overrideValue;
        this.override = false;
    }

    public void overrideOutput(double newOutput) {
        this.overrideValue = newOutput;
        this.override = true;
    }

    public void clearIncoming() {
        this.incomingGenes.clear();
    }

    public int depth(int d, NEATNetwork network, int maxDepth) {
        if (d > 100) {
            return 10;
        }
        if (this.type == NodeType.SENSOR) {
            return d;
        }
        ++d;
        int curDepth = 0;
        for (int i = 0; i < this.incomingGenes.size(); ++i) {
            NEATNode node = this.incomingGenes.get((int)i).inNode;
            if (!node.isTraversed) {
                node.isTraversed = true;
                curDepth = node.depth(d, network, maxDepth);
                node.innerLevel = curDepth - d;
            } else {
                curDepth = d + node.innerLevel;
            }
            maxDepth = Math.max(curDepth, maxDepth);
        }
        return maxDepth;
    }

    public void readNode(EvolutionState state, LineNumberReader reader) throws IOException {
        this.readNodeFromString(reader.readLine(), state);
    }

    public void readNodeFromString(String string, EvolutionState state) {
        DecodeReturn dr = new DecodeReturn(string);
        Code.decode(dr);
        this.nodeId = (int)dr.l;
        Code.decode(dr);
        int nType = (int)dr.l;
        Code.decode(dr);
        int nPlace = (int)dr.l;
        this.type = NodeType.values()[nType];
        this.geneticNodeLabel = NodePlace.values()[nPlace];
        this.override = false;
        this.activeSum = 0.0;
        this.frozen = false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String maskf = " #,##0";
        DecimalFormat fmtf = new DecimalFormat(maskf);
        if (this.type == NodeType.SENSOR) {
            stringBuffer.append("\n (Sensor)");
        }
        if (this.type == NodeType.NEURON) {
            stringBuffer.append("\n (Neuron)");
        }
        stringBuffer.append(fmtf.format(this.nodeId));
        String mask5 = " #,##0.000";
        fmtf = new DecimalFormat(mask5);
        stringBuffer.append(" activation count " + fmtf.format(this.activationCount) + " activation=" + fmtf.format(this.activation) + ")");
        return stringBuffer.toString();
    }

    public String printNodeToString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Code.encode(this.nodeId));
        stringBuilder.append(Code.encode(this.type.ordinal()));
        stringBuilder.append(Code.encode(this.geneticNodeLabel.ordinal()));
        return stringBuilder.toString();
    }

    public void sigmoid(double slope) {
        this.activation = 1.0 / (1.0 + Math.exp(-(slope * this.activeSum)));
    }

    public boolean sensorLoad(double val) {
        if (this.type == NodeType.SENSOR) {
            this.previousLastActivation = this.lastActivation;
            this.lastActivation = this.activation;
            ++this.activationCount;
            this.activation = val;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FunctionType {
        SIGMOID;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodePlace {
        HIDDEN,
        INPUT,
        OUTPUT,
        BIAS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeType {
        NEURON,
        SENSOR;

    }
}

