/*
 * Decompiled with CFR 0.152.
 */
package ec.pso;

import ec.Breeder;
import ec.EvolutionState;
import ec.Fitness;
import ec.Population;
import ec.pso.Particle;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;

public class PSOBreeder
extends Breeder {
    public static final int C_NEIGHBORHOOD_RANDOM = 0;
    public static final int C_NEIGHBORHOOD_TOROIDAL = 1;
    public static final int C_NEIGHBORHOOD_RANDOM_EACH_TIME = 2;
    public static final String P_VELOCITY_COEFFICIENT = "velocity-coefficient";
    public static final String P_PERSONAL_COEFFICIENT = "personal-coefficient";
    public static final String P_INFORMANT_COEFFICIENT = "informant-coefficient";
    public static final String P_GLOBAL_COEFFICIENT = "global-coefficient";
    public static final String P_INCLUDE_SELF = "include-self";
    public static final String P_NEIGHBORHOOD = "neighborhood-style";
    public static final String P_NEIGHBORHOOD_SIZE = "neighborhood-size";
    public static final String V_NEIGHBORHOOD_RANDOM = "random";
    public static final String V_NEIGHBORHOOD_TOROIDAL = "toroidal";
    public static final String V_NEIGHBORHOOD_RANDOM_EACH_TIME = "random-each-time";
    public int neighborhood = 0;
    public double velCoeff = 0.5;
    public double personalCoeff = 0.5;
    public double informantCoeff = 0.5;
    public double globalCoeff = 0.5;
    public int neighborhoodSize = 3;
    public boolean includeSelf = false;
    public double[][] globalBest = null;
    public Fitness[] globalBestFitness = null;

    public void setup(EvolutionState state, Parameter base) {
        String sch;
        this.velCoeff = state.parameters.getDouble(base.push(P_VELOCITY_COEFFICIENT), null, 0.0);
        if (this.velCoeff < 0.0) {
            state.output.fatal("Parameter not found, or its value is less than 0.", base.push(P_VELOCITY_COEFFICIENT), null);
        }
        this.personalCoeff = state.parameters.getDouble(base.push(P_PERSONAL_COEFFICIENT), null, 0.0);
        if (this.personalCoeff < 0.0) {
            state.output.fatal("Parameter not found, or its value is less than 0.", base.push(P_PERSONAL_COEFFICIENT), null);
        }
        this.informantCoeff = state.parameters.getDouble(base.push(P_INFORMANT_COEFFICIENT), null, 0.0);
        if (this.informantCoeff < 0.0) {
            state.output.fatal("Parameter not found, or its value is less than 0.", base.push(P_INFORMANT_COEFFICIENT), null);
        }
        this.globalCoeff = state.parameters.getDouble(base.push(P_GLOBAL_COEFFICIENT), null, 0.0);
        if (this.globalCoeff < 0.0) {
            state.output.fatal("Parameter not found, or its value is less than 0.", base.push(P_GLOBAL_COEFFICIENT), null);
        }
        this.neighborhoodSize = state.parameters.getInt(base.push(P_NEIGHBORHOOD_SIZE), null, 1);
        if (this.neighborhoodSize <= 0) {
            state.output.fatal("Neighbourhood size must be a value >= 1.", base.push(P_NEIGHBORHOOD_SIZE), null);
        }
        if (V_NEIGHBORHOOD_RANDOM.equals(sch = state.parameters.getString(base.push(P_NEIGHBORHOOD), null))) {
            this.neighborhood = 0;
        } else if (V_NEIGHBORHOOD_TOROIDAL.equals(sch)) {
            this.neighborhood = 1;
        } else if (V_NEIGHBORHOOD_RANDOM_EACH_TIME.equals(sch)) {
            this.neighborhood = 2;
        } else {
            state.output.fatal("Neighborhood style must be either 'random', 'toroidal', or 'random-each-time'.", base.push(P_NEIGHBORHOOD), null);
        }
        this.includeSelf = state.parameters.getBoolean(base.push(P_INCLUDE_SELF), null, false);
    }

    public Population breedPopulation(EvolutionState state) {
        int ind;
        int subpop;
        if (this.globalBest == null) {
            this.globalBest = new double[state.population.subpops.size()][];
            this.globalBestFitness = new Fitness[state.population.subpops.size()];
        }
        for (subpop = 0; subpop < state.population.subpops.size(); ++subpop) {
            for (ind = 0; ind < state.population.subpops.get((int)subpop).individuals.size(); ++ind) {
                if (this.globalBestFitness[subpop] == null || state.population.subpops.get((int)subpop).individuals.get((int)ind).fitness.betterThan(this.globalBestFitness[subpop])) {
                    this.globalBest[subpop] = ((DoubleVectorIndividual)state.population.subpops.get((int)subpop).individuals.get((int)ind)).genome;
                    this.globalBestFitness[subpop] = state.population.subpops.get((int)subpop).individuals.get((int)ind).fitness;
                }
                ((Particle)state.population.subpops.get((int)subpop).individuals.get(ind)).update(state, subpop, ind, 0);
            }
            this.globalBest[subpop] = (double[])this.globalBest[subpop].clone();
            this.globalBestFitness[subpop] = (Fitness)this.globalBestFitness[subpop].clone();
        }
        for (subpop = 0; subpop < state.population.subpops.size(); ++subpop) {
            for (ind = 0; ind < state.population.subpops.get((int)subpop).individuals.size(); ++ind) {
                ((Particle)state.population.subpops.get((int)subpop).individuals.get(ind)).tweak(state, this.globalBest[subpop], this.velCoeff, this.personalCoeff, this.informantCoeff, this.globalCoeff, 0);
            }
        }
        return state.population;
    }
}

