/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.util.Parameter;
import java.util.ArrayList;

public class TopSelection
extends SelectionMethod {
    public static final String P_TOP = "top";
    public static final String P_CACHE = "cache";
    boolean cache;
    int best;

    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_TOP);
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.cache = state.parameters.getBoolean(base.push(P_CACHE), def.push(P_CACHE), false);
    }

    public void prepareToProduce(EvolutionState s, int subpopulation, int thread) {
        super.prepareToProduce(s, subpopulation, thread);
        if (this.cache) {
            this.best = -1;
        }
    }

    public void cacheBest(int subpopulation, EvolutionState state, int thread) {
        ArrayList<Individual> oldinds = state.population.subpops.get((int)subpopulation).individuals;
        int len = oldinds.size();
        int b = 0;
        Individual bi = oldinds.get(b);
        int ties = 1;
        for (int i = 1; i < len; ++i) {
            Individual ni = oldinds.get(i);
            if (ni.fitness.betterThan(bi.fitness)) {
                bi = ni;
                b = i;
                ties = 1;
                continue;
            }
            if (!ni.fitness.equivalentTo(bi.fitness) || !state.random[thread].nextBoolean(1.0 / (double)(++ties))) continue;
            bi = ni;
            b = i;
        }
        this.best = b;
    }

    public int produce(int subpopulation, EvolutionState state, int thread) {
        if (!this.cache || this.best < 0) {
            this.cacheBest(subpopulation, state, thread);
        }
        return this.best;
    }
}

