/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.EvolutionState;
import ec.Individual;
import ec.Statistics;
import ec.util.Parameter;
import java.io.File;
import java.io.IOException;

public class SimpleShortStatistics
extends Statistics {
    public static final String P_STATISTICS_MODULUS = "modulus";
    public static final String P_COMPRESS = "gzip";
    public static final String P_FULL = "gather-full";
    public static final String P_DO_SIZE = "do-size";
    public static final String P_DO_TIME = "do-time";
    public static final String P_DO_SUBPOPS = "do-subpops";
    public static final String P_STATISTICS_FILE = "file";
    public int statisticslog = 0;
    public int modulus;
    public boolean doSize;
    public boolean doTime;
    public boolean doSubpops;
    public Individual[] bestSoFar;
    public long[] totalSizeSoFar;
    public long[] totalIndsSoFar;
    public long[] totalIndsThisGen;
    public long[] totalSizeThisGen;
    public double[] totalFitnessThisGen;
    public Individual[] bestOfGeneration;
    public long lastTime;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        File statisticsFile = state.parameters.getFile(base.push(P_STATISTICS_FILE), null);
        this.modulus = state.parameters.getIntWithDefault(base.push(P_STATISTICS_MODULUS), null, 1);
        if (this.silentFile) {
            this.statisticslog = -2;
        } else if (statisticsFile != null) {
            try {
                this.statisticslog = state.output.addLog(statisticsFile, !state.parameters.getBoolean(base.push(P_COMPRESS), null, false), state.parameters.getBoolean(base.push(P_COMPRESS), null, false));
            }
            catch (IOException i) {
                state.output.fatal("An IOException occurred while trying to create the log " + statisticsFile + ":\n" + i);
            }
        } else {
            state.output.warning("No statistics file specified, printing to stdout at end.", base.push(P_STATISTICS_FILE));
        }
        this.doSize = state.parameters.getBoolean(base.push(P_DO_SIZE), null, false);
        this.doTime = state.parameters.getBoolean(base.push(P_DO_TIME), null, false);
        if (state.parameters.exists(base.push(P_FULL), null)) {
            state.output.warning("gather-full is deprecated.  Use do-size and do-time instead.  Also be warned that the table columns have been reorganized. ", base.push(P_FULL), null);
            boolean gather = state.parameters.getBoolean(base.push(P_FULL), null, false);
            this.doSize = this.doSize || gather;
            this.doTime = this.doTime || gather;
        }
        this.doSubpops = state.parameters.getBoolean(base.push(P_DO_SUBPOPS), null, false);
    }

    public Individual[] getBestSoFar() {
        return this.bestSoFar;
    }

    public void preInitializationStatistics(EvolutionState state) {
        boolean output;
        super.preInitializationStatistics(state);
        boolean bl = output = state.generation % this.modulus == 0;
        if (output && this.doTime) {
            this.lastTime = System.currentTimeMillis();
        }
    }

    public void postInitializationStatistics(EvolutionState state) {
        super.postInitializationStatistics(state);
        boolean output = state.generation % this.modulus == 0;
        this.bestSoFar = new Individual[state.population.subpops.size()];
        if (output) {
            state.output.print("0 ", this.statisticslog);
        }
        this.totalSizeSoFar = new long[state.population.subpops.size()];
        this.totalIndsSoFar = new long[state.population.subpops.size()];
        if (output && this.doTime) {
            state.output.print("" + (System.currentTimeMillis() - this.lastTime) + " ", this.statisticslog);
        }
    }

    public void preBreedingStatistics(EvolutionState state) {
        boolean output;
        super.preBreedingStatistics(state);
        boolean bl = output = state.generation % this.modulus == this.modulus - 1;
        if (output && this.doTime) {
            this.lastTime = System.currentTimeMillis();
        }
    }

    public void postBreedingStatistics(EvolutionState state) {
        boolean output;
        super.postBreedingStatistics(state);
        boolean bl = output = state.generation % this.modulus == this.modulus - 1;
        if (output) {
            state.output.print("" + (state.generation + 1) + " ", this.statisticslog);
        }
        if (output && this.doTime) {
            state.output.print("" + (System.currentTimeMillis() - this.lastTime) + " ", this.statisticslog);
        }
    }

    public void preEvaluationStatistics(EvolutionState state) {
        boolean output;
        super.preEvaluationStatistics(state);
        boolean bl = output = state.generation % this.modulus == 0;
        if (output && this.doTime) {
            this.lastTime = System.currentTimeMillis();
        }
    }

    protected void prepareStatistics(EvolutionState state) {
    }

    protected void gatherExtraSubpopStatistics(EvolutionState state, int subpop, int individual) {
    }

    protected void printExtraSubpopStatisticsBefore(EvolutionState state, int subpop) {
    }

    protected void printExtraSubpopStatisticsAfter(EvolutionState state, int subpop) {
    }

    protected void gatherExtraPopStatistics(EvolutionState state, int subpop) {
    }

    protected void printExtraPopStatisticsBefore(EvolutionState state) {
    }

    protected void printExtraPopStatisticsAfter(EvolutionState state) {
    }

    public void postEvaluationStatistics(EvolutionState state) {
        boolean output;
        super.postEvaluationStatistics(state);
        boolean bl = output = state.generation % this.modulus == 0;
        if (output && this.doTime) {
            Runtime r = Runtime.getRuntime();
            long curU = r.totalMemory() - r.freeMemory();
            state.output.print("" + (System.currentTimeMillis() - this.lastTime) + " ", this.statisticslog);
        }
        int subpops = state.population.subpops.size();
        this.totalIndsThisGen = new long[subpops];
        this.bestOfGeneration = new Individual[subpops];
        this.totalSizeThisGen = new long[subpops];
        this.totalFitnessThisGen = new double[subpops];
        double[] meanFitnessThisGen = new double[subpops];
        this.prepareStatistics(state);
        for (int x = 0; x < subpops; ++x) {
            for (int y = 0; y < state.population.subpops.get((int)x).individuals.size(); ++y) {
                if (!state.population.subpops.get((int)x).individuals.get((int)y).evaluated) continue;
                long size = state.population.subpops.get((int)x).individuals.get(y).size();
                int n = x;
                this.totalSizeThisGen[n] = this.totalSizeThisGen[n] + size;
                int n2 = x;
                this.totalSizeSoFar[n2] = this.totalSizeSoFar[n2] + size;
                int n3 = x;
                this.totalIndsThisGen[n3] = this.totalIndsThisGen[n3] + 1L;
                int n4 = x;
                this.totalIndsSoFar[n4] = this.totalIndsSoFar[n4] + 1L;
                if (this.bestOfGeneration[x] == null || state.population.subpops.get((int)x).individuals.get((int)y).fitness.betterThan(this.bestOfGeneration[x].fitness)) {
                    this.bestOfGeneration[x] = state.population.subpops.get((int)x).individuals.get(y);
                    if (this.bestSoFar[x] == null || this.bestOfGeneration[x].fitness.betterThan(this.bestSoFar[x].fitness)) {
                        this.bestSoFar[x] = (Individual)this.bestOfGeneration[x].clone();
                    }
                }
                int n5 = x;
                this.totalFitnessThisGen[n5] = this.totalFitnessThisGen[n5] + state.population.subpops.get((int)x).individuals.get((int)y).fitness.fitness();
                this.gatherExtraSubpopStatistics(state, x, y);
            }
            double d = meanFitnessThisGen[x] = this.totalIndsThisGen[x] > 0L ? this.totalFitnessThisGen[x] / (double)this.totalIndsThisGen[x] : 0.0;
            if (output && this.doSubpops) {
                this.printExtraSubpopStatisticsBefore(state, x);
            }
            if (output && this.doSize && this.doSubpops) {
                state.output.print("" + (this.totalIndsThisGen[x] > 0L ? (double)this.totalSizeThisGen[x] / (double)this.totalIndsThisGen[x] : 0.0) + " ", this.statisticslog);
                state.output.print("" + (this.totalIndsSoFar[x] > 0L ? (double)this.totalSizeSoFar[x] / (double)this.totalIndsSoFar[x] : 0.0) + " ", this.statisticslog);
                state.output.print("" + (double)this.bestOfGeneration[x].size() + " ", this.statisticslog);
                state.output.print("" + (double)this.bestSoFar[x].size() + " ", this.statisticslog);
            }
            if (output && this.doSubpops) {
                state.output.print("" + meanFitnessThisGen[x] + " ", this.statisticslog);
                state.output.print("" + this.bestOfGeneration[x].fitness.fitness() + " ", this.statisticslog);
                state.output.print("" + this.bestSoFar[x].fitness.fitness() + " ", this.statisticslog);
            }
            if (!output || !this.doSubpops) continue;
            this.printExtraSubpopStatisticsAfter(state, x);
        }
        long popTotalInds = 0L;
        long popTotalIndsSoFar = 0L;
        long popTotalSize = 0L;
        long popTotalSizeSoFar = 0L;
        double popMeanFitness = 0.0;
        double popTotalFitness = 0.0;
        Individual popBestOfGeneration = null;
        Individual popBestSoFar = null;
        for (int x = 0; x < subpops; ++x) {
            popTotalInds += this.totalIndsThisGen[x];
            popTotalIndsSoFar += this.totalIndsSoFar[x];
            popTotalSize += this.totalSizeThisGen[x];
            popTotalSizeSoFar += this.totalSizeSoFar[x];
            popTotalFitness += this.totalFitnessThisGen[x];
            if (this.bestOfGeneration[x] != null && (popBestOfGeneration == null || this.bestOfGeneration[x].fitness.betterThan(popBestOfGeneration.fitness))) {
                popBestOfGeneration = this.bestOfGeneration[x];
            }
            if (this.bestSoFar[x] != null && (popBestSoFar == null || this.bestSoFar[x].fitness.betterThan(popBestSoFar.fitness))) {
                popBestSoFar = this.bestSoFar[x];
            }
            this.gatherExtraPopStatistics(state, x);
        }
        double d = popMeanFitness = popTotalInds > 0L ? popTotalFitness / (double)popTotalInds : 0.0;
        if (output) {
            this.printExtraPopStatisticsBefore(state);
        }
        if (output && this.doSize) {
            state.output.print("" + (popTotalInds > 0L ? popTotalSize / popTotalInds : 0L) + " ", this.statisticslog);
            state.output.print("" + (popTotalIndsSoFar > 0L ? popTotalSizeSoFar / popTotalIndsSoFar : 0L) + " ", this.statisticslog);
            state.output.print("" + (double)popBestOfGeneration.size() + " ", this.statisticslog);
            state.output.print("" + (double)popBestSoFar.size() + " ", this.statisticslog);
        }
        if (output) {
            state.output.print("" + popMeanFitness + " ", this.statisticslog);
            state.output.print("" + popBestOfGeneration.fitness.fitness() + " ", this.statisticslog);
            state.output.print("" + popBestSoFar.fitness.fitness() + " ", this.statisticslog);
        }
        if (output) {
            this.printExtraPopStatisticsAfter(state);
        }
        if (output) {
            state.output.println("", this.statisticslog);
        }
    }
}

