/*
 * Decompiled with CFR 0.152.
 */
package ec.spatial;

import ec.EvolutionState;
import ec.Subpopulation;
import ec.select.TournamentSelection;
import ec.spatial.Space;
import ec.spatial.SpatialDefaults;
import ec.util.Parameter;

public class SpatialTournamentSelection
extends TournamentSelection {
    public static final String P_N_SIZE = "neighborhood-size";
    int neighborhoodSize;
    public static final String P_IND_COMPETES = "ind-competes";
    boolean indCompetes;
    public static final String P_TYPE = "type";
    public static final String V_UNIFORM = "uniform";
    public static final String V_RANDOM_WALK = "random-walk";
    public static final int TYPE_UNIFORM = 0;
    public static final int TYPE_RANDOM_WALK = 1;
    int type;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter defaultBase = this.defaultBase();
        this.neighborhoodSize = state.parameters.getInt(base.push(P_N_SIZE), defaultBase.push(P_N_SIZE), 1);
        if (this.neighborhoodSize < 1) {
            state.output.fatal("Parameter not found, or its value is < 1.", base.push(P_N_SIZE), defaultBase.push(P_N_SIZE));
        }
        if (!state.parameters.exists(base.push(P_TYPE), defaultBase.push(P_TYPE)) || state.parameters.getString(base.push(P_TYPE), defaultBase.push(P_TYPE)).equals(V_UNIFORM)) {
            this.type = 0;
        } else if (state.parameters.getString(base.push(P_TYPE), defaultBase.push(P_TYPE)).equals(V_RANDOM_WALK)) {
            this.type = 1;
        } else {
            state.output.fatal("Invalid parameter, must be either random-walk or uniform.", base.push(P_TYPE), defaultBase.push(P_TYPE));
        }
        this.indCompetes = state.parameters.getBoolean(base.push(P_IND_COMPETES), defaultBase.push(P_IND_COMPETES), false);
    }

    public Parameter defaultBase() {
        return SpatialDefaults.base().push("tournament");
    }

    public int getRandomIndividual(int number, int subpopulation, EvolutionState state, int thread) {
        Subpopulation subpop = state.population.subpops.get(subpopulation);
        if (!(subpop instanceof Space)) {
            state.output.fatal("Subpopulation " + subpopulation + " is not a spatially-embedded subpopulation.\n");
        }
        Space space = (Space)((Object)state.population.subpops.get(subpopulation));
        int index = space.getIndex(thread);
        if (number == 0 && this.indCompetes) {
            return index;
        }
        if (this.type == 0) {
            return space.getIndexRandomNeighbor(state, thread, this.neighborhoodSize);
        }
        int oldIndex = index;
        for (int x = 0; x < this.neighborhoodSize; ++x) {
            space.setIndex(thread, space.getIndexRandomNeighbor(state, thread, 1));
        }
        int val = space.getIndex(thread);
        space.setIndex(thread, oldIndex);
        return val;
    }
}

