/*
 * Decompiled with CFR 0.152.
 */
package ec.steadystate;

import ec.BreedingSource;
import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.simple.SimpleBreeder;
import ec.steadystate.SteadyStateBSourceForm;
import ec.steadystate.SteadyStateDefaults;
import ec.steadystate.SteadyStateEvolutionState;
import ec.util.Parameter;
import java.util.ArrayList;

public class SteadyStateBreeder
extends SimpleBreeder {
    private static final long serialVersionUID = 1L;
    BreedingSource[] bp = null;
    public static final String P_DESELECTOR = "deselector";
    SelectionMethod[] deselectors = null;

    public void setup(EvolutionState state, Parameter base) {
        Parameter p;
        int size;
        super.setup(state, base);
        if (!this.clonePipelineAndPopulation) {
            state.output.fatal("clonePipelineAndPopulation must be true for SteadyStateBreeder -- we'll use only one Pipeline anyway.");
        }
        if ((size = state.parameters.getInt(p = new Parameter("pop").push("subpops"), null, 1)) > 0) {
            this.deselectors = new SelectionMethod[size];
        }
        for (int x = 0; x < this.deselectors.length; ++x) {
            this.deselectors[x] = (SelectionMethod)state.parameters.getInstanceForParameter(SteadyStateDefaults.base().push(P_DESELECTOR).push("" + x), null, SelectionMethod.class);
            if (!(this.deselectors[x] instanceof SteadyStateBSourceForm)) {
                state.output.error("Deselector for subpopulation " + x + " is not of SteadyStateBSourceForm.");
            }
            this.deselectors[x].setup(state, SteadyStateDefaults.base().push(P_DESELECTOR).push("" + x));
        }
        state.output.exitIfErrors();
        if (this.sequentialBreeding) {
            state.output.fatal("SteadyStateBreeder does not support sequential evaluation.", base.push("sequential"));
        }
    }

    public void sourcesAreProperForm(SteadyStateEvolutionState state, BreedingSource[] breedingSources) {
        for (int x = 0; x < breedingSources.length; ++x) {
            ((SteadyStateBSourceForm)((Object)breedingSources[x])).sourcesAreProperForm(state);
        }
    }

    public void individualReplaced(SteadyStateEvolutionState state, int subpopulation, int thread, int individual) {
        for (int x = 0; x < this.bp.length; ++x) {
            ((SteadyStateBSourceForm)((Object)this.bp[x])).individualReplaced(state, subpopulation, thread, individual);
        }
        ((SteadyStateBSourceForm)((Object)this.deselectors[subpopulation])).individualReplaced(state, subpopulation, thread, individual);
    }

    public void finishPipelines(EvolutionState state) {
        for (int x = 0; x < this.deselectors.length; ++x) {
            this.bp[x].finishProducing(state, x, 0);
            this.deselectors[x].finishProducing(state, x, 0);
        }
    }

    public void prepareToBreed(EvolutionState state, int thread) {
        int pop;
        SteadyStateEvolutionState st = (SteadyStateEvolutionState)state;
        this.bp = new BreedingSource[st.population.subpops.size()];
        for (pop = 0; pop < this.bp.length; ++pop) {
            this.bp[pop] = (BreedingSource)st.population.subpops.get((int)pop).species.pipe_prototype.clone();
            if (!this.bp[pop].produces(st, st.population, pop, 0)) {
                st.output.error("The Breeding Source of subpopulation " + pop + " does not produce individuals of the expected species " + st.population.subpops.get((int)pop).species.getClass().getName() + " and with the expected Fitness class " + st.population.subpops.get((int)pop).species.f_prototype.getClass().getName());
            }
            this.bp[pop].fillStubs(state, null);
        }
        this.sourcesAreProperForm(st, this.bp);
        st.output.exitIfErrors();
        for (pop = 0; pop < this.bp.length; ++pop) {
            this.bp[pop].prepareToProduce(state, pop, 0);
            this.deselectors[pop].prepareToProduce(state, pop, 0);
        }
    }

    public Individual breedIndividual(EvolutionState state, int subpop, int thread) {
        ArrayList<Individual> newind = new ArrayList<Individual>();
        this.bp[subpop].produce(1, 1, subpop, newind, state, thread, state.population.subpops.get((int)subpop).species.buildMisc(state, subpop, thread));
        return newind.get(0);
    }
}

