/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import ec.util.Indexed;
import ec.util.MersenneTwisterFast;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class DoubleBag
implements Serializable,
Cloneable,
Indexed {
    private static final long serialVersionUID = 1L;
    public double[] objs;
    public int numObjs;

    public DoubleBag(int capacity) {
        this.numObjs = 0;
        this.objs = new double[capacity];
    }

    public DoubleBag() {
        this.numObjs = 0;
        this.objs = new double[1];
    }

    public DoubleBag(DoubleBag other) {
        if (other == null) {
            this.numObjs = 0;
            this.objs = new double[1];
        } else {
            this.numObjs = other.numObjs;
            this.objs = new double[this.numObjs];
            System.arraycopy(other.objs, 0, this.objs, 0, this.numObjs);
        }
    }

    public DoubleBag(double[] other) {
        this();
        if (other != null) {
            this.addAll(other);
        }
    }

    public int size() {
        return this.numObjs;
    }

    public boolean isEmpty() {
        return this.numObjs <= 0;
    }

    public boolean addAll(double[] other) {
        return this.addAll(this.numObjs, other);
    }

    public boolean addAll(int index, double[] other) {
        if (index > this.numObjs) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (other.length == 0) {
            return false;
        }
        if (this.numObjs + other.length > this.objs.length) {
            this.resize(this.numObjs + other.length);
        }
        if (index != this.numObjs) {
            System.arraycopy(this.objs, index, this.objs, index + other.length, this.numObjs - index);
        }
        System.arraycopy(other, 0, this.objs, index, other.length);
        this.numObjs += other.length;
        return true;
    }

    public boolean addAll(DoubleBag other) {
        return this.addAll(this.numObjs, other);
    }

    public boolean addAll(int index, DoubleBag other) {
        if (index > this.numObjs) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (other.numObjs <= 0) {
            return false;
        }
        if (this.numObjs + other.numObjs > this.objs.length) {
            this.resize(this.numObjs + other.numObjs);
        }
        if (index != this.numObjs) {
            System.arraycopy(this.objs, index, this.objs, index + other.size(), this.numObjs - index);
        }
        System.arraycopy(other.objs, 0, this.objs, index, other.numObjs);
        this.numObjs += other.numObjs;
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        DoubleBag b = (DoubleBag)super.clone();
        b.objs = (double[])this.objs.clone();
        return b;
    }

    public void resize(int toAtLeast) {
        if (this.objs.length >= toAtLeast) {
            return;
        }
        if (this.objs.length * 2 > toAtLeast) {
            toAtLeast = this.objs.length * 2;
        }
        double[] newobjs = new double[toAtLeast];
        System.arraycopy(this.objs, 0, newobjs, 0, this.numObjs);
        this.objs = newobjs;
    }

    public void shrink(int desiredLength) {
        if (desiredLength < this.numObjs) {
            desiredLength = this.numObjs;
        }
        if (desiredLength >= this.objs.length) {
            return;
        }
        double[] newobjs = new double[desiredLength];
        System.arraycopy(this.objs, 0, newobjs, 0, this.numObjs);
        this.objs = newobjs;
    }

    public double top() {
        if (this.numObjs <= 0) {
            return 0.0;
        }
        return this.objs[this.numObjs - 1];
    }

    public double pop() {
        int numObjs = this.numObjs;
        if (numObjs <= 0) {
            return 0.0;
        }
        double ret = this.objs[--numObjs];
        this.numObjs = numObjs;
        return ret;
    }

    public boolean push(double obj) {
        if (this.numObjs >= this.objs.length) {
            this.doubleCapacityPlusOne();
        }
        this.objs[this.numObjs++] = obj;
        return true;
    }

    public boolean add(double obj) {
        if (this.numObjs >= this.objs.length) {
            this.doubleCapacityPlusOne();
        }
        this.objs[this.numObjs++] = obj;
        return true;
    }

    void doubleCapacityPlusOne() {
        double[] newobjs = new double[this.numObjs * 2 + 1];
        System.arraycopy(this.objs, 0, newobjs, 0, this.numObjs);
        this.objs = newobjs;
    }

    public boolean contains(double o) {
        int numObjs = this.numObjs;
        double[] objs = this.objs;
        for (int x = 0; x < numObjs; ++x) {
            if (o != objs[x]) continue;
            return true;
        }
        return false;
    }

    public double get(int index) {
        if (index >= this.numObjs) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.objs[index];
    }

    public Object getValue(int index) {
        return new Double(this.get(index));
    }

    public double set(int index, double element) {
        if (index >= this.numObjs) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        double returnval = this.objs[index];
        this.objs[index] = element;
        return returnval;
    }

    public Object setValue(int index, Object value) {
        Double old = new Double(this.get(index));
        Double newval = null;
        try {
            newval = (Double)value;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Expected a Double");
        }
        this.set(index, newval);
        return old;
    }

    public double removeNondestructively(int index) {
        if (index >= this.numObjs) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        double ret = this.objs[index];
        if (index < this.numObjs - 1) {
            System.arraycopy(this.objs, index + 1, this.objs, index, this.numObjs - index - 1);
        }
        --this.numObjs;
        return ret;
    }

    public double remove(int index) {
        int _numObjs;
        if (index >= (_numObjs = this.numObjs--)) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        double[] _objs = this.objs;
        double ret = _objs[index];
        _objs[index] = _objs[_numObjs - 1];
        return ret;
    }

    public void sort() {
        Arrays.sort(this.objs, 0, this.numObjs);
    }

    public void fill(double o) {
        double[] objs = this.objs;
        int numObjs = this.numObjs;
        for (int x = 0; x < numObjs; ++x) {
            objs[x] = o;
        }
    }

    public void shuffle(Random random) {
        double[] objs = this.objs;
        int numObjs = this.numObjs;
        for (int x = numObjs - 1; x >= 1; --x) {
            int rand = random.nextInt(x + 1);
            double obj = objs[x];
            objs[x] = objs[rand];
            objs[rand] = obj;
        }
    }

    public void shuffle(MersenneTwisterFast random) {
        double[] objs = this.objs;
        int numObjs = this.numObjs;
        for (int x = numObjs - 1; x >= 1; --x) {
            int rand = random.nextInt(x + 1);
            double obj = objs[x];
            objs[x] = objs[rand];
            objs[rand] = obj;
        }
    }

    public void reverse() {
        double[] objs = this.objs;
        int numObjs = this.numObjs;
        int l = numObjs / 2;
        for (int x = 0; x < l; ++x) {
            double obj = objs[x];
            objs[x] = objs[numObjs - x - 1];
            objs[numObjs - x - 1] = obj;
        }
    }

    public void clear() {
        this.numObjs = 0;
    }

    public void copyIntoArray(int fromStart, double[] to, int toStart, int len) {
        System.arraycopy(this.objs, fromStart, to, toStart, len);
    }

    public double[] toArray() {
        double[] o = new double[this.numObjs];
        System.arraycopy(this.objs, 0, o, 0, this.numObjs);
        return o;
    }

    public Double[] toDoubleArray() {
        Double[] o = new Double[this.numObjs];
        for (int i = 0; i < this.numObjs; ++i) {
            o[i] = new Double(this.objs[i]);
        }
        return o;
    }

    public Class componentType() {
        return Double.TYPE;
    }
}

