/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.Breeder;
import ec.Evaluator;
import ec.Exchanger;
import ec.Finisher;
import ec.Initializer;
import ec.Population;
import ec.Singleton;
import ec.Statistics;
import ec.util.MersenneTwisterFast;
import ec.util.Output;
import ec.util.Parameter;
import ec.util.ParameterDatabase;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class EvolutionState
implements Singleton {
    private static final long serialVersionUID = 1L;
    public ParameterDatabase parameters;
    public MersenneTwisterFast[] random;
    public HashMap[] data;
    public Output output;
    public int breedthreads;
    public int evalthreads;
    public boolean checkpoint;
    public File checkpointDirectory = null;
    public String checkpointPrefix;
    public int checkpointModulo;
    public int randomSeedOffset;
    public boolean quitOnRunComplete;
    public Object[] job;
    public String[] runtimeArguments;
    public static final int UNDEFINED = 0;
    public int generation;
    public int evaluations;
    public int numGenerations = 0;
    public long numEvaluations = 0L;
    public Population population;
    public Initializer initializer;
    public Finisher finisher;
    public Breeder breeder;
    public Evaluator evaluator;
    public Statistics statistics;
    public Exchanger exchanger;
    public long innovationNumber;
    public static final int C_STARTED_FRESH = 0;
    public static final int C_STARTED_FROM_CHECKPOINT = 1;
    public static final int R_SUCCESS = 0;
    public static final int R_FAILURE = 1;
    public static final int R_NOTDONE = 2;
    public static final String P_INITIALIZER = "init";
    public static final String P_FINISHER = "finish";
    public static final String P_BREEDER = "breed";
    public static final String P_EVALUATOR = "eval";
    public static final String P_STATISTICS = "stat";
    public static final String P_EXCHANGER = "exch";
    public static final String P_GENERATIONS = "generations";
    public static final String P_EVALUATIONS = "evaluations";
    public static final String P_QUITONRUNCOMPLETE = "quit-on-run-complete";
    public static final String P_CHECKPOINTPREFIX = "checkpoint-prefix";
    public static final String P_CHECKPOINTMODULO = "checkpoint-modulo";
    public static final String P_CHECKPOINTDIRECTORY = "checkpoint-directory";
    public static final String P_CHECKPOINT = "checkpoint";
    public static final String P_INNOVATIONNUMBER = "innovation-number";
    static final String P_CHECKPOINTPREFIX_OLD = "prefix";
    Object[] lock = new Object[0];

    public void setup(EvolutionState state, Parameter base) {
        this.data = new HashMap[this.random.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new HashMap();
        }
        Parameter p = new Parameter(P_CHECKPOINT);
        this.checkpoint = this.parameters.getBoolean(p, null, false);
        p = new Parameter(P_CHECKPOINTPREFIX);
        this.checkpointPrefix = this.parameters.getString(p, null);
        if (this.checkpointPrefix == null) {
            Parameter p2 = new Parameter(P_CHECKPOINTPREFIX_OLD);
            this.checkpointPrefix = this.parameters.getString(p2, null);
            if (this.checkpointPrefix == null) {
                this.output.fatal("No checkpoint prefix specified.", p);
            } else {
                this.output.warning("The parameter \"prefix\" is deprecated.  Please use \"checkpoint-prefix\".", p2);
            }
        } else {
            Parameter p2 = new Parameter(P_CHECKPOINTPREFIX_OLD);
            if (this.parameters.getString(p2, null) != null) {
                this.output.warning("You have BOTH the deprecated parameter \"prefix\" and its replacement \"checkpoint-prefix\" defined.  The replacement will be used,  Please remove the \"prefix\" parameter.", p2);
            }
        }
        p = new Parameter(P_CHECKPOINTMODULO);
        this.checkpointModulo = this.parameters.getInt(p, null, 1);
        if (this.checkpointModulo == 0) {
            this.output.fatal("The checkpoint modulo must be an integer >0.", p);
        }
        if (this.parameters.exists(p = new Parameter(P_CHECKPOINTDIRECTORY), null)) {
            this.checkpointDirectory = this.parameters.getFile(p, null);
            if (this.checkpointDirectory == null) {
                this.output.fatal("The checkpoint directory name is invalid: " + this.checkpointDirectory, p);
            }
            if (!this.checkpointDirectory.isDirectory()) {
                this.output.fatal("The checkpoint directory location is not a directory: " + this.checkpointDirectory, p);
            }
        } else {
            this.checkpointDirectory = null;
        }
        if (this.parameters.exists(p = new Parameter(P_EVALUATIONS), null)) {
            this.numEvaluations = this.parameters.getInt(p, null, 1);
            if (this.numEvaluations <= 0L) {
                this.output.fatal("If defined, the number of evaluations must be an integer >= 1", p, null);
            }
        }
        if (this.parameters.exists(p = new Parameter(P_GENERATIONS), null)) {
            this.numGenerations = this.parameters.getInt(p, null, 1);
            if (this.numGenerations <= 0) {
                this.output.fatal("If defined, the number of generations must be an integer >= 1.", p, null);
            }
        }
        if (this.numEvaluations != 0L && this.numGenerations != 0) {
            state.output.warning("Both generations and evaluations defined: whichever happens first is when ECJ will stop.");
        } else if (this.numEvaluations == 0L && this.numGenerations == 0) {
            this.output.fatal("Either evaluations or generations must be defined.", new Parameter(P_GENERATIONS), new Parameter(P_EVALUATIONS));
        }
        p = new Parameter(P_QUITONRUNCOMPLETE);
        this.quitOnRunComplete = this.parameters.getBoolean(p, null, false);
        p = new Parameter(P_INITIALIZER);
        this.initializer = (Initializer)this.parameters.getInstanceForParameter(p, null, Initializer.class);
        this.initializer.setup(this, p);
        p = new Parameter(P_FINISHER);
        this.finisher = (Finisher)this.parameters.getInstanceForParameter(p, null, Finisher.class);
        this.finisher.setup(this, p);
        p = new Parameter(P_BREEDER);
        this.breeder = (Breeder)this.parameters.getInstanceForParameter(p, null, Breeder.class);
        this.breeder.setup(this, p);
        p = new Parameter(P_EVALUATOR);
        this.evaluator = (Evaluator)this.parameters.getInstanceForParameter(p, null, Evaluator.class);
        this.evaluator.setup(this, p);
        p = new Parameter(P_STATISTICS);
        this.statistics = (Statistics)this.parameters.getInstanceForParameterEq(p, null, Statistics.class);
        this.statistics.setup(this, p);
        p = new Parameter(P_EXCHANGER);
        this.exchanger = (Exchanger)this.parameters.getInstanceForParameter(p, null, Exchanger.class);
        this.exchanger.setup(this, p);
        p = new Parameter(P_INNOVATIONNUMBER);
        this.innovationNumber = this.parameters.getLong(p, null, Long.MIN_VALUE);
        this.generation = 0;
    }

    public void resetFromCheckpoint() throws IOException {
        this.output.restart();
        this.exchanger.reinitializeContacts(this);
        this.evaluator.reinitializeContacts(this);
    }

    public void finish(int result) {
    }

    public void startFromCheckpoint() {
    }

    public void startFresh() {
    }

    public int evolve() throws InternalError {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void synchronizedIncrementEvaluations(int val) {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            this.evaluations += val;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void incrementEvaluations(int val) {
        if (this.evalthreads == 1) {
            this.evaluations += val;
        } else {
            this.synchronizedIncrementEvaluations(val);
        }
    }

    public void run(int condition) {
        if (condition == 0) {
            this.startFresh();
        } else {
            this.startFromCheckpoint();
        }
        int result = 2;
        while (result == 2) {
            result = this.evolve();
        }
        this.finish(result);
    }
}

