/*
 * Decompiled with CFR 0.152.
 */
package ec.app.coevolve2;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.app.ecsuite.ECSuite;
import ec.coevolve.GroupedProblemForm;
import ec.simple.SimpleFitness;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;
import java.util.ArrayList;

public class CoevolutionaryECSuite
extends ECSuite
implements GroupedProblemForm {
    public static final String P_SHOULD_SET_CONTEXT = "set-context";
    boolean shouldSetContext;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.shouldSetContext = state.parameters.getBoolean(base.push(P_SHOULD_SET_CONTEXT), null, true);
    }

    public void preprocessPopulation(EvolutionState state, Population pop, boolean[] prepareForAssessment, boolean countVictoriesOnly) {
        for (int i = 0; i < pop.subpops.size(); ++i) {
            if (!prepareForAssessment[i]) continue;
            for (int j = 0; j < pop.subpops.get((int)i).individuals.size(); ++j) {
                ((SimpleFitness)pop.subpops.get((int)i).individuals.get((int)j).fitness).trials = new ArrayList();
            }
        }
    }

    public int postprocessPopulation(EvolutionState state, Population pop, boolean[] assessFitness, boolean countVictoriesOnly) {
        int total = 0;
        for (int i = 0; i < pop.subpops.size(); ++i) {
            if (!assessFitness[i]) continue;
            for (int j = 0; j < pop.subpops.get((int)i).individuals.size(); ++j) {
                SimpleFitness fit = (SimpleFitness)pop.subpops.get((int)i).individuals.get((int)j).fitness;
                double max = Double.NEGATIVE_INFINITY;
                int len = fit.trials.size();
                for (int l = 0; l < len; ++l) {
                    max = Math.max((Double)fit.trials.get(l), max);
                }
                fit.setFitness(state, max, this.isOptimal(this.problemType, max));
                pop.subpops.get((int)i).individuals.get((int)j).evaluated = true;
                ++total;
            }
        }
        return total;
    }

    public void evaluate(EvolutionState state, Individual[] ind, boolean[] updateFitness, boolean countVictoriesOnly, int[] subpops, int threadnum) {
        if (ind.length == 0) {
            state.output.fatal("Number of individuals provided to CoevolutionaryECSuite is 0!");
        }
        if (ind.length == 1) {
            state.output.warnOnce("Coevolution used, but number of individuals provided to CoevolutionaryECSuite is 1.");
        }
        int size = 0;
        for (int i = 0; i < ind.length; ++i) {
            if (!(ind[i] instanceof DoubleVectorIndividual)) {
                state.output.error("Individual " + i + "in coevolution is not a DoubleVectorIndividual.");
                continue;
            }
            DoubleVectorIndividual coind = (DoubleVectorIndividual)ind[i];
            size += coind.genome.length;
        }
        state.output.exitIfErrors();
        double[] vals = new double[size];
        int pos = 0;
        for (int i = 0; i < ind.length; ++i) {
            DoubleVectorIndividual coind = (DoubleVectorIndividual)ind[i];
            System.arraycopy(coind.genome, 0, vals, pos, coind.genome.length);
            pos += coind.genome.length;
        }
        double trial = this.function(state, this.problemType, vals, threadnum);
        for (int i = 0; i < ind.length; ++i) {
            DoubleVectorIndividual coind = (DoubleVectorIndividual)ind[i];
            if (!updateFitness[i]) continue;
            int len = coind.fitness.trials.size();
            if (len == 0) {
                if (this.shouldSetContext) {
                    coind.fitness.setContext(ind, i);
                }
                coind.fitness.trials.add(new Double(trial));
            } else if ((Double)coind.fitness.trials.get(0) < trial) {
                if (this.shouldSetContext) {
                    coind.fitness.setContext(ind, i);
                }
                Double t = (Double)coind.fitness.trials.get(0);
                coind.fitness.trials.set(0, new Double(trial));
                coind.fitness.trials.add(t);
            }
            ((SimpleFitness)coind.fitness).setFitness(state, trial, false);
        }
    }
}

