/*
 * Decompiled with CFR 0.152.
 */
package ec.app.gui;

import ec.EvolutionState;
import ec.Fitness;
import ec.display.chart.XYSeriesChartStatistics;
import ec.util.Parameter;

public class SimpleXYSeriesChartStatistics
extends XYSeriesChartStatistics {
    private int[] seriesID;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        int numSubPops = state.parameters.getInt(new Parameter("pop.subpops"), null);
        this.seriesID = new int[numSubPops];
        for (int i = 0; i < numSubPops; ++i) {
            this.seriesID[i] = this.addSeries("SubPop " + i);
        }
    }

    public void postEvaluationStatistics(EvolutionState state) {
        super.postEvaluationStatistics(state);
        for (int subPop = 0; subPop < state.population.subpops.size(); ++subPop) {
            Fitness bestFit = state.population.subpops.get((int)subPop).individuals.get((int)0).fitness;
            for (int i = 1; i < state.population.subpops.get((int)subPop).individuals.size(); ++i) {
                Fitness fit = state.population.subpops.get((int)subPop).individuals.get((int)i).fitness;
                if (!fit.betterThan(bestFit)) continue;
                bestFit = fit;
            }
            this.addDataPoint(this.seriesID[subPop], state.generation, bestFit.fitness());
        }
    }
}

