/*
 * Decompiled with CFR 0.152.
 */
package ec.app.mona;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.app.mona.Picture;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;
import java.io.File;

public class Mona
extends Problem
implements SimpleProblemForm {
    public static final String P_IN = "in";
    public static final String P_OUT = "out";
    public static final String P_VERTICES = "num-vertices";
    public static final String P_HEADLESS = "headless";
    public Picture pic;
    public File in;
    public File out;
    public int numVertices;
    public boolean headless;

    public Object clone() {
        Mona m = (Mona)super.clone();
        m.pic = (Picture)this.pic.clone();
        return m;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.in = state.parameters.getFile(base.push(P_IN), null);
        this.out = state.parameters.getFile(base.push(P_OUT), null);
        this.numVertices = state.parameters.getInt(base.push(P_VERTICES), null, 3);
        if (this.numVertices < 3) {
            state.output.fatal("Number of vertices must be >= 3");
        }
        this.headless = state.parameters.getBoolean(base.push(P_HEADLESS), null, false);
        this.pic = new Picture(this.headless);
        this.pic.load(this.in);
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        double error;
        if (ind.evaluated) {
            return;
        }
        DoubleVectorIndividual _ind = (DoubleVectorIndividual)ind;
        int vertexSkip = this.numVertices * 2 + 4;
        this.pic.clear();
        for (int i = 0; i < _ind.genome.length; i += vertexSkip) {
            this.pic.addPolygon(_ind.genome, i, this.numVertices);
        }
        ((SimpleFitness)_ind.fitness).setFitness(state, 1.0 - error, (error = this.pic.error()) == 0.0);
        ind.evaluated = true;
    }

    public void finishEvaluating(EvolutionState state, int threadnum) {
        this.pic.disposeGraphics();
    }

    public void describe(EvolutionState state, Individual ind, int threadnum, int subpopulation, int log) {
        ind.evaluated = false;
        this.evaluate(state, ind, subpopulation, threadnum);
        this.pic.save(new File(this.out.getParentFile(), "" + state.generation + "-" + this.out.getName()));
        if (!this.headless) {
            this.pic.display("Best So Far, Generation " + state.generation);
        }
        ind.evaluated = true;
    }
}

