/*
 * Decompiled with CFR 0.152.
 */
package ec.app.moosuite;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.multiobjective.MultiObjectiveFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;

public class MooSuite
extends Problem
implements SimpleProblemForm {
    private static final long serialVersionUID = 1L;
    public static final String P_WHICH_PROBLEM = "type";
    public static final String P_ZDT1 = "zdt1";
    public static final String P_ZDT2 = "zdt2";
    public static final String P_ZDT3 = "zdt3";
    public static final String P_ZDT4 = "zdt4";
    public static final String P_ZDT6 = "zdt6";
    public static final String P_SPHERE = "sphere";
    public static final String P_SCH = "sch";
    public static final String P_FON = "fon";
    public static final String P_QV = "qv";
    public static final String P_POL = "pol";
    public static final String P_KUR = "kur";
    public static final String P_F1 = "f1";
    public static final String P_F2 = "f2";
    public static final String P_F3 = "unconstrained-f3";
    public static final int PROB_SPHERE = 0;
    public static final int PROB_ZDT1 = 1;
    public static final int PROB_ZDT2 = 2;
    public static final int PROB_ZDT3 = 3;
    public static final int PROB_ZDT4 = 4;
    public static final int PROB_ZDT6 = 6;
    public static final int PROB_FON = 7;
    public static final int PROB_POL = 8;
    public static final int PROB_KUR = 9;
    public static final int PROB_QV = 10;
    public static final int PROB_SCH = 11;
    public static final int PROB_F2 = 12;
    public static final int PROB_F3 = 13;
    public int problemType = 1;
    private static final double TWO_PI = Math.PI * 2;
    private static final double TEN_PI = Math.PI * 10;
    private static final double FOUR_PI = Math.PI * 4;
    private static final double SIX_PI = Math.PI * 6;
    private static final double ONE_OVER_SQRT_3 = 1.0 / Math.sqrt(3.0);
    private static final double A1 = 0.5 * Math.sin(1.0) - 2.0 * Math.cos(1.0) + Math.sin(2.0) - 1.5 * Math.cos(2.0);
    private static final double A2 = 1.5 * Math.sin(1.0) - Math.cos(1.0) + 2.0 * Math.sin(2.0) - 0.5 * Math.cos(2.0);

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        String wp = state.parameters.getStringWithDefault(base.push(P_WHICH_PROBLEM), null, "");
        if (wp.compareTo(P_ZDT1) == 0) {
            this.problemType = 1;
        } else if (wp.compareTo(P_ZDT2) == 0) {
            this.problemType = 2;
        } else if (wp.compareTo(P_ZDT3) == 0) {
            this.problemType = 3;
        } else if (wp.compareTo(P_ZDT4) == 0) {
            this.problemType = 4;
        } else if (wp.compareTo(P_ZDT6) == 0) {
            this.problemType = 6;
        } else if (wp.compareTo(P_FON) == 0) {
            this.problemType = 7;
        } else if (wp.compareTo(P_POL) == 0) {
            this.problemType = 8;
        } else if (wp.compareTo(P_QV) == 0) {
            this.problemType = 10;
        } else if (wp.compareTo(P_KUR) == 0) {
            this.problemType = 9;
        } else if (wp.compareTo(P_SPHERE) == 0) {
            this.problemType = 0;
        } else if (wp.compareTo(P_F2) == 0) {
            this.problemType = 12;
        } else if (wp.compareTo(P_F3) == 0) {
            this.problemType = 13;
        } else if (wp.compareTo(P_SCH) == 0 || wp.compareTo(P_F1) == 0) {
            this.problemType = 11;
        } else {
            state.output.fatal("Invalid value for parameter, or parameter not found.\nAcceptable values are:\n  zdt1\n  zdt2\n  zdt3\n  zdt4\n  zdt6\n  pol\n  fon\n  kur\n  sphere\n  sch(or f1)\n  f2\n\nAre you by any chance running moosuite.params?  Instead\nYou should be running one of the params files for these\nspecific problems, such as zdt2.params.\n", base.push(P_WHICH_PROBLEM));
        }
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!(ind instanceof DoubleVectorIndividual)) {
            state.output.fatal("The individuals for this problem should be DoubleVectorIndividuals.");
        }
        DoubleVectorIndividual temp = (DoubleVectorIndividual)ind;
        double[] genome = temp.genome;
        int numDecisionVars = genome.length;
        double[] objectives = ((MultiObjectiveFitness)ind.fitness).getObjectives();
        switch (this.problemType) {
            case 1: {
                double f;
                objectives[0] = f = genome[0];
                double sum = 0.0;
                for (int i = 1; i < numDecisionVars; ++i) {
                    sum += genome[i];
                }
                double g = 1.0 + 9.0 * sum / ((double)numDecisionVars - 1.0);
                double h = 1.0 - Math.sqrt(f / g);
                objectives[1] = g * h;
                break;
            }
            case 2: {
                double f;
                objectives[0] = f = genome[0];
                double sum = 0.0;
                for (int i = 1; i < numDecisionVars; ++i) {
                    sum += genome[i];
                }
                double g = 1.0 + 9.0 * sum / ((double)numDecisionVars - 1.0);
                double h = 1.0 - f / g * (f / g);
                objectives[1] = g * h;
                break;
            }
            case 3: {
                double f;
                objectives[0] = f = genome[0];
                double sum = 0.0;
                for (int i = 1; i < numDecisionVars; ++i) {
                    sum += genome[i];
                }
                double g = 1.0 + 9.0 * sum / ((double)numDecisionVars - 1.0);
                double foverg = f / g;
                double h = 1.0 - Math.sqrt(foverg) - foverg * Math.sin(Math.PI * 10 * f);
                objectives[1] = g * h;
                break;
            }
            case 4: {
                double f;
                objectives[0] = f = genome[0];
                double sum = 0.0;
                for (int i = 1; i < numDecisionVars; ++i) {
                    sum += genome[i] * genome[i] - 10.0 * Math.cos(Math.PI * 4 * genome[i]);
                }
                double g = 1.0 + 10.0 * ((double)numDecisionVars - 1.0) + sum;
                double h = 1.0 - Math.sqrt(f / g);
                objectives[1] = g * h;
                break;
            }
            case 6: {
                double f;
                objectives[0] = f = 1.0 - Math.exp(-4.0 * genome[0]) * Math.pow(Math.sin(Math.PI * 6 * genome[0]), 6.0);
                double sum = 0.0;
                for (int i = 1; i < numDecisionVars; ++i) {
                    sum += genome[i];
                }
                double g = 1.0 + 9.0 * Math.pow(sum / ((double)numDecisionVars - 1.0), 0.25);
                double h = 1.0 - Math.pow(f / g, 2.0);
                objectives[1] = g * h;
                break;
            }
            case 0: {
                int numObjectives = objectives.length;
                for (int j = 0; j < numObjectives; ++j) {
                    double sum = (genome[j] - 1.0) * (genome[j] - 1.0);
                    for (int i = 0; i < numDecisionVars; ++i) {
                        if (i == j) continue;
                        sum += genome[i] * genome[i];
                    }
                    objectives[j] = sum;
                }
                break;
            }
            case 11: {
                if (numDecisionVars != 1) {
                    throw new RuntimeException("SCH needs exactly 1 decision variable (gene).");
                }
                double x = genome[0];
                objectives[0] = x * x;
                objectives[1] = (x - 2.0) * (x - 2.0);
                break;
            }
            case 12: {
                if (numDecisionVars != 1) {
                    throw new RuntimeException("F2 needs exactly 1 decision variable (gene).");
                }
                double x = genome[0];
                objectives[0] = x <= 1.0 ? -x : (x <= 3.0 ? x - 2.0 : (x <= 4.0 ? 4.0 - x : x - 4.0));
                objectives[1] = (x - 5.0) * (x - 5.0);
                break;
            }
            case 13: {
                if (numDecisionVars != 2) {
                    throw new RuntimeException("F3 needs exactly 2 decision variable (gene).");
                }
                double x1 = genome[0];
                double x2 = genome[1];
                objectives[0] = (x1 - 2.0) * (x1 - 2.0) + (x2 - 1.0) * (x2 - 1.0) + 2.0;
                objectives[1] = 9.0 * x1 - (x2 - 1.0) * (x2 - 1.0);
                break;
            }
            case 7: {
                if (numDecisionVars != 3) {
                    throw new RuntimeException("FON needs exactly 3 decision variables (genes).");
                }
                double sum1 = 0.0;
                double sum2 = 0.0;
                for (int i = 0; i < numDecisionVars; ++i) {
                    double xi = genome[i];
                    double d = xi - ONE_OVER_SQRT_3;
                    double s = xi + ONE_OVER_SQRT_3;
                    sum1 += d * d;
                    sum2 += s * s;
                }
                objectives[0] = 1.0 - Math.exp(-sum1);
                objectives[1] = 1.0 - Math.exp(-sum2);
                break;
            }
            case 8: {
                if (numDecisionVars != 2) {
                    throw new RuntimeException("POL needs exactly 2 decision variables (genes).");
                }
                double x1 = genome[0];
                double x2 = genome[1];
                double b1 = 0.5 * Math.sin(x1) - 2.0 * Math.cos(x1) + Math.sin(x2) - 1.5 * Math.cos(x2);
                double b2 = 1.5 * Math.sin(x1) - Math.cos(x1) + 2.0 * Math.sin(x2) - 0.5 * Math.cos(x2);
                objectives[0] = 1.0 + (A1 - b1) * (A1 - b1) + (A2 - b2) * (A2 - b2);
                objectives[1] = (x1 + 3.0) * (x1 + 3.0) + (x2 + 1.0) * (x2 + 1.0);
                break;
            }
            case 10: {
                double xi;
                int i;
                double sum = 0.0;
                for (i = 0; i < numDecisionVars; ++i) {
                    xi = genome[i];
                    sum += xi * xi - 10.0 * Math.cos(Math.PI * 2 * xi) + 10.0;
                }
                objectives[0] = Math.pow(sum / (double)numDecisionVars, 0.25);
                sum = 0.0;
                for (i = 0; i < numDecisionVars; ++i) {
                    xi = genome[i] - 1.5;
                    sum += xi * xi - 10.0 * Math.cos(Math.PI * 2 * xi) + 10.0;
                }
                objectives[1] = Math.pow(sum / (double)numDecisionVars, 0.25);
                break;
            }
            case 9: {
                double sum = 0.0;
                for (int i = 0; i < numDecisionVars; ++i) {
                    double t1 = Math.pow(Math.abs(genome[i]), 0.8);
                    double t2 = 5.0 * Math.pow(Math.sin(genome[i]), 3.0);
                    sum += t1 + t2 + 3.5828;
                }
                objectives[0] = sum;
                double thisSquared = genome[0] * genome[0];
                sum = 0.0;
                for (int i = 0; i < numDecisionVars - 1; ++i) {
                    double nextSquared = genome[i + 1] * genome[i + 1];
                    sum += 1.0 - Math.exp(-0.2 * Math.sqrt(thisSquared + nextSquared));
                    thisSquared = nextSquared;
                }
                objectives[1] = sum;
                break;
            }
            default: {
                state.output.fatal(this.getClass().getSimpleName() + " has an invalid problem -- how on earth did that happen?");
            }
        }
        ((MultiObjectiveFitness)ind.fitness).setObjectives(state, objectives);
        ind.evaluated = true;
    }
}

