/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.breed.BreedDefaults;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckingPipeline
extends BreedingPipeline {
    public static final String P_CHECK = "check";
    public static final String P_NUMTIMES = "num-times";
    public static final int NUM_SOURCES = 2;
    int numTimes = 0;

    @Override
    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_CHECK);
    }

    @Override
    public int numSources() {
        return 2;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.numTimes = state.parameters.getInt(base.push(P_NUMTIMES), def.push(P_NUMTIMES), 1);
        if (this.numTimes < 1) {
            state.output.fatal("CheckingPipeline must have a num-times value >= 1.", base.push(P_NUMTIMES), def.push(P_NUMTIMES));
        }
        if (this.likelihood != 1.0) {
            state.output.warning("CheckingPipeline given a likelihood other than 1.0.  This is nonsensical and will be ignored.", base.push("likelihood"), def.push("likelihood"));
        }
    }

    public boolean allValid(ArrayList<Individual> inds, int numInds, int subpopulation, EvolutionState state, int thread) {
        return true;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        ArrayList<Individual> inds2 = new ArrayList<Individual>();
        for (int i = 0; i < this.numTimes; ++i) {
            int n = this.sources[0].produce(min, max, subpopulation, inds2, state, thread, misc);
            if (this.allValid(inds2, n, subpopulation, state, thread)) {
                inds.addAll(inds2);
                return n;
            }
            inds2.clear();
        }
        int n = this.sources[1].produce(min, max, subpopulation, inds, state, thread, misc);
        return n;
    }
}

